/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.operations;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.operations.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class BuildResultUpdater {
    private static final String ELIPSIS = "...";
    private static final int MAX_LABEL_LENGTH = 250 - "...".length();
    private IBuildResultHandle _buildResultHandle;
    private ITeamRepository _repo;
    private UUID _buildResultUuid;
    private int _stackTraces = 0;
    private String _topLevelActivityId = null;

    public BuildResultUpdater(ITeamRepository repo, String buildResultUuidString) {
        this._repo = repo;
        this._buildResultUuid = UUID.valueOf((String)buildResultUuidString);
        this._buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(this._buildResultUuid, null);
    }

    public void contributeExceptionStackTrace(Throwable exceptionToContribute) {
        try {
            ByteArrayInputStream trace = this.getStackTraceInputStream(exceptionToContribute);
            IContent traceContent = this._repo.contentManager().storeContent("text/plain", "UTF-8", LineDelimiter.LINE_DELIMITER_NONE, (InputStream)trace, null, null);
            String tag = Messages.BuildResultUpdater_SYNC_STACK_TRACE;
            String fileName = NLS.bind((String)Messages.BuildResultUpdater_SYNC_STACK_TRACE_WITH_FILENAME, (Object)String.valueOf(this._stackTraces++));
            this.contributeContent(traceContent, tag, fileName);
        }
        catch (Exception exceptionToLog) {
            exceptionToLog.printStackTrace();
        }
    }

    private void contributeContent(IContent traceContent, String label, String fileName) throws Exception {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setLabel(label);
        contribution.setImpactsPrimaryResult(true);
        contribution.setStatus(BuildStatus.ERROR);
        contribution.setExtendedContributionTypeId(IBuildResultContribution.LOG_EXTENDED_CONTRIBUTION_ID);
        contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME, fileName);
        contribution.setExtendedContributionData(traceContent);
        this.getTeamBuildClient().addBuildResultContribution(this.getBuildResultHandle(), contribution, null);
    }

    private ByteArrayInputStream getStackTraceInputStream(Throwable e) throws UnsupportedEncodingException {
        ByteArrayOutputStream traceBytes = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)traceBytes, "UTF-8");
        PrintWriter traceWriter = new PrintWriter(writer);
        e.printStackTrace(traceWriter);
        traceWriter.flush();
        return new ByteArrayInputStream(traceBytes.toByteArray());
    }

    public void setCompletionStatus(boolean syncEndedWithoutConflicts) throws WvcmException {
        if (!syncEndedWithoutConflicts) {
            IBuildResult result = (IBuildResult)this.getBuildResult(null).getWorkingCopy();
            result.setStatus(BuildStatus.WARNING);
            try {
                this.getTeamBuildClient().save(result, null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    private ITeamBuildClient getTeamBuildClient() {
        return (ITeamBuildClient)this._repo.getClientLibrary(ITeamBuildClient.class);
    }

    private void startActivity(String parent, String name) {
        if (name != null) {
            if (name.length() > MAX_LABEL_LENGTH) {
                name = String.valueOf(name.substring(0, MAX_LABEL_LENGTH)) + ELIPSIS;
            }
            try {
                String activityId = this.getTeamBuildClient().startBuildActivity(this.getBuildResultHandle(), name, parent, true, null);
                if (parent == null) {
                    this._topLevelActivityId = activityId;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    public void startTopLevelActivity(String name) {
        this.startActivity(null, name);
    }

    public void startNestedActivity(String name) {
        if (this._topLevelActivityId != null) {
            this.startActivity(this._topLevelActivityId, name);
        }
    }

    protected final IBuildResult getBuildResult(String[] properties) throws WvcmException {
        try {
            IBuildResultHandle resultHandle = this.getBuildResultHandle();
            IItemManager itemManager = this._repo.itemManager();
            if (properties == IBuildResult.PROPERTIES_COMPLETE) {
                return (IBuildResult)itemManager.fetchCompleteItem((IItemHandle)resultHandle, 1, null);
            }
            return (IBuildResult)itemManager.fetchPartialItem((IItemHandle)resultHandle, 1, (Collection)Arrays.asList(properties), null);
        }
        catch (TeamRepositoryException e) {
            String msg = NLS.bind((String)Messages.BuildResultUpdater_ERROR_ITEM_WITH_ID_NOT_FOUND, (Object)IBuildResult.ITEM_TYPE.getName(), (Object)this._buildResultUuid);
            throw new WvcmException(msg, null, JzRepoException.exceptionToReasonCode((Exception)((Object)e)), (Throwable)e);
        }
    }

    private IBuildResultHandle getBuildResultHandle() {
        return this._buildResultHandle;
    }
}

