/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.auth;

import com.ibm.team.repository.transport.auth.Messages;
import com.ibm.team.repository.transport.auth.TransportAuthException;
import java.text.MessageFormat;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public class TransportAuthUtil {
    public static final String X_NO_RETRY_HEADER = "X-com-ibm-team-repository.common.remoteaccess.noRetry";
    public static final String FORM_AUTH_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    public static final String FORM_AUTH_REQUIRED_MSG = "authrequired";
    public static final String FORM_AUTH_FAILED_MSG = "authfailed";
    public static final String FORM_AUTH_URI = "j_security_check";
    public static final String FORM_AUTH_USER_FIELD = "j_username";
    public static final String FORM_AUTH_PASSWORD_FIELD = "j_password";
    public static final String FORM_LOGOUT_URI = "/auth/logout";
    public static final String FORM_AUTH_FAILED_URI = "/auth/authfailed";
    public static final String FORM_AUTH_REQUESTED_URI = "/auth/authrequired";
    public static final String FORM_AUTH = "FORM";
    public static final String BASIC_AUTH = "BASIC";
    public static final String LOCATION = "Location";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded; charset=utf-8";
    public static final String SLASH = "/";
    private static final String NLS_UNEXPECTED_LOGIN_ERROR = "TransportAuthUtil.UnexpectedLoginError";
    private static final String NLS_UNEXPECTED_STATUS = "TransportAuthUtil.UnexpectedStatus";
    private static final String NLS_INVALID_CREDENTIALS = "TransportAuthUtil.InvalidCredentials";
    private static final String NLS_SERVLET_ERROR = "TransportAuthUtil.ServletError";
    private static final String NLS_SERVER_CONFIG_ERROR = "TransportAuthUtil.ServerConfigError";
    private static final String NLS_LOGIN_ERROR = "TransportAuthUtil.LoginError";

    public static boolean formAuthRequested(HttpMethod method) {
        Header formAuthMsg = method.getResponseHeader(FORM_AUTH_HEADER);
        Header locationHeader = method.getResponseHeader(LOCATION);
        return formAuthMsg != null && formAuthMsg.getValue().equals(FORM_AUTH_REQUIRED_MSG) || locationHeader != null && locationHeader.getValue().matches("^.*/auth/authrequired.*$");
    }

    public static void formBasedAuthenticate(String repoPath, HttpClient httpClient, UsernamePasswordCredentials storedCredentials) throws TransportAuthException {
        block12: {
            if (!repoPath.endsWith(SLASH)) {
                repoPath = String.valueOf(repoPath) + SLASH;
            }
            repoPath = String.valueOf(repoPath) + FORM_AUTH_URI;
            PostMethod postMethod = new PostMethod(repoPath);
            try {
                postMethod.addParameter(FORM_AUTH_USER_FIELD, storedCredentials.getUserName());
                postMethod.addParameter(FORM_AUTH_PASSWORD_FIELD, storedCredentials.getPassword());
                postMethod.setRequestHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_FORM_URLENCODED);
                try {
                    int rc = httpClient.executeMethod((HttpMethod)postMethod);
                    Header authHeader = postMethod.getResponseHeader(FORM_AUTH_HEADER);
                    if (authHeader != null) {
                        if (authHeader.getValue().equals(FORM_AUTH_REQUIRED_MSG)) {
                            throw new TransportAuthException(MessageFormat.format(Messages.getString(NLS_SERVER_CONFIG_ERROR), FORM_AUTH_URI));
                        }
                        if (authHeader.getValue().equals(FORM_AUTH_FAILED_MSG)) {
                            throw new TransportAuthException(Messages.getString(NLS_INVALID_CREDENTIALS));
                        }
                        throw new TransportAuthException(MessageFormat.format(Messages.getString(NLS_SERVLET_ERROR), FORM_AUTH_REQUIRED_MSG, FORM_AUTH_FAILED_MSG, authHeader.getValue()));
                    }
                    if (rc == 302) {
                        String redirectURI = postMethod.getResponseHeader(LOCATION).getValue();
                        if (redirectURI.matches("^.*/auth/authfailed.*$")) {
                            throw new TransportAuthException(Messages.getString(NLS_INVALID_CREDENTIALS));
                        }
                        break block12;
                    }
                    String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_STATUS), repoPath, 302, rc);
                    throw new TransportAuthException(msg);
                }
                catch (Exception e) {
                    if (e.getClass().equals(TransportAuthException.class)) {
                        throw (TransportAuthException)e;
                    }
                    String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                    throw new TransportAuthException(msg, e);
                }
            }
            finally {
                postMethod.releaseConnection();
            }
        }
    }

    public static String determineAuthMethod(HttpClient httpClient, String repoPath) throws TransportAuthException {
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient must not be null");
        }
        if (repoPath == null) {
            throw new IllegalArgumentException("repoPath must not be null");
        }
        if (!repoPath.endsWith(SLASH)) {
            repoPath = String.valueOf(repoPath) + SLASH;
        }
        repoPath = String.valueOf(repoPath) + FORM_AUTH_URI;
        GetMethod formAuth = new GetMethod(repoPath);
        String serverAuthMethod = null;
        formAuth.setFollowRedirects(false);
        try {
            try {
                int rc = httpClient.executeMethod((HttpMethod)formAuth);
                serverAuthMethod = rc == 200 ? FORM_AUTH : (rc == 302 && formAuth.getResponseHeader("location").getValue().matches("^.*/auth/authfailed.*$") ? FORM_AUTH : BASIC_AUTH);
            }
            catch (Exception e) {
                throw new TransportAuthException(MessageFormat.format(Messages.getString(NLS_LOGIN_ERROR), e.getMessage()), e);
            }
            String string = serverAuthMethod;
            return string;
        }
        finally {
            formAuth.releaseConnection();
        }
    }

    public static void setCredentials(HttpClient httpClient, AuthScope authScope, String userid, String password) {
        if (userid == null || password == null) {
            httpClient.getState().clearCredentials();
            HttpClientParams httpClientParams = httpClient.getParams();
            httpClientParams.setAuthenticationPreemptive(false);
        } else {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(userid, password);
            httpClient.getState().setCredentials(authScope, (Credentials)defaultcreds);
            httpClient.getState().clearCookies();
            HttpClientParams httpClientParams = httpClient.getParams();
            httpClientParams.setAuthenticationPreemptive(true);
        }
    }

    public static boolean credDefined(UsernamePasswordCredentials storedCredentials) {
        String storedUsername = null;
        String storedPassword = null;
        if (storedCredentials != null) {
            storedUsername = storedCredentials.getUserName();
            storedPassword = storedCredentials.getPassword();
        }
        return storedUsername != null && storedUsername.length() != 0 && storedPassword != null && storedPassword.length() != 0;
    }
}

