/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.process.ProcessProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliverOperationData {
    private final IWorkspace fSourceWorkspace;
    private final IWorkspace fDestWorkspace;
    private final List<IBaselineHandle> fBaselines;
    private final List<IChangeSetHandle> fChangeSets;
    private final ProcessProxy proxy;

    public DeliverOperationData(ProcessProxy proxy, IWorkspace sourceWorkspace, IWorkspace destWorkspace, IBaselineHandle[] baselines, IChangeSetHandle[] changeSetHandles) {
        this.proxy = proxy;
        this.fSourceWorkspace = sourceWorkspace;
        this.fDestWorkspace = destWorkspace;
        this.fBaselines = new ArrayList<IBaselineHandle>();
        this.fBaselines.addAll((Collection<IBaselineHandle>)Arrays.asList(baselines));
        this.fChangeSets = new ArrayList<IChangeSetHandle>();
        this.fChangeSets.addAll((Collection<IChangeSetHandle>)Arrays.asList(changeSetHandles));
    }

    public DeliverOperationData(ProcessProxy proxy, IWorkspace sourceWorkspace, IWorkspace destWorkspace, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSetHandles) {
        this.proxy = proxy;
        this.fSourceWorkspace = sourceWorkspace;
        this.fDestWorkspace = destWorkspace;
        this.fBaselines = baselines;
        this.fChangeSets = changeSetHandles;
    }

    public List<IBaselineHandle> getBaselines() {
        return this.fBaselines;
    }

    public List<IChangeSetHandle> getChangeSetHandles() {
        return this.fChangeSets;
    }

    public IWorkspace getDestWorkspace() {
        return this.fDestWorkspace;
    }

    public IWorkspace getSourceWorkspace() {
        return this.fSourceWorkspace;
    }

    public ProcessProxy getProcessProxy() {
        return this.proxy;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DeliverOperationData) {
            DeliverOperationData other = (DeliverOperationData)object;
            return this.fSourceWorkspace.sameItemId(other.getSourceWorkspace()) && this.fDestWorkspace.sameItemId(other.getDestWorkspace()) && this.equalItemLists(this.fChangeSets, other.getChangeSetHandles()) && this.equalItemLists(this.fBaselines, other.getBaselines());
        }
        return false;
    }

    private boolean equalItemLists(List listA, List listB) {
        if (listA.size() == listB.size()) {
            Iterator iterA = listA.iterator();
            Iterator iterB = listB.iterator();
            while (iterA.hasNext() && iterB.hasNext()) {
                IItemHandle handleB;
                IItemHandle handleA = (IItemHandle)iterA.next();
                if (handleA == (handleB = (IItemHandle)iterB.next()) || handleA != null && handleB != null && handleA.sameItemId(handleB)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

