/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.Messages;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceLocationFactory {
    public static IReference createWorkspaceURI(ItemProvider provider, IWorkspaceHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<String> properties = new ArrayList<String>(2);
        properties.add(IWorkspace.NAME_PROPERTY);
        properties.add(IWorkspace.OWNER_PROPERTY);
        IWorkspace workspace = (IWorkspace)provider.fetchItem((IManagedItemHandle)handle, monitor);
        if (workspace != null) {
            StringBuilder label = new StringBuilder();
            StringBuilder details = new StringBuilder();
            IAuditable auditable = (IAuditable)provider.fetchItem((IManagedItemHandle)workspace.getOwner(), null);
            String name = Messages.getString("WorkspaceLocationFactory.UNKNOWN_OWNER");
            name = auditable instanceof IContributor ? ((IContributor)auditable).getName() : ((ITeamArea)auditable).getName();
            label.append(NLS.bind((String)Messages.getString("WorkspaceLocationFactory.WORKSPACE_OWNER_LABEL_MAIN"), (Object[])new Object[]{workspace.getName(), name}));
            details.append(NLS.bind((String)Messages.getString("WorkspaceLocationFactory.WORKSPACE_OWNER_DETAILS_LABEL"), (Object[])new Object[]{workspace.getName(), name}));
            Location location = Location.itemLocation((IItemHandle)workspace, (String)provider.getRepositoryURI());
            return IReferenceFactory.INSTANCE.createReferenceFromURI(location.toAbsoluteUri(), label.toString());
        }
        return null;
    }
}

