/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.dto.ComponentOperationDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;

public interface IComponentOpDescriptor {
    public static final int ADD = 1;
    public static final int DROP = 2;
    public static final int REPLACE = 3;
    public static final IComponentOpDescriptorFactory FACTORY = new IComponentOpDescriptorFactory(){

        private ComponentOperationDescriptor create(IComponentHandle component, int type, boolean detailed) {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = ScmDtoFactory.eINSTANCE.createComponentOperationDescriptor();
            result.setKind(type);
            result.setComponent(component);
            result.setRequiresDetailedReport(detailed);
            return result;
        }

        public IComponentOpDescriptor addComponent(IComponentHandle component, boolean detailed) {
            ComponentOperationDescriptor result = this.create(component, 1, detailed);
            return result;
        }

        public IComponentOpDescriptor addComponent(IComponentHandle component, IContextHandle seed, boolean detailed) {
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 1, detailed);
            result.setSeed(seed);
            return result;
        }

        public IComponentOpDescriptor dropComponent(IComponentHandle component, boolean detailed) {
            ComponentOperationDescriptor result = this.create(component, 2, detailed);
            return result;
        }

        public IComponentOpDescriptor replaceComponent(IComponentHandle component, IContextHandle seed, boolean detailed) {
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 3, detailed);
            result.setSeed(seed);
            return result;
        }

        public boolean isValid(int kind) {
            return kind >= 1 && kind <= 3;
        }
    };

    public int getKind();

    public IComponentHandle getComponent();

    public boolean requiresDetailedReport();

    public IContextHandle getReplaceOrAddSeed();

    public static interface IComponentOpDescriptorFactory {
        public IComponentOpDescriptor addComponent(IComponentHandle var1, boolean var2);

        public IComponentOpDescriptor addComponent(IComponentHandle var1, IContextHandle var2, boolean var3);

        public IComponentOpDescriptor dropComponent(IComponentHandle var1, boolean var2);

        public IComponentOpDescriptor replaceComponent(IComponentHandle var1, IContextHandle var2, boolean var3);

        public boolean isValid(int var1);
    }
}

