/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.common.internal.impl;

import com.ibm.team.interop.common.IExternalState;
import com.ibm.team.interop.common.IExternalStateHandle;
import com.ibm.team.interop.common.internal.ExternalState;
import com.ibm.team.interop.common.internal.ExternalStateContent;
import com.ibm.team.interop.common.internal.ExternalStateHandle;
import com.ibm.team.interop.common.internal.InteropFactory;
import com.ibm.team.interop.common.internal.InteropPackage;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.model.impl.AuditableImpl;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalStateImpl
extends AuditableImpl
implements ExternalState {
    protected int ALL_FLAGS = 0;
    protected EList contentValues;
    private static final int EOFFSET_CORRECTION = InteropPackage.Literals.EXTERNAL_STATE.getFeatureID((EStructuralFeature)InteropPackage.Literals.EXTERNAL_STATE__CONTENT_VALUES) - 19;
    private static final String EMPTY_STRING = new String();
    private static final String UTF8 = "UTF-8";
    private static final String CONTENT_DESCRIPTOR_FORMAT = "%s|%s|%s|%d|%d";
    private static final String FIELD_SEPARATOR_PATTERN = "\\|";
    private static final int CONTENT_FIELD_LENGTH = 5;

    protected ExternalStateImpl() {
    }

    protected EClass eStaticClass() {
        return InteropPackage.Literals.EXTERNAL_STATE;
    }

    @Override
    public List getContentValues() {
        if (this.contentValues == null) {
            this.contentValues = new EObjectContainmentEList.Unsettable(ExternalStateContent.class, (InternalEObject)this, 19 + EOFFSET_CORRECTION);
        }
        return this.contentValues;
    }

    @Override
    public void unsetContentValues() {
        if (this.contentValues != null) {
            ((InternalEList.Unsettable)this.contentValues).unset();
        }
    }

    @Override
    public boolean isSetContentValues() {
        return this.contentValues != null && ((InternalEList.Unsettable)this.contentValues).isSet();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                return ((InternalEList)this.getContentValues()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                return this.getContentValues();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                this.getContentValues().clear();
                this.getContentValues().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                this.unsetContentValues();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 19: {
                return this.isSetContentValues();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == IExternalStateHandle.class) {
            return -1;
        }
        if (baseClass == ExternalStateHandle.class) {
            return -1;
        }
        if (baseClass == IExternalState.class) {
            return -1;
        }
        if (baseClass == ExternalState.class) {
            switch (baseFeatureID - EOFFSET_CORRECTION) {
                case 19: {
                    return 19 + EOFFSET_CORRECTION;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public Map<String, Object> getState() {
        Set keys = this.getExtensionKeys();
        HashMap<String, Object> state = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            if (!key.startsWith("com.ibm.team.interop.xstate.")) continue;
            state.put(key.substring("com.ibm.team.interop.xstate.".length()), this.getExtensionValue(key));
        }
        return state;
    }

    @Override
    public void setState(Map<String, ?> state) {
        for (Map.Entry<String, ?> entry : state.entrySet()) {
            String key = "com.ibm.team.interop.xstate." + entry.getKey();
            this.unsetExtensionValue(key);
            if (entry.getValue() == null) continue;
            this.setExtensionValue(key, entry.getValue());
        }
    }

    @Override
    public void addContent(IContent content) {
        ExternalStateContent xcontent = InteropFactory.eINSTANCE.createExternalStateContent();
        xcontent.setContent(content);
        this.getContentValues().add(xcontent);
    }

    @Override
    public IContent getContent(UUID contentId) {
        for (ExternalStateContent xcontent : this.getContentValues()) {
            IContent content = xcontent.getContent();
            if (content == null || !content.getContentId().equals((Object)contentId)) continue;
            return content;
        }
        return null;
    }

    @Override
    public String encodeContentDescriptor(IContent content) {
        if (content == null) {
            throw new IllegalArgumentException("content argument must not be null");
        }
        if (content.getLineDelimiter() != LineDelimiter.LINE_DELIMITER_NONE) {
            throw new IllegalArgumentException("Content with specific line delimiter formats not supported");
        }
        return String.format(CONTENT_DESCRIPTOR_FORMAT, content.getContentId().getUuidValue(), content.getContentType(), content.getCharacterEncoding() == null ? EMPTY_STRING : content.getCharacterEncoding(), content.getRawLength(), content.getRawHashCode() == null ? 0L : content.getRawHashCode().getValue());
    }

    @Override
    public IContent decodeContentDescriptor(String contentDescriptor) {
        if (contentDescriptor == null || contentDescriptor.length() == 0) {
            throw new IllegalArgumentException("contentDescriptor argument must not be null or empty");
        }
        String[] fields = contentDescriptor.split(FIELD_SEPARATOR_PATTERN);
        if (fields.length != 5) {
            throw new IllegalArgumentException("Invalid content descriptor encoding: " + contentDescriptor);
        }
        Content content = RepositoryFactory.eINSTANCE.createContent();
        content.setContentId(UUID.valueOf((String)fields[0]));
        content.setContentType(fields[1]);
        content.setCharacterEncoding(fields[2]);
        content.setContentLength(Long.parseLong(fields[3]));
        content.setChecksum(Long.parseLong(fields[4]));
        content.setLineDelimiter(LineDelimiter.LINE_DELIMITER_NONE);
        return content;
    }

    private Object getExtensionValue(String key) {
        if (this.isStringExtensionSet(key)) {
            return this.getStringExtension(key);
        }
        if (this.isMediumStringExtensionSet(key)) {
            return this.getMediumStringExtension(key);
        }
        if (this.isLargeStringExtensionSet(key)) {
            return this.getLargeStringExtension(key);
        }
        if (this.isIntExtensionSet(key)) {
            return this.getIntExtension(key);
        }
        if (this.isLongExtensionSet(key)) {
            return this.getLongExtension(key);
        }
        if (this.isBooleanExtensionSet(key)) {
            return this.getBooleanExtension(key);
        }
        if (this.isTimestampExtensionSet(key)) {
            return this.getTimestampExtension(key);
        }
        throw new RuntimeException(String.format("Unhandled state extension value type for key \"%s\"", key));
    }

    private void setExtensionValue(String key, Object value) {
        if (value == null) {
            this.setStringExtension(key, null);
        } else if (value instanceof Integer) {
            this.setIntExtension(key, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongExtension(key, (Long)value);
        } else if (value instanceof Boolean) {
            this.setBooleanExtension(key, (Boolean)value);
        } else if (value instanceof BigDecimal) {
            this.setBigDecimalExtension(key, (BigDecimal)value);
        } else if (value instanceof Timestamp) {
            this.setTimestampExtension(key, (Timestamp)value);
        } else {
            byte[] bytes;
            String stringValue = value.toString();
            try {
                bytes = stringValue.getBytes(UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Value cannot be encoded as UTF-8", e);
            }
            if ((long)bytes.length <= 250L) {
                this.setStringExtension(key, stringValue);
            } else if ((long)bytes.length <= 1000L) {
                this.setMediumStringExtension(key, stringValue);
            } else if ((long)bytes.length <= 32768L) {
                this.setLargeStringExtension(key, stringValue);
            } else {
                throw new RuntimeException(String.format("String value for \"%s\" is too large", key));
            }
        }
    }

    private void unsetExtensionValue(String key) {
        this.unsetStringExtension(key);
        this.unsetMediumStringExtension(key);
        this.unsetLargeStringExtension(key);
        this.unsetIntExtension(key);
        this.unsetLongExtension(key);
        this.unsetBooleanExtension(key);
        this.unsetTimestampExtension(key);
    }
}

