/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.search;

import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.ide.ui.internal.ResultItem;
import com.ibm.team.fulltext.ide.ui.internal.search.ArtifactSearchResultPage;
import java.text.Collator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class ResultSorter
extends ViewerComparator {
    private ArtifactSearchResultPage.ArtifactColumn fSortBy = ArtifactSearchResultPage.ArtifactColumn.SCORE;
    private int fSortDirection = 1;
    private final Collator fCollator = Collator.getInstance();

    public void setSortBy(ArtifactSearchResultPage.ArtifactColumn column) {
        this.fSortBy = column;
    }

    public ArtifactSearchResultPage.ArtifactColumn getSortBy() {
        return this.fSortBy;
    }

    public void setSortOrder(ArtifactSearchResultPage.SortOrder order) {
        this.fSortDirection = order == ArtifactSearchResultPage.SortOrder.ASCENDING ? -1 : 1;
    }

    public ArtifactSearchResultPage.SortOrder getSortOrder() {
        return this.fSortDirection == -1 ? ArtifactSearchResultPage.SortOrder.ASCENDING : ArtifactSearchResultPage.SortOrder.DESCENDING;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ResultItem item1 = (ResultItem)e1;
        ResultItem item2 = (ResultItem)e2;
        switch (this.fSortBy) {
            case TYPE: {
                return this.compareByType(item1.getResult(), item2.getResult());
            }
            case DETAILS: {
                return this.compareByDetails(item1.getResult(), item2.getResult());
            }
            case NAME: {
                return this.compareByName(item1.getResult(), item2.getResult());
            }
        }
        return this.compareByScore(item1.getResult(), item2.getResult());
    }

    private int compareByScore(IScoredResult e1, IScoredResult e2) {
        return e2.getScore() > e1.getScore() ? 1 * this.fSortDirection : -1 * this.fSortDirection;
    }

    private int compareByType(IScoredResult e1, IScoredResult e2) {
        String type2;
        String type1 = e1.getResult().getType();
        int score = this.fCollator.compare(type1, type2 = e2.getResult().getType());
        if (score != 0) {
            return score * this.fSortDirection;
        }
        return e2.getScore() > e1.getScore() ? 1 : -1;
    }

    private int compareByName(IScoredResult e1, IScoredResult e2) {
        String name1 = e1.getResult().getName();
        String name2 = e2.getResult().getName();
        return this.fCollator.compare(name2, name1) * this.fSortDirection;
    }

    private int compareByDetails(IScoredResult e1, IScoredResult e2) {
        String details1 = e1.getResult().getDetails();
        String details2 = e2.getResult().getDetails();
        return this.fCollator.compare(details2, details1) * this.fSortDirection;
    }
}

