/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal;

import com.ibm.team.fulltext.ide.ui.internal.ArtifactType;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FulltextUIPlugin
extends AbstractUIPlugin
implements ExtensionRegistryReaderListener<Object> {
    public static final String PLUGIN_ID = "com.ibm.team.fulltext.ide.ui";
    private static final String ARTIFACT_TYPE_EXTENSION_POINT = "artifactType";
    private static final String ARTIFACT_TYPE_ID_ATTRIBUTE = "id";
    private static final String ARTIFACT_TYPE_NAME_ATTRIBUTE = "name";
    private static final String ARTIFACT_TYPE_ICON_ATTRIBUTE = "icon";
    private static FulltextUIPlugin fgPlugin;
    private ExtensionRegistryReader<Object> fExtensionReader;
    private Map<String, ArtifactType> fArtifactTypes = new HashMap<String, ArtifactType>();

    public FulltextUIPlugin() {
        fgPlugin = this;
    }

    public static FulltextUIPlugin getDefault() {
        return fgPlugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fExtensionReader = new ExtensionRegistryReader<Object>(PLUGIN_ID, ARTIFACT_TYPE_EXTENSION_POINT){};
        this.fExtensionReader.addListener((ExtensionRegistryReaderListener)this);
        this.fExtensionReader.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.fExtensionReader.stop();
        super.stop(context);
        fgPlugin = null;
    }

    public ImageDescriptor createDescriptor(String path) {
        return FulltextUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Collection<ArtifactType> getArtifactTypes() {
        return this.fArtifactTypes.values();
    }

    public ArtifactType getArtifactType(String id) {
        return this.fArtifactTypes.get(id);
    }

    public boolean isSupported(String type) {
        return this.fArtifactTypes.containsKey(type);
    }

    public void handleExtensionAdded(IConfigurationElement element, Object descriptor) throws Exception {
        String id = element.getAttribute(ARTIFACT_TYPE_ID_ATTRIBUTE);
        String name = element.getAttribute(ARTIFACT_TYPE_NAME_ATTRIBUTE);
        String iconPath = element.getAttribute(ARTIFACT_TYPE_ICON_ATTRIBUTE);
        ImageDescriptor icon = FulltextUIPlugin.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)iconPath);
        ArtifactType searchScope = new ArtifactType(id, name, icon);
        if (!this.fArtifactTypes.containsKey(id)) {
            this.fArtifactTypes.put(id, searchScope);
        }
    }

    public void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
        String id = element.getAttribute(ARTIFACT_TYPE_ID_ATTRIBUTE);
        this.fArtifactTypes.remove(id);
    }

    public void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    public void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptor) throws Exception {
    }
}

