/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.ITeamWorkingCopy;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.internal.client.workingcopies.ContributorListWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.RolePersistence;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TeamWorkingCopy
extends ContributorListWorkingCopy
implements ITeamWorkingCopy {
    private final IProcessAreaWorkingCopy fProcessAreaWorkingCopy;
    private IRole[] fAvailableRoles;
    private ItemHandleAwareHashMap fRoleCast = new ItemHandleAwareHashMap();

    public TeamWorkingCopy(ITeamRepository teamRepository, IProcessAreaWorkingCopy processAreaWorkingCopy) {
        super(teamRepository);
        this.fProcessAreaWorkingCopy = processAreaWorkingCopy;
    }

    public IProcessAreaWorkingCopy getProcessAreaWorkingCopy() {
        return this.fProcessAreaWorkingCopy;
    }

    protected void handleContributorAdded(IContributor contributor) {
    }

    protected void handleContributorRemoved(IContributor contributor) {
        this.fRoleCast.remove((Object)contributor);
    }

    protected void doUpdate(ContributorListWorkingCopy.IContributorProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorAndRoleProvider roleProvider = (IContributorAndRoleProvider)provider;
        this.fAvailableRoles = roleProvider.computeAvailableRoles(monitor);
    }

    protected boolean handleContributorsUpdated(ContributorListWorkingCopy.IContributorProvider provider, boolean membersChanged) {
        IContributorAndRoleProvider roleProvider = (IContributorAndRoleProvider)provider;
        RolePersistence rolePersistence = new RolePersistence(this.fAvailableRoles);
        boolean updated = false;
        ItemHandleAwareHashMap roleCast = new ItemHandleAwareHashMap();
        List members = this.getContributors();
        for (IContributor contributor : members) {
            IContributorHandle contributorHandle = (IContributorHandle)contributor.getItemHandle();
            String roleData = roleProvider.getRoleData(contributorHandle);
            if (roleData == null) continue;
            IRole[] roles = rolePersistence.deserialize(roleData);
            IRole[] currentRoles = (IRole[])this.fRoleCast.get((Object)contributorHandle);
            if (roles != null) {
                roleCast.put((Object)contributorHandle, (Object)roles);
            }
            boolean bl = updated = updated || !this.equals(roles, currentRoles);
        }
        this.fRoleCast = roleCast;
        return updated;
    }

    private boolean equals(IRole[] newRoles, IRole[] currentRoles) {
        if (newRoles == null) {
            return currentRoles == null;
        }
        if (currentRoles == null || newRoles.length != currentRoles.length) {
            return false;
        }
        int i = 0;
        while (i < currentRoles.length) {
            IRole role = currentRoles[i];
            if (role.getId() == null && newRoles[i].getId() != null || !role.getId().equals(newRoles[i].getId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void syncSave(ContributorListWorkingCopy.IContributorContainer container, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("TeamWorkingCopy.0"), 100);
        super.syncSave(container, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        IContributorRoleContainer roleContainer = (IContributorRoleContainer)container;
        for (IContributorHandle contributor : this.getContributors()) {
            String roleData;
            IRole[] roles = this.getRoleCast(contributor);
            if (roles == null || roles.length <= 0 || (roleData = RolePersistence.serialize((IRole[])roles)) == null) continue;
            roleContainer.setRoleData(contributor, roleData);
        }
        monitor.done();
    }

    public IRole[] getRoleCast(IContributorHandle contributorHandle) {
        return (IRole[])this.fRoleCast.get((Object)contributorHandle);
    }

    public void setRoleCast(IContributorHandle contributorHandle, IRole[] roleCast) {
        IContributor contributor;
        if (!this.isDisposed() && (contributor = this.resolveContributor(contributorHandle)) != null) {
            this.fRoleCast.put((Object)contributorHandle, (Object)roleCast);
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "contributorList.contributor", new IContributor[]{contributor}, new IContributorHandle[]{contributor}));
        }
    }

    public synchronized void addContributorsSettingRoleCast(IContributor[] contributors, IRole[] roleCast) {
        if (!this.isDisposed()) {
            ArrayList<IContributor> addedContributors = new ArrayList<IContributor>();
            ArrayList<IContributor> roleCastChanged = new ArrayList<IContributor>();
            int i = 0;
            while (i < contributors.length) {
                IContributor contributor = contributors[i];
                if (this.hasContributor((IContributorHandle)contributor)) {
                    roleCastChanged.add(contributor);
                } else {
                    this.getContributors().add(contributor);
                    this.handleContributorAdded(contributor);
                    addedContributors.add(contributor);
                }
                this.fRoleCast.put((Object)contributor, (Object)roleCast);
                ++i;
            }
            this.setDirty(true, true);
            if (addedContributors.isEmpty()) {
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "contributorList.contributor", contributors, contributors));
            } else {
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "contributorList.add", null, addedContributors.toArray()));
                if (!roleCastChanged.isEmpty()) {
                    this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "contributorList.contributor", roleCastChanged.toArray(), roleCastChanged.toArray()));
                }
            }
        }
    }

    public static interface IContributorAndRoleProvider
    extends ContributorListWorkingCopy.IContributorProvider {
        public String getRoleData(IContributorHandle var1);

        public IRole[] computeAvailableRoles(IProgressMonitor var1) throws TeamRepositoryException;
    }

    public static interface IContributorRoleContainer
    extends ContributorListWorkingCopy.IContributorContainer {
        public void setRoleData(IContributorHandle var1, String var2);
    }
}

