/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class LRUCache {
    private static final int CACHE_SIZE = 50;
    private Map fCache = null;
    private List fLRU = null;
    static Object fgNullProcessArea = new Object();

    LRUCache() {
        this.initializeCache(50);
    }

    public synchronized Object get(String itemUUIDValue) {
        Object processArea = this.fCache.get(itemUUIDValue);
        if (processArea == null) {
            return null;
        }
        this.fLRU.remove(itemUUIDValue);
        this.fLRU.add(this.fLRU.size(), itemUUIDValue);
        return processArea;
    }

    public synchronized void put(String itemUUIDValue, IProcessArea area) {
        Object result;
        Object value = area;
        if (area == null) {
            value = fgNullProcessArea;
        }
        if ((result = this.fCache.get(itemUUIDValue)) != null) {
            this.fCache.put(itemUUIDValue, value);
            return;
        }
        if (this.fCache.size() == 50) {
            String toBeRemoved = (String)this.fLRU.remove(0);
            this.fCache.remove(toBeRemoved);
        }
        this.fLRU.add(this.fLRU.size(), itemUUIDValue);
        this.fCache.put(itemUUIDValue, value);
    }

    private void initializeCache(int newCacheSize) {
        int cacheSize = newCacheSize * 4 / 3 + 1;
        this.fCache = new HashMap(cacheSize);
        this.fLRU = new ArrayList(newCacheSize);
    }

    public synchronized void remove(String itemUUIDValue) {
        this.fLRU.remove(itemUUIDValue);
        this.fCache.remove(itemUUIDValue);
    }

    public synchronized void remove(IItemHandle[] items) {
        int i = 0;
        while (i < items.length) {
            IItemHandle itemHandle = items[i];
            String uuidValue = itemHandle.getItemId().getUuidValue();
            this.put(uuidValue, null);
            ++i;
        }
    }

    public synchronized void removeNullAssociations(IItemHandle[] items) {
        int i = 0;
        while (i < items.length) {
            IItemHandle itemHandle = items[i];
            String uuidValue = itemHandle.getItemId().getUuidValue();
            Object value = this.fCache.get(uuidValue);
            if (value == fgNullProcessArea) {
                this.fLRU.remove(uuidValue);
                this.fCache.remove(uuidValue);
            }
            ++i;
        }
    }

    protected synchronized void removeProcessAreaAssociations(IProcessAreaHandle handle) {
        Iterator values = this.fCache.values().iterator();
        while (values.hasNext()) {
            IProcessArea processArea;
            Object value = values.next();
            if (value == fgNullProcessArea || !(processArea = (IProcessArea)value).getItemHandle().sameItemId((IItemHandle)handle)) continue;
            values.remove();
            return;
        }
    }
}

