/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.IPlatformConfiguration$IFeatureEntry;
import org.eclipse.update.configurator.IPlatformConfiguration$ISiteEntry;
import org.eclipse.update.configurator.IPlatformConfiguration$ISitePolicy;
import org.eclipse.update.internal.configurator.BundleManifest;
import org.eclipse.update.internal.configurator.Configuration;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.FeatureParser;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.PluginParser;
import org.eclipse.update.internal.configurator.SiteEntry$$Cold;
import org.eclipse.update.internal.configurator.SiteEntry$1;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SiteEntry
implements IPlatformConfiguration$ISiteEntry,
IConfigurationConstants {
    private static final String MAC_OS_MARKER = ".DS_Store";
    private URL url;
    private URL resolvedURL;
    private IPlatformConfiguration$ISitePolicy policy;
    private boolean updateable = true;
    private Map featureEntries;
    private ArrayList pluginEntries;
    private long changeStamp;
    private long featuresChangeStamp;
    private long pluginsChangeStamp;
    private String linkFileName;
    private boolean enabled = true;
    private Configuration config;
    private static FeatureParser featureParser = new FeatureParser();
    private static PluginParser pluginParser = new PluginParser();
    private static boolean isMacOS = Utils.getOS().equals("macosx");

    public SiteEntry(URL uRL) {
        this(uRL, null);
    }

    public SiteEntry(URL uRL, IPlatformConfiguration$ISitePolicy iPlatformConfiguration$ISitePolicy) {
        if (uRL == null) {
            try {
                uRL = new URL("platform:/base/");
            }
            catch (MalformedURLException malformedURLException) {
                uRL = PlatformConfiguration.getInstallURL();
            }
        }
        if (iPlatformConfiguration$ISitePolicy == null) {
            iPlatformConfiguration$ISitePolicy = new SitePolicy(PlatformConfiguration.getDefaultPolicy(), DEFAULT_POLICY_LIST);
        }
        if (uRL.getProtocol().equals("file")) {
            try {
                this.url = new File(uRL.getFile()).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                this.url = uRL;
            }
        } else {
            this.url = uRL;
        }
        this.policy = iPlatformConfiguration$ISitePolicy;
        this.resolvedURL = this.url;
        if (uRL.getProtocol().equals("platform")) {
            try {
                this.resolvedURL = PlatformConfiguration.resolvePlatformURL(uRL);
            }
            catch (IOException iOException) {}
        }
    }

    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public URL getURL() {
        return this.url;
    }

    public IPlatformConfiguration$ISitePolicy getSitePolicy() {
        return this.policy;
    }

    public String[] getFeatures() {
        return this.getDetectedFeatures();
    }

    public String[] getPlugins() {
        IPlatformConfiguration$ISitePolicy iPlatformConfiguration$ISitePolicy = this.getSitePolicy();
        if (iPlatformConfiguration$ISitePolicy.getType() == 0) {
            return iPlatformConfiguration$ISitePolicy.getList();
        }
        if (iPlatformConfiguration$ISitePolicy.getType() == 1) {
            ArrayList arrayList = new ArrayList(Arrays.asList(this.getDetectedPlugins()));
            String[] stringArray = iPlatformConfiguration$ISitePolicy.getList();
            int n = 0;
            while (n < stringArray.length) {
                if (arrayList.contains(stringArray[n])) {
                    arrayList.remove(stringArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new String[0]);
        }
        if (iPlatformConfiguration$ISitePolicy.getType() == 2) {
            PluginEntry[] pluginEntryArray = this.getManagedPlugins();
            String[] stringArray = new String[pluginEntryArray.length];
            int n = 0;
            while (n < pluginEntryArray.length) {
                stringArray[n] = pluginEntryArray[n].getURL();
                ++n;
            }
            return stringArray;
        }
        return new String[0];
    }

    public long getFeaturesChangeStamp() {
        if (this.featuresChangeStamp == 0L) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    public long getPluginsChangeStamp() {
        if (this.pluginsChangeStamp == 0L) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean bl) {
        this.updateable = bl;
    }

    public boolean isNativelyLinked() {
        return this.isExternallyLinkedSite();
    }

    public URL getResolvedURL() {
        return this.resolvedURL;
    }

    private void detectFeatures() {
        if (this.featureEntries != null) {
            this.validateFeatureEntries();
        } else {
            this.featureEntries = new HashMap();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            return;
        }
        File file = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File file2 = new File(file, "features");
        if (file2.exists()) {
            File[] fileArray = file2.listFiles(new SiteEntry$1(this));
            int n = 0;
            while (n < fileArray.length) {
                try {
                    URL uRL;
                    FeatureEntry featureEntry;
                    File file3 = new File(fileArray[n], "feature.xml");
                    if ((file3.lastModified() > this.featuresChangeStamp || fileArray[n].lastModified() > this.featuresChangeStamp) && (featureEntry = featureParser.parse(uRL = file3.toURL())) != null) {
                        this.addFeatureEntry(featureEntry);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Utils.log(NLS.bind((String)Messages.InstalledSiteParser_UnableToCreateURLForFile, (Object[])new String[]{file2.getAbsolutePath()}));
                }
                ++n;
            }
        }
        Utils.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.featureEntries.size() + " feature(s)");
    }

    private void detectPlugins() {
        boolean bl = false;
        if (this.pluginEntries != null) {
            this.validatePluginEntries();
            bl = true;
        } else {
            this.pluginEntries = new ArrayList();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            return;
        }
        File file = new File(this.resolvedURL.getFile(), "plugins");
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.detectUnpackedPlugin(fileArray[n], bl);
                } else if (fileArray[n].getName().endsWith(".jar")) {
                    this.detectPackedPlugin(fileArray[n], bl);
                }
                ++n;
            }
        }
        Utils.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.pluginEntries.size() + " plugin(s)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void detectPackedPlugin(File file, boolean bl) {
        InputStream inputStream;
        ZipFile zipFile;
        block50: {
            InputStream inputStream2;
            block48: {
                Object object;
                String string;
                String string2;
                block46: {
                    block47: {
                        if (bl && file.lastModified() <= this.pluginsChangeStamp) {
                            return;
                        }
                        string2 = "META-INF/MANIFEST.MF";
                        zipFile = null;
                        inputStream2 = null;
                        inputStream = null;
                        string = "plugins/" + file.getName();
                        zipFile = new ZipFile(file);
                        if (zipFile.getEntry(string2) == null || !((BundleManifest)(object = new BundleManifest(inputStream2 = zipFile.getInputStream(new ZipEntry(string2)), string))).exists()) break block46;
                        this.addPluginEntry(((BundleManifest)object).getPluginEntry());
                        if (inputStream2 == null) break block47;
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipFile == null) return;
                    try {
                        zipFile.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                try {
                    string2 = "plugin.xml";
                    if (zipFile.getEntry(string2) == null) {
                        string2 = "fragment.xml";
                    }
                    if (zipFile.getEntry(string2) == null) break block48;
                    inputStream = zipFile.getInputStream(new ZipEntry(string2));
                    object = pluginParser.parse(inputStream, string);
                    this.addPluginEntry((PluginEntry)object);
                }
                catch (IOException iOException) {
                    object = String.valueOf(string) + "!" + string2;
                    Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorAccessing, (Object[])new String[]{object}));
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    if (zipFile == null) return;
                    try {
                        zipFile.close();
                        return;
                    }
                    catch (IOException iOException4) {}
                    return;
                }
                catch (SAXException sAXException) {
                    block49: {
                        try {
                            object = String.valueOf(string) + "!" + string2;
                            Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{object}));
                            if (inputStream2 == null) break block49;
                        }
                        catch (Throwable throwable) {
                            if (inputStream2 != null) {
                                try {
                                    inputStream2.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (zipFile == null) throw throwable;
                            try {
                                zipFile.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipFile == null) return;
                    try {
                        zipFile.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
            }
            if (inputStream2 == null) break block50;
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (zipFile == null) return;
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void detectUnpackedPlugin(File file, boolean bl) {
        long l = file.lastModified();
        File file2 = new File(file, "META-INF/MANIFEST.MF");
        try {
            BundleManifest bundleManifest = new BundleManifest(file2);
            if (bundleManifest.exists()) {
                if (bl && l <= this.pluginsChangeStamp && file2.lastModified() <= this.pluginsChangeStamp) {
                    return;
                }
                PluginEntry pluginEntry = bundleManifest.getPluginEntry();
                this.addPluginEntry(pluginEntry);
            } else {
                file2 = new File(file, "plugin.xml");
                if (!file2.exists()) {
                    file2 = new File(file, "fragment.xml");
                }
                if (file2.exists() && !file2.isDirectory()) {
                    if (bl && l <= this.pluginsChangeStamp && file2.lastModified() <= this.pluginsChangeStamp) {
                        return;
                    }
                    PluginEntry pluginEntry = pluginParser.parse(file2);
                    this.addPluginEntry(pluginEntry);
                }
            }
        }
        catch (IOException iOException) {
            String string = file2.getAbsolutePath();
            if (ConfigurationActivator.DEBUG) {
                Utils.log(Utils.newStatus(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{string}), iOException));
            } else {
                Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorAccessing, (Object[])new String[]{string}));
            }
        }
        catch (SAXException sAXException) {
            String string = file2.getAbsolutePath();
            Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{string}));
        }
    }

    private synchronized String[] getDetectedFeatures() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        String[] stringArray = new String[this.featureEntries.size()];
        Iterator iterator = this.featureEntries.values().iterator();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((FeatureEntry)iterator.next()).getURL();
            ++n;
        }
        return stringArray;
    }

    private synchronized String[] getDetectedPlugins() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        String[] stringArray = new String[this.pluginEntries.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((PluginEntry)this.pluginEntries.get(n)).getURL();
            ++n;
        }
        return stringArray;
    }

    private synchronized long computeFeaturesChangeStamp() {
        if (this.featuresChangeStamp > 0L) {
            return this.featuresChangeStamp;
        }
        long l = 0L;
        if (ConfigurationActivator.DEBUG) {
            l = new Date().getTime();
        }
        String[] stringArray = this.getFeatures();
        long l2 = 0L;
        if (PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            File file = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            File file2 = new File(file, "features");
            l2 = file2.lastModified();
        }
        this.featuresChangeStamp = Math.max(l2, this.computeStamp(stringArray));
        if (ConfigurationActivator.DEBUG) {
            long l3 = new Date().getTime();
            Utils.debug(String.valueOf(this.resolvedURL.toString()) + " feature stamp: " + this.featuresChangeStamp + " in " + (l3 - l) + "ms");
        }
        return this.featuresChangeStamp;
    }

    private synchronized long computePluginsChangeStamp() {
        if (this.pluginsChangeStamp > 0L) {
            return this.pluginsChangeStamp;
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            Utils.log(NLS.bind((String)Messages.SiteEntry_computePluginStamp, (Object[])new String[]{this.resolvedURL.toExternalForm()}));
            return 0L;
        }
        File file = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File file2 = new File(file, "plugins");
        if (!file2.exists() || !file2.isDirectory()) {
            Utils.log(NLS.bind((String)Messages.SiteEntry_pluginsDir, (Object[])new String[]{file2.getAbsolutePath()}));
            return 0L;
        }
        this.pluginsChangeStamp = file2.lastModified();
        return this.pluginsChangeStamp;
    }

    private long computeStamp(String[] stringArray) {
        long l = 0L;
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            int n = 0;
            while (n < stringArray.length) {
                l ^= (long)stringArray[n].hashCode();
                ++n;
            }
            Utils.debug("*WARNING* computing stamp using URL hashcodes only");
        } else {
            File file = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            if (file.exists()) {
                File file2 = null;
                int n = 0;
                while (n < stringArray.length) {
                    file2 = new File(file, stringArray[n]);
                    if (file2.exists()) {
                        l = Math.max(l, file2.lastModified());
                    }
                    ++n;
                }
            }
        }
        return l;
    }

    public void setLinkFileName(String string) {
        this.linkFileName = string;
    }

    public String getLinkFileName() {
        return this.linkFileName;
    }

    public boolean isExternallyLinkedSite() {
        return this.linkFileName != null && !this.linkFileName.trim().equals("");
    }

    public FeatureEntry[] getFeatureEntries() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        if (this.featureEntries == null) {
            return new FeatureEntry[0];
        }
        return this.featureEntries.values().toArray(new FeatureEntry[this.featureEntries.size()]);
    }

    public void addPluginEntry(PluginEntry pluginEntry) {
        if (this.pluginEntries == null) {
            this.pluginEntries = new ArrayList();
        }
        this.pluginEntries.add(pluginEntry);
    }

    public void loadFromDisk(long l) throws CoreException {
        this.featuresChangeStamp = l;
        this.pluginsChangeStamp = l;
        this.detectFeatures();
        this.detectPlugins();
    }

    public Element toXML(Document document) {
        int n;
        Object object;
        Element element = document.createElement("site");
        if (this.getURL() != null) {
            URL uRL = this.config == null || this.config.isTransient() ? this.getURL() : Utils.makeRelative(Utils.getInstallURL(), this.getURL());
            element.setAttribute("url", uRL.toString());
        }
        element.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        element.setAttribute("updateable", this.isUpdateable() ? "true" : "false");
        if (this.isExternallyLinkedSite()) {
            element.setAttribute("linkfile", this.getLinkFileName().trim().replace(File.separatorChar, '/'));
        }
        int n2 = this.getSitePolicy().getType();
        String string = "UNKNOWN";
        try {
            string = CFG_POLICY_TYPE[n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        element.setAttribute("policy", string);
        String[] stringArray = this.getSitePolicy().getList();
        if (stringArray.length > 0) {
            object = new StringBuffer(256);
            n = 0;
            while (n < stringArray.length - 1) {
                ((StringBuffer)object).append(stringArray[n]);
                ((StringBuffer)object).append(',');
                ++n;
            }
            ((StringBuffer)object).append(stringArray[stringArray.length - 1]);
            element.setAttribute("list", ((StringBuffer)object).toString());
        }
        object = this.getFeatureEntries();
        n = 0;
        while (n < ((FeatureEntry[])object).length) {
            Element element2 = object[n].toXML(document);
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    static boolean access$0() {
        return isMacOS;
    }

    public synchronized void setSitePolicy(IPlatformConfiguration$ISitePolicy iPlatformConfiguration$ISitePolicy) {
        if (iPlatformConfiguration$ISitePolicy == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.policy = iPlatformConfiguration$ISitePolicy;
    }

    private PluginEntry[] getManagedPlugins() {
        Object object;
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        HashMap<VersionedIdentifier, Object> hashMap = new HashMap<VersionedIdentifier, Object>(this.pluginEntries.size());
        int n = 0;
        while (n < this.pluginEntries.size()) {
            object = (PluginEntry)this.pluginEntries.get(n);
            hashMap.put(((PluginEntry)object).getVersionedIdentifier(), object);
            ++n;
        }
        ArrayList arrayList = new ArrayList();
        object = this.featureEntries.values().iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof FeatureEntry)) continue;
            PluginEntry[] pluginEntryArray = ((FeatureEntry)e).getPluginEntries();
            int n2 = 0;
            while (n2 < pluginEntryArray.length) {
                if (hashMap.containsKey(pluginEntryArray[n2].getVersionedIdentifier())) {
                    arrayList.add(hashMap.get(pluginEntryArray[n2].getVersionedIdentifier()));
                }
                ++n2;
            }
        }
        return arrayList.toArray(new PluginEntry[arrayList.size()]);
    }

    public PluginEntry[] getPluginEntries() {
        String[] stringArray = this.getPlugins();
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n], stringArray[n]);
            ++n;
        }
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        ArrayList<PluginEntry> arrayList = new ArrayList<PluginEntry>(stringArray.length);
        int n2 = 0;
        while (n2 < this.pluginEntries.size()) {
            PluginEntry pluginEntry = (PluginEntry)this.pluginEntries.get(n2);
            if (hashMap.containsKey(pluginEntry.getURL())) {
                arrayList.add(pluginEntry);
            }
            ++n2;
        }
        return arrayList.toArray(new PluginEntry[arrayList.size()]);
    }

    public long getChangeStamp() {
        if (this.changeStamp == 0L) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    private void computeChangeStamp() {
        this.changeStamp = Math.max(this.computeFeaturesChangeStamp(), this.computePluginsChangeStamp());
    }

    public synchronized void refresh() {
        this.featuresChangeStamp = 0L;
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.featureEntries = null;
        this.pluginEntries = null;
    }

    public void refreshPlugins() {
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.pluginEntries = null;
    }

    public void addFeatureEntry(IPlatformConfiguration$IFeatureEntry iPlatformConfiguration$IFeatureEntry) {
        FeatureEntry featureEntry;
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap();
        }
        if ((featureEntry = (FeatureEntry)this.featureEntries.get(iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier())) != null) {
            VersionedIdentifier versionedIdentifier = new VersionedIdentifier(featureEntry.getFeatureIdentifier(), featureEntry.getFeatureVersion());
            VersionedIdentifier versionedIdentifier2 = new VersionedIdentifier(iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier(), iPlatformConfiguration$IFeatureEntry.getFeatureVersion());
            if (versionedIdentifier.getVersion().compareTo((Object)versionedIdentifier2.getVersion()) < 0) {
                this.featureEntries.put(iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier(), iPlatformConfiguration$IFeatureEntry);
                this.pluginsChangeStamp = 0L;
            } else if (versionedIdentifier.equals(versionedIdentifier2) && iPlatformConfiguration$IFeatureEntry instanceof FeatureEntry && featureEntry instanceof FeatureEntry && !((FeatureEntry)iPlatformConfiguration$IFeatureEntry).getURL().equals(featureEntry.getURL())) {
                Utils.log(NLS.bind((String)Messages.SiteEntry_duplicateFeature, (Object[])new String[]{this.getURL().toExternalForm(), featureEntry.getFeatureIdentifier()}));
            }
        } else {
            this.featureEntries.put(iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier(), iPlatformConfiguration$IFeatureEntry);
            this.pluginsChangeStamp = 0L;
        }
        if (iPlatformConfiguration$IFeatureEntry instanceof FeatureEntry) {
            ((FeatureEntry)iPlatformConfiguration$IFeatureEntry).setSite(this);
        }
    }

    public PluginEntry[] getAllPluginEntries() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        return this.pluginEntries.toArray(new PluginEntry[this.pluginEntries.size()]);
    }

    private void validateFeatureEntries() {
        Object object;
        File file = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        Iterator iterator = this.featureEntries.values().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            object = (FeatureEntry)iterator.next();
            File file2 = new File(file, ((FeatureEntry)object).getURL());
            if (file2.exists()) continue;
            arrayList.add(((FeatureEntry)object).getFeatureIdentifier());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.featureEntries.remove(object.next());
        }
    }

    private void validatePluginEntries() {
        File file = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        ArrayList<PluginEntry> arrayList = new ArrayList<PluginEntry>();
        int n = 0;
        while (n < this.pluginEntries.size()) {
            PluginEntry pluginEntry = (PluginEntry)this.pluginEntries.get(n);
            File file2 = new File(file, pluginEntry.getURL());
            if (!file2.exists()) {
                arrayList.add(pluginEntry);
            }
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.pluginEntries.remove(iterator.next());
        }
    }

    public FeatureEntry getFeatureEntry(String string) throws  {
        return SiteEntry$$Cold.getFeatureEntry(this, string);
    }

    public boolean unconfigureFeatureEntry(IPlatformConfiguration$IFeatureEntry iPlatformConfiguration$IFeatureEntry) {
        FeatureEntry featureEntry = this.getFeatureEntry(iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier());
        if (featureEntry != null) {
            this.featureEntries.remove(featureEntry.getFeatureIdentifier());
        }
        return featureEntry != null;
    }

    void initialized() {
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap();
        }
    }
}

