/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.osgi.framework.BundleException;

public class BundleManifest
implements IConfigurationConstants {
    private File manifestFile;
    private PluginEntry pluginEntry;
    private IOException exception;
    private String bundleURL;

    public BundleManifest(File file) {
        block15: {
            this.manifestFile = file;
            if (file.exists() && !file.isDirectory()) {
                FileInputStream fileInputStream = null;
                try {
                    try {
                        fileInputStream = new FileInputStream(file);
                        this.parse(fileInputStream);
                    }
                    catch (IOException iOException) {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public BundleManifest(InputStream inputStream, String string) {
        this.bundleURL = string;
        if (inputStream != null) {
            this.parse(inputStream);
        }
    }

    private void parse(InputStream inputStream) {
        try {
            String string;
            Object object;
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            String string2 = attributes.getValue("Bundle-SymbolicName");
            if (string2 == null) {
                return;
            }
            try {
                object = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)string2);
                string = object[0].getValue();
            }
            catch (BundleException bundleException) {
                throw (Throwable)new IOException(bundleException.getMessage());
            }
            object = attributes.getValue("Bundle-Version");
            if (object == null) {
                Utils.log(NLS.bind((String)Messages.BundleManifest_noVersion, (Object[])new String[]{"Bundle-Version", string}));
                return;
            }
            object = ((String)object).trim();
            String string3 = attributes.getValue("Fragment-Host");
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(string, (String)object));
            this.pluginEntry.isFragment(string3 != null && string3.length() > 0);
            if (this.bundleURL != null) {
                this.pluginEntry.setURL(this.bundleURL);
            } else {
                File file = this.manifestFile.getParentFile();
                if (file != null) {
                    file = file.getParentFile();
                }
                if (file != null) {
                    this.pluginEntry.setURL("plugins/" + file.getName() + "/");
                }
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public boolean exists() {
        return this.exception != null || this.pluginEntry != null;
    }

    public PluginEntry getPluginEntry() throws IOException {
        if (this.exception != null) {
            throw (Throwable)this.exception;
        }
        return this.pluginEntry;
    }
}

