/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal.dao;

import com.ibm.team.feed.core.internal.Feed;
import com.ibm.team.feed.core.internal.NewsItem;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedHandler
extends DefaultHandler {
    public static final String NEWSITEM_MARKER = "com.ibm.feed.core.NewsItemMarker";
    private static final Map<String, String> MAPPER = FeedHandler.createMapper();
    private Feed fFeed;
    private NewsItem fCurrentItem;
    private String fXPath = "";
    private String fCurrentField;
    private final StringBuffer fBuffer = new StringBuffer();
    private final String fUrl;
    private boolean fInAtomContentXHTMLMode = false;
    private int fDivCounter = 0;
    private static final String DIV = "div";

    public FeedHandler(String url) {
        this.fUrl = url;
    }

    public Feed getFeed() {
        return this.fFeed;
    }

    @Override
    public void startDocument() {
        this.fFeed = new Feed(this.fUrl);
        this.clear();
    }

    @Override
    public void endDocument() {
        this.clear();
    }

    private void clear() {
        this.fXPath = "";
        this.fBuffer.setLength(0);
        this.fCurrentField = null;
        this.fCurrentItem = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.fInAtomContentXHTMLMode) {
            if (DIV.equals(qName)) {
                ++this.fDivCounter;
            }
            if (this.fCurrentField == null) {
                this.fCurrentField = MAPPER.get(this.fXPath);
            }
            if (this.fDivCounter > 1 || !DIV.equals(qName)) {
                this.fBuffer.append('<').append(qName).append('>');
            }
            return;
        }
        this.fBuffer.setLength(0);
        this.fXPath = new StringBuffer(this.fXPath).append('/').append(qName).toString();
        this.fCurrentField = MAPPER.get(this.fXPath);
        if (this.fCurrentField == null && qName.indexOf(58) >= 0) {
            this.handleUnknownNamespace(uri, localName);
        }
        if (NEWSITEM_MARKER.equals(this.fCurrentField)) {
            this.fCurrentItem = new NewsItem();
            this.fFeed.addItem(this.fCurrentItem);
        }
        if (this.fXPath.indexOf("/feed") >= 0 && this.fXPath.indexOf("/link") >= 0) {
            this.handleAtomLinkElement(attributes);
        } else if (this.fXPath.indexOf("/feed/entry/category") >= 0) {
            this.handleAtomCategoryElement(attributes);
        } else if (this.fXPath.indexOf("/feed/entry/content") >= 0) {
            this.handleAtomContentElement(attributes);
        }
    }

    private void handleUnknownNamespace(String uri, String localName) {
        if ("http:///magnolia/model.ecore".equals(uri) || "http://com.ibm.magnolia.rss".equals(uri) || "com.ibm.team.workitem".equals(uri)) {
            uri = "http://www.ibm.com/team/Feed";
        }
        this.fCurrentField = new StringBuffer(uri).append(':').append(localName).toString();
    }

    private void handleAtomContentElement(Attributes attributes) {
        String type = attributes.getValue("type");
        if ("xhtml".equals(type) || "application/xhtml+xml".equals(type)) {
            this.fInAtomContentXHTMLMode = true;
        }
    }

    private void handleAtomCategoryElement(Attributes attributes) {
        String label = attributes.getValue("label");
        String term = attributes.getValue("term");
        if (label != null && this.fCurrentItem != null) {
            this.fCurrentItem.setField(this.fCurrentField, label);
        } else if (term != null && this.fCurrentItem != null) {
            this.fCurrentItem.setField(this.fCurrentField, term);
        }
        this.fCurrentField = null;
    }

    private void handleAtomLinkElement(Attributes attributes) {
        String relValue = attributes.getValue("rel");
        String hrefValue = attributes.getValue("href");
        if (("alternate".equals(relValue) || relValue == null) && hrefValue != null) {
            if (this.fCurrentItem == null) {
                this.fFeed.setField(this.fCurrentField, hrefValue);
            } else {
                this.fCurrentItem.setField(this.fCurrentField, hrefValue);
            }
            this.fCurrentField = null;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (DIV.equals(qName)) {
            --this.fDivCounter;
        }
        if (this.fInAtomContentXHTMLMode && this.fDivCounter == 0) {
            this.fInAtomContentXHTMLMode = false;
        }
        if (this.fInAtomContentXHTMLMode && this.fDivCounter > 0) {
            this.fBuffer.append("</").append(qName).append('>');
            return;
        }
        if (this.fCurrentField != null) {
            if (this.fCurrentItem != null) {
                this.fCurrentItem.setField(this.fCurrentField, this.fBuffer.toString().trim());
            } else {
                this.fFeed.setField(this.fCurrentField, this.fBuffer.toString().trim());
            }
        }
        if (NEWSITEM_MARKER.equals(MAPPER.get(this.fXPath))) {
            this.fCurrentItem = null;
        }
        if (this.fXPath.endsWith(String.valueOf('/') + qName)) {
            this.fXPath = this.fXPath.substring(0, this.fXPath.length() - qName.length() - 1);
        }
        this.fCurrentField = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.fCurrentField != null) {
            this.fBuffer.append(ch, start, length);
        }
    }

    private static Map<String, String> createMapper() {
        HashMap<String, String> mapper = new HashMap<String, String>();
        mapper.putAll(FeedHandler.createRSSMapper());
        mapper.putAll(FeedHandler.createRDFMapper());
        mapper.putAll(FeedHandler.createAtomMapper());
        return mapper;
    }

    private static Map<String, String> createRSSMapper() {
        HashMap<String, String> mapper = new HashMap<String, String>();
        String channel = "/rss/channel";
        mapper.put(String.valueOf(channel) + "/link", "link");
        mapper.put(String.valueOf(channel) + "/title", "title");
        mapper.put(String.valueOf(channel) + "/dc:title", "title");
        mapper.put(String.valueOf(channel) + "/description", "description");
        mapper.put(String.valueOf(channel) + "/dc:description", "description");
        mapper.put(String.valueOf(channel) + "/item", NEWSITEM_MARKER);
        mapper.put(String.valueOf(channel) + "/item/title", "title");
        mapper.put(String.valueOf(channel) + "/item/dc:title", "title");
        mapper.put(String.valueOf(channel) + "/item/link", "link");
        mapper.put(String.valueOf(channel) + "/item/description", "description");
        mapper.put(String.valueOf(channel) + "/item/dc:description", "description");
        mapper.put(String.valueOf(channel) + "/item/pubDate", "pubDate");
        mapper.put(String.valueOf(channel) + "/item/dc:date", "pubDate");
        mapper.put(String.valueOf(channel) + "/item/category", "category");
        mapper.put(String.valueOf(channel) + "/item/guid", "guid");
        return mapper;
    }

    private static Map<String, String> createRDFMapper() {
        HashMap<String, String> mapper = new HashMap<String, String>();
        String root = "/rdf:RDF";
        mapper.put(root, "");
        mapper.put(String.valueOf(root) + "/channel/link", "link");
        mapper.put(String.valueOf(root) + "/channel/title", "title");
        mapper.put(String.valueOf(root) + "/channel/dc:title", "title");
        mapper.put(String.valueOf(root) + "/channel/description", "description");
        mapper.put(String.valueOf(root) + "/channel/dc:description", "description");
        mapper.put(String.valueOf(root) + "/item", NEWSITEM_MARKER);
        mapper.put(String.valueOf(root) + "/item/title", "title");
        mapper.put(String.valueOf(root) + "/item/dc:title", "title");
        mapper.put(String.valueOf(root) + "/item/link", "link");
        mapper.put(String.valueOf(root) + "/item/description", "description");
        mapper.put(String.valueOf(root) + "/item/dc:description", "description");
        mapper.put(String.valueOf(root) + "/item/dc:date", "pubDate");
        return mapper;
    }

    private static Map<String, String> createAtomMapper() {
        HashMap<String, String> mapper = new HashMap<String, String>();
        String root = "/feed";
        mapper.put(String.valueOf(root) + "/link", "link");
        mapper.put(String.valueOf(root) + "/title", "title");
        mapper.put(String.valueOf(root) + "/tagline", "description");
        mapper.put(String.valueOf(root) + "/subtitle", "description");
        mapper.put(String.valueOf(root) + "/entry", NEWSITEM_MARKER);
        mapper.put(String.valueOf(root) + "/entry/title", "title");
        mapper.put(String.valueOf(root) + "/entry/link", "link");
        mapper.put(String.valueOf(root) + "/entry/id", "guid");
        mapper.put(String.valueOf(root) + "/entry/content", "description");
        mapper.put(String.valueOf(root) + "/entry/summary", "description");
        mapper.put(String.valueOf(root) + "/entry/issued", "pubDate");
        mapper.put(String.valueOf(root) + "/entry/published", "pubDate");
        mapper.put(String.valueOf(root) + "/entry/updated", "pubDate");
        mapper.put(String.valueOf(root) + "/entry/category", "category");
        return mapper;
    }
}

