/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.transport.client.InterruptableSocketFactory;
import com.ibm.team.repository.transport.client.ValidatingX509TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class SecureInterruptableSocketFactory
extends InterruptableSocketFactory
implements SecureProtocolSocketFactory {
    public static final String SSL = "SSL";
    private final SSLContext sslContext;

    private static SSLContext createSSLContext(TrustManager trustManager) {
        SSLContext context;
        try {
            context = SSLContext.getInstance(SSL);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            context.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        return context;
    }

    public SecureInterruptableSocketFactory(ICertificateValidator validator) {
        ValidatingX509TrustManager trustManager = new ValidatingX509TrustManager(validator);
        this.sslContext = SecureInterruptableSocketFactory.createSSLContext(trustManager);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket unencryptedSocket = super.createSocket(host, port, localAddress, localPort);
        Socket socket = this.createSocket(unencryptedSocket, host, port, true);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket unencryptedSocket = super.createSocket(host, port);
        Socket socket = this.createSocket(unencryptedSocket, host, port, true);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket unencryptedSocket = super.createSocket(host, port, localAddress, localPort, params);
        Socket socket = this.createSocket(unencryptedSocket, host, port, true);
        return socket;
    }
}

