/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;

public class ReleasingAndAbortingInputStream
extends FilterInputStream {
    private HttpMethod method;
    private boolean eofReached;

    public ReleasingAndAbortingInputStream(HttpMethod method) throws IOException {
        super(method.getResponseBodyAsStream());
        this.method = method;
    }

    public int read() throws IOException {
        try {
            int bytesRead = super.read();
            this.eofReached = bytesRead == -1;
            return bytesRead;
        }
        catch (IOException e) {
            this.eofReached = true;
            throw e;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int bytesRead = super.read(b, off, len);
            this.eofReached = bytesRead == -1;
            return bytesRead;
        }
        catch (IOException e) {
            this.eofReached = true;
            throw e;
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            int bytesRead = super.read(b);
            this.eofReached = bytesRead == -1;
            return bytesRead;
        }
        catch (IOException e) {
            this.eofReached = true;
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            if (!this.eofReached) {
                this.method.abort();
            } else {
                super.close();
            }
        }
        finally {
            this.method.releaseConnection();
        }
    }
}

