/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;

public class CertificateStore {
    private final KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());

    private static char[] string2chars(String s) {
        return s == null ? null : s.toCharArray();
    }

    KeyStore getKeyStore() {
        return this.keyStore;
    }

    static KeyStore load(File file, String password) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            FileInputStream input = new FileInputStream(file);
            ks.load(input, CertificateStore.string2chars(password));
            ((InputStream)input).close();
        }
        catch (IOException iOException) {
            ks.load(null, null);
        }
        return ks;
    }

    static void store(KeyStore ks, File file, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileOutputStream output = new FileOutputStream(file);
        ks.store(output, CertificateStore.string2chars(password));
        ((OutputStream)output).close();
    }

    static String computeAlias(Certificate cert) {
        return UUID.generate().getUuidValue();
    }

    public CertificateStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keyStore.load(null, null);
    }

    public CertificateStore(File file, String password) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        this();
        this.loadCertificates(file, password);
    }

    public boolean containsCertificate(Certificate cert) throws KeyStoreException {
        return this.keyStore.getCertificateAlias(cert) != null;
    }

    public void enterCertificate(Certificate cert) throws KeyStoreException {
        if (!this.containsCertificate(cert)) {
            this.keyStore.setCertificateEntry(CertificateStore.computeAlias(cert), cert);
        }
    }

    private void enterCertificates(KeyStore ks) throws KeyStoreException {
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isCertificateEntry(alias)) continue;
            Certificate cert = ks.getCertificate(alias);
            this.enterCertificate(cert);
        }
    }

    public void copyCertificates(CertificateStore ts) throws KeyStoreException {
        this.enterCertificates(ts.keyStore);
    }

    public void loadCertificates(File file, String password) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        KeyStore ks = CertificateStore.load(file, password);
        this.enterCertificates(ks);
    }
}

