/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.core.runtime.OperationCanceledException;

public class BufferedRequestEntity
implements RequestEntity {
    private final String contentType;
    private final int contentSize;
    private final int bufferSize;
    private final InputStream stream;
    private final HttpMethod method;
    private boolean readStream;

    public BufferedRequestEntity(InputStream stream, int size, String contentType, int bufferSize, HttpMethod method) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream may not be null");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than zero");
        }
        this.stream = stream;
        this.contentSize = size;
        this.contentType = contentType;
        this.bufferSize = bufferSize;
        this.method = method;
    }

    public void writeRequest(OutputStream out) throws IOException {
        this.readStream = true;
        byte[] buffer = new byte[this.bufferSize];
        int i = 0;
        try {
            while ((i = this.stream.read(buffer)) >= 0) {
                out.write(buffer, 0, i);
            }
        }
        catch (OperationCanceledException e) {
            this.method.abort();
            throw e;
        }
    }

    public long getContentLength() {
        return this.contentSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean canRepeat() {
        return !this.readStream;
    }
}

