/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cds;

import com.ibm.cds.CDSBundleFile;
import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;

public class CDSHookImpls
implements ClassLoadingStatsHook,
ClassLoadingHook,
BundleFileWrapperFactoryHook {
    private static SharedClassHelperFactory factory = Shared.getSharedClassHelperFactory();
    private static Method minimizeMethod = null;
    private static boolean hasMinimizeMethod = true;

    public void postFindLocalClass(String name, Class clazz, ClasspathManager manager) {
    }

    public void postFindLocalResource(String name, URL resource, ClasspathManager manager) {
    }

    public void preFindLocalClass(String name, ClasspathManager manager) throws ClassNotFoundException {
    }

    public void preFindLocalResource(String name, ClasspathManager manager) {
    }

    public void recordClassDefine(String name, Class clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        if (clazz == null || !this.hasMagicClassNumber(classbytes) || !(classpathEntry.getBundleFile() instanceof CDSBundleFile)) {
            return;
        }
        CDSBundleFile cdsFile = (CDSBundleFile)classpathEntry.getBundleFile();
        if (cdsFile.getURL() == null) {
            return;
        }
        SharedClassURLHelper urlHelper = cdsFile.getURLHelper();
        if (urlHelper == null) {
            BundleFile hostBundleFile = manager.getBaseData().getBundleFile();
            if (hostBundleFile instanceof CDSBundleFile) {
                urlHelper = ((CDSBundleFile)hostBundleFile).getURLHelper();
            }
            if (urlHelper != null) {
                cdsFile.setURLHelper(urlHelper);
            }
        }
        if (urlHelper != null) {
            urlHelper.storeSharedClass(cdsFile.getURL(), clazz);
            cdsFile.setPrimed(true);
        }
    }

    private boolean runMinimizeMethod(SharedClassURLHelper urlHelper) {
        if (hasMinimizeMethod && urlHelper != null) {
            if (minimizeMethod == null) {
                hasMinimizeMethod = false;
                try {
                    Class<?> c = urlHelper.getClass();
                    Field isSupported = c.getField("MINIMIZE_ENABLED");
                    if (isSupported != null && isSupported.getBoolean(urlHelper)) {
                        minimizeMethod = c.getMethod("setMinimizeUpdateChecks", null);
                        hasMinimizeMethod = true;
                    }
                }
                catch (Exception exception) {}
            }
            if (minimizeMethod != null) {
                try {
                    minimizeMethod.invoke((Object)urlHelper, null);
                    return true;
                }
                catch (Exception exception) {
                    hasMinimizeMethod = false;
                }
            }
        }
        return false;
    }

    private boolean hasMagicClassNumber(byte[] classbytes) {
        if (classbytes == null || classbytes.length < 4) {
            return false;
        }
        return (classbytes[0] & 0xCA) == 202 && (classbytes[1] & 0xFE) == 254 && (classbytes[2] & 0xBA) == 186 && (classbytes[3] & 0xBE) == 190;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
        if (factory == null) {
            return;
        }
        try {
            SharedClassURLHelper urlHelper = factory.getURLHelper((ClassLoader)baseClassLoader);
            boolean minimizeSucceeded = this.runMinimizeMethod(urlHelper);
            BundleFile hostFile = data.getBundleFile();
            if (hostFile instanceof CDSBundleFile) {
                ((CDSBundleFile)hostFile).setURLHelper(urlHelper);
                if (minimizeSucceeded) {
                    ((CDSBundleFile)hostFile).setPrimed(true);
                }
            }
        }
        catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {}
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        return null;
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        BundleFile sourceFile;
        BundleFile hostFile = hostmanager.getBaseData().getBundleFile();
        if (hostFile != (sourceFile = sourcedata.getBundleFile()) && hostFile instanceof CDSBundleFile && sourceFile instanceof CDSBundleFile) {
            ((CDSBundleFile)sourceFile).setURLHelper(((CDSBundleFile)hostFile).getURLHelper());
        }
        return false;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) throws IOException {
        if (!base && data.getBundleID() != 0L) {
            SharedClassURLHelper urlHelper = null;
            BundleFile baseFile = data.getBundleFile();
            if (baseFile instanceof CDSBundleFile) {
                urlHelper = ((CDSBundleFile)baseFile).getURLHelper();
            }
            return new CDSBundleFile(bundleFile, urlHelper);
        }
        return new CDSBundleFile(bundleFile);
    }
}

