/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.client.internal.util;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.TeamServerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClientURIUtils {
    public static ITeamRepository findTeamRepository(URI uri) {
        String repositoryURI = ClientURIUtils.findRepositoryURI(uri);
        if (repositoryURI == null) {
            return null;
        }
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository repository = repositories[i];
            if (repository.getRepositoryURI().equals(repositoryURI)) {
                return repository;
            }
            if (repository.getRepositoryURI().equals(String.valueOf(repositoryURI) + "/")) {
                repository.addAliasRepositoryURI(repositoryURI);
                return repository;
            }
            if (repository.getAliasRepositoryURIs().contains(repositoryURI)) {
                return repository;
            }
            if (repository.getAliasRepositoryURIs().contains(String.valueOf(repositoryURI) + "/")) {
                repository.addAliasRepositoryURI(repositoryURI);
                return repository;
            }
            String publicUriRoot = repository.publicUriRoot();
            if (publicUriRoot != null && publicUriRoot.equals(repositoryURI)) {
                repository.addAliasRepositoryURI(publicUriRoot);
                return repository;
            }
            ++i;
        }
        return null;
    }

    public static URI toPublicRepositoryURI(URI uri) {
        String uriStr;
        ITeamRepository repository = ClientURIUtils.findTeamRepository(uri);
        if (repository != null && repository.publicUriRoot() != null && (uriStr = uri.toString()).contains(repository.getRepositoryURI())) {
            String nonRepositoryPartStr = uriStr.substring(repository.getRepositoryURI().length());
            String publicUriStr = !nonRepositoryPartStr.startsWith("/") ? String.valueOf(repository.publicUriRoot()) + "/" + nonRepositoryPartStr : String.valueOf(repository.publicUriRoot()) + nonRepositoryPartStr;
            try {
                return new URI(publicUriStr);
            }
            catch (URISyntaxException uRISyntaxException) {
                return uri;
            }
        }
        return uri;
    }

    public static ITeamRepository getLoggedInTeamRepository(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = ClientURIUtils.findTeamRepository(uri);
        String repositoryURI = repository != null ? repository.getRepositoryURI() : ClientURIUtils.findRepositoryURI(uri);
        if (repositoryURI == null) {
            throw new TeamRepositoryException("Could not extract repository URI");
        }
        return TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, monitor);
    }

    public static URI findTeamRepositoryURI(URI uri) {
        String repositoryURI = ClientURIUtils.findRepositoryURI(uri);
        if (repositoryURI == null) {
            return null;
        }
        return URI.create(repositoryURI);
    }

    private static String findRepositoryURI(URI uri) {
        String repositoryURL;
        String baseURI = ClientURIUtils.findLocationRepositoryURI(uri);
        if (baseURI != null && TeamServerFactory.INSTANCE.validateURL(baseURI) == 0) {
            return baseURI;
        }
        String scheme = uri.getScheme();
        String authority = uri.getRawAuthority();
        String path = uri.getRawPath();
        if (scheme == null || authority == null) {
            return null;
        }
        if (path == null) {
            path = "";
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (TeamServerFactory.INSTANCE.validateURL(repositoryURL = String.valueOf(scheme) + "://" + authority + path) == 0) {
            return repositoryURL;
        }
        return null;
    }

    private static String findLocationRepositoryURI(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            if (!"".equals(location.getRepoUri())) {
                return location.getRepoUri();
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }
}

