/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.editor;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TeamSectionPart
extends SectionPart {
    private Control fLastFocusControl = null;

    public TeamSectionPart(Section section) {
        super(section);
        this.installActivationListener((Control)this.getSection());
    }

    public TeamSectionPart(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.installActivationListener((Control)this.getSection());
    }

    private void installActivationListener(Control control) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Display display = event.widget.getDisplay();
                Control focusControl = display.getFocusControl();
                if (this.isParent((Control)event.widget, focusControl)) {
                    TeamSectionPart.this.fLastFocusControl = focusControl;
                }
            }

            private boolean isParent(Control parent, Control child) {
                while (parent != child && child != null) {
                    child = child.getParent();
                }
                return parent == child;
            }
        };
        control.addListener(27, listener);
    }

    public void setFocus() {
        Control lastFocusControl = this.getLastFocusControl();
        if (lastFocusControl != null) {
            lastFocusControl.setFocus();
        } else {
            super.setFocus();
        }
    }

    protected Control getLastFocusControl() {
        if (this.fLastFocusControl != null && this.fLastFocusControl.isDisposed()) {
            this.fLastFocusControl = null;
        }
        return this.fLastFocusControl;
    }
}

