/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.editor;

import com.ibm.team.ui.editor.ITeamFormConfiguration;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormPartSite;
import com.ibm.team.ui.editor.TeamSectionPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TeamFormSectionPart
extends TeamSectionPart {
    private ITeamFormPartSite fSite = new TeamFormPartSite((AbstractFormPart)this);
    private TeamFormPart[] fParts;

    public TeamFormSectionPart(IManagedForm managedForm, String title, TeamFormPart[] parts) {
        this(managedForm, 320, title, parts);
    }

    public TeamFormSectionPart(IManagedForm managedForm, int style, String title, TeamFormPart[] parts) {
        this(managedForm, managedForm.getForm().getBody(), style, title, parts);
    }

    public TeamFormSectionPart(IManagedForm managedForm, Composite parent, int style, String title, TeamFormPart[] parts) {
        super(parent, managedForm.getToolkit(), style);
        this.init(managedForm, title, parts);
    }

    public TeamFormSectionPart(IManagedForm managedForm, Section section, String title, TeamFormPart[] parts) {
        super(section);
        this.init(managedForm, title, parts);
    }

    private void init(IManagedForm managedForm, String title, TeamFormPart[] parts) {
        this.initialize(managedForm);
        this.fParts = parts;
        Control control = this.createContent(managedForm);
        this.getSection().setClient(control);
        this.getSection().setText(title);
    }

    protected Control createContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = toolkit.createComposite((Composite)this.getSection());
        this.createPartContents(container, toolkit, this.getParts(), false, false);
        return container;
    }

    protected void createPartContents(Composite parent, FormToolkit toolkit, TeamFormPart[] parts, boolean isHorizontalLayout, boolean isBackgroundInherited) {
        if (!isHorizontalLayout) {
            TeamFormLayouts.createLayout(parent, ITeamFormConfiguration.LABEL_CONTENT_CONFIGURATION);
        } else {
            GridLayout layout = new GridLayout(isHorizontalLayout ? parts.length : 1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            parent.setLayout((Layout)layout);
        }
        int i = 0;
        while (i < parts.length) {
            this.createPartContent(parent, toolkit, parts[i], isBackgroundInherited);
            ++i;
        }
    }

    protected void createPartContent(Composite parent, FormToolkit toolkit, TeamFormPart part, boolean isBackgroundInherited) {
        part.init(this.fSite);
        ITeamFormLayout formLayout = TeamFormLayouts.getLayout(parent);
        if (formLayout != null) {
            part.createContent(formLayout);
            formLayout.nextVertGuide();
        } else {
            Composite container = toolkit.createComposite(parent);
            container.setLayoutData((Object)new GridData(4, 4, part.stretchHorizontally(), part.stretchVertically()));
            part.createContent(container);
            if (isBackgroundInherited) {
                container.setBackground(null);
            }
        }
    }

    public void passFocus(TeamFormPart part) {
        TeamFormPart[] subSections = this.getParts();
        int i = 0;
        while (i < subSections.length) {
            if (part == subSections[i]) {
                if (i + 1 >= subSections.length && this.getManagedForm().getContainer() instanceof TeamFormPage) {
                    ((TeamFormPage)((Object)this.getManagedForm().getContainer())).passFocus((IFormPart)this);
                    break;
                }
                subSections[(i + 1) % subSections.length].setFocus();
                break;
            }
            ++i;
        }
    }

    public boolean setFormInput(Object input) {
        TeamFormPart[] sections = this.getParts();
        int i = 0;
        while (i < sections.length) {
            sections[i].setInput(input);
            ++i;
        }
        return false;
    }

    public void commit(boolean onSave) {
        TeamFormPart[] sections = this.getParts();
        int i = 0;
        while (i < sections.length) {
            sections[i].commit();
            ++i;
        }
        super.commit(onSave);
    }

    public void dispose() {
        TeamFormPart[] sections = this.getParts();
        int i = 0;
        while (i < sections.length) {
            sections[i].dispose();
            ++i;
        }
        super.dispose();
    }

    protected TeamFormPart[] getParts() {
        return this.fParts;
    }
}

