/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.editor;

import com.ibm.team.ui.editor.TeamFormEditor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;

public class TeamFormPage
extends FormPage {
    private InternalActivationListener fActivationListener = new InternalActivationListener();
    private IFormPart fLastActivePart = null;

    public TeamFormPage(String id, String title) {
        super(id, title);
    }

    public TeamFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void init(IEditorSite site, IEditorInput input) {
        if (this.getSite() == null) {
            this.setSite((IWorkbenchPartSite)site);
            site.setSelectionProvider(this.getEditor().getSite().getSelectionProvider());
        }
        this.setInput(input);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.getManagedForm() != null) {
            IFormPart[] parts = this.getManagedForm().getParts();
            int i = 0;
            while (i < parts.length) {
                if (!parts[i].isDirty()) {
                    parts[i].commit(true);
                }
                ++i;
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null) {
            managedForm.setInput((Object)input);
        }
    }

    public void setFocus() {
        if (this.getLastActivePart() != null) {
            this.getLastActivePart().setFocus();
        } else {
            super.setFocus();
        }
    }

    protected IFormPart getLastActivePart() {
        return this.fLastActivePart;
    }

    protected void addPart(SectionPart part) {
        this.addPart((IFormPart)part, (Control)part.getSection());
    }

    protected void addPart(IFormPart part, Control control) {
        this.getManagedForm().addPart(part);
        this.fActivationListener.install(part, control);
    }

    public void passFocus(IFormPart part) {
        IFormPart[] parts = this.getManagedForm().getParts();
        int i = 0;
        while (i < parts.length) {
            if (part == parts[i]) {
                if (i + 1 >= parts.length && this.getEditor() instanceof TeamFormEditor) {
                    ((TeamFormEditor)this.getEditor()).passFocus((IFormPage)this);
                    break;
                }
                parts[(i + 1) % parts.length].setFocus();
                break;
            }
            ++i;
        }
    }

    private class InternalActivationListener
    implements Listener {
        private Map fControlsToParts = new HashMap();

        private InternalActivationListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 26) {
                TeamFormPage.this.fLastActivePart = (IFormPart)this.fControlsToParts.get(event.widget);
            } else if (event.type == 12) {
                this.uninstall((Control)event.widget);
            }
        }

        public void install(IFormPart part, Control control) {
            this.fControlsToParts.put(control, part);
            control.addListener(26, (Listener)this);
            control.addListener(12, (Listener)this);
        }

        private void uninstall(Control control) {
            IFormPart part = (IFormPart)this.fControlsToParts.remove(control);
            if (TeamFormPage.this.getLastActivePart() == part) {
                TeamFormPage.this.fLastActivePart = null;
            }
            if (!control.isDisposed()) {
                control.removeListener(26, (Listener)this);
                control.removeListener(12, (Listener)this);
            }
        }
    }
}

