/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.editor;

import com.ibm.team.ui.editor.TeamFormSelectionProvider;
import com.ibm.team.ui.editor.TeamFormToolkit;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class TeamFormEditor
extends SharedHeaderFormEditor {
    private boolean fChangingPage = false;

    public TeamFormEditor() {
        this.pages = new Vector(){
            private static final long serialVersionUID = -2767605614048989439L;

            public void add(int arg0, Object arg1) {
                if (arg1 != null) {
                    super.add(arg0, arg1);
                }
            }
        };
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new TeamFormSelectionProvider());
    }

    protected Composite createPageContainer(Composite parent) {
        Composite container = super.createPageContainer(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.getHeaderForm().getForm().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getToolkit().decorateFormHeading(this.getHeaderForm().getForm().getForm());
        if (this.getEditorInput() != null) {
            this.getHeaderForm().setInput((Object)this.getEditorInput());
        }
        return container;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.getHeaderForm() != null) {
            this.getHeaderForm().setInput((Object)input);
        }
        if (this.pages != null) {
            for (IFormPage formPage : this.pages) {
                IManagedForm managedForm = formPage.getManagedForm();
                if (managedForm == null) continue;
                managedForm.setInput((Object)input);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.getHeaderForm().commit(true);
        if (this.pages != null) {
            for (IFormPage formPage : this.pages) {
                formPage.doSave(monitor);
            }
        }
    }

    protected void createPages() {
        super.createPages();
        if (this.getActivePage() == -1) {
            super.setActivePage(0);
        }
    }

    protected void removePages() {
        if (this.pages != null) {
            int size = this.pages.size();
            int currentPage = this.getCurrentPage();
            int i = 0;
            while (i < size) {
                if (i < currentPage) {
                    this.removePage(0);
                } else if (i > currentPage) {
                    this.removePage(1);
                }
                ++i;
            }
            if (size > 0) {
                this.removePage(0);
            }
        }
    }

    protected FormToolkit createToolkit(Display display) {
        return new TeamFormToolkit(display);
    }

    public void passFocus(IFormPage page) {
        block4: {
            block2: {
                block3: {
                    if (page != null) break block2;
                    int current = this.getCurrentPage();
                    if (current == -1 || !(this.pages.get(current) instanceof IEditorPart)) break block3;
                    ((IEditorPart)this.pages.get(current)).setFocus();
                    break block4;
                }
                if (this.pages.isEmpty() || !(this.pages.get(0) instanceof IEditorPart)) break block4;
                ((IEditorPart)this.pages.get(0)).setFocus();
                break block4;
            }
            int i = 0;
            while (i < this.pages.size()) {
                if (this.pages.get(i) == page) {
                    this.setActivePage((i + 1) % this.pages.size());
                    break;
                }
                ++i;
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        try {
            this.fChangingPage = true;
            super.pageChange(newPageIndex);
        }
        finally {
            this.fChangingPage = false;
        }
    }

    public void setFocus() {
        boolean isActivePart;
        boolean bl = isActivePart = this.getSite().getPage().getActivePart() == this;
        if (isActivePart || !this.fChangingPage) {
            super.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.clearListeners();
    }
}

