/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.viewerutilities;

import com.ibm.team.jface.viewerutilities.Messages;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class ContextMenuHelper {
    public static final String NEW_MENU_ID = "jazz.new";
    public static final String NEW_MENU_GROUP = "group1";
    public static final String CM_NEW_GROUP = "jazz.new.group";
    public static final String CM_OPEN_GROUP = "jazz.open.group";
    public static final String CM_NAVIGATE_GROUP = "jazz.navigate.group";
    public static final String CM_REFACTORING_GROUP = "jazz.refactoring.group";
    public static final String CM_ADDITIONS_GROUP = "additions";
    public static final String CM_PROPERTIES_GROUP = "jazz.properties.group";
    public static final String CM_COMPARE_GROUP = "jazz.compare.group";

    public static void buildStandardContextMenuGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator(CM_NEW_GROUP));
        manager.add((IContributionItem)new GroupMarker(CM_OPEN_GROUP));
        manager.add((IContributionItem)new Separator(CM_NAVIGATE_GROUP));
        manager.add((IContributionItem)new Separator(CM_REFACTORING_GROUP));
        manager.add((IContributionItem)new Separator(CM_COMPARE_GROUP));
        manager.add((IContributionItem)new Separator(CM_ADDITIONS_GROUP));
        manager.add((IContributionItem)new Separator(CM_PROPERTIES_GROUP));
    }

    public static void addNewSubmenu(IMenuManager manager, boolean withKeyBinding) {
        MenuManager target = new MenuManager(ContextMenuHelper.getNewMenuLabel(withKeyBinding), NEW_MENU_ID);
        Separator sep = new Separator(NEW_MENU_GROUP);
        target.add((IContributionItem)sep);
        manager.prependToGroup(CM_NEW_GROUP, (IContributionItem)target);
    }

    private static String getNewMenuLabel(boolean withKeyBinding) {
        if (withKeyBinding) {
            String keyBinding = null;
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            if (bindingService != null) {
                keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.file.newQuickMenu");
            }
            if (keyBinding == null) {
                keyBinding = "";
            }
            return NLS.bind((String)Messages.ContextMenuHelper_NEW_KEY, (Object)keyBinding);
        }
        return Messages.ContextMenuHelper_NEW;
    }
}

