/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.team.jface.timeline.Range;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

class Scale {
    private Range fRange;
    private long[] fTicks;
    private String[] fText;
    private Color[] fBarBackground;
    private Color[] fBarForeground;
    private Color[] fBarBorderColor;
    private int[] fTextAlign;
    private Font[] fFonts;
    private Range[] fRanges;

    public Scale(Range range, Date[] ticks) {
        this.fRange = range;
        this.fText = new String[ticks.length];
        this.fBarBackground = new Color[ticks.length];
        this.fBarForeground = new Color[ticks.length];
        this.fBarBorderColor = new Color[ticks.length];
        this.fTextAlign = new int[ticks.length];
        this.fFonts = new Font[ticks.length];
        this.fRanges = new Range[ticks.length];
        this.fTicks = new long[ticks.length];
        int i = 0;
        while (i < ticks.length) {
            Date date = ticks[i];
            this.fTicks[i] = date.getTime();
            ++i;
        }
    }

    public String getText(int index) {
        Assert.isLegal((index < this.fText.length ? 1 : 0) != 0);
        return this.fText[index];
    }

    public void setText(String text, int index) {
        Assert.isLegal((index < this.fText.length ? 1 : 0) != 0);
        this.fText[index] = text;
    }

    public long getTick(int index) {
        Assert.isLegal((index < this.fTicks.length ? 1 : 0) != 0);
        return this.fTicks[index];
    }

    public Range getRange(int index) {
        if (this.fRanges[index] != null) {
            return this.fRanges[index];
        }
        Assert.isLegal((index < this.fTicks.length ? 1 : 0) != 0);
        long from = this.getTick(index);
        long to = index + 1 < this.fTicks.length ? this.getTick(index + 1) : this.fRange.getEnd();
        this.fRanges[index] = new Range(from, to -= 10000L);
        return this.fRanges[index];
    }

    public int getTickCount() {
        return this.fTicks.length;
    }

    public Range getRange() {
        return this.fRange;
    }

    public Color getBarBackground(int index) {
        Assert.isLegal((index < this.fBarBackground.length ? 1 : 0) != 0);
        return this.fBarBackground[index];
    }

    public void setBarBackground(Color background, int index) {
        Assert.isLegal((index < this.fBarBackground.length ? 1 : 0) != 0);
        this.fBarBackground[index] = background;
    }

    public Color getBarForeground(int index) {
        Assert.isLegal((index < this.fBarForeground.length ? 1 : 0) != 0);
        return this.fBarForeground[index];
    }

    public void setBarForeground(Color foreground, int index) {
        Assert.isLegal((index < this.fBarForeground.length ? 1 : 0) != 0);
        this.fBarForeground[index] = foreground;
    }

    public Color getBarBorder(int index) {
        Assert.isLegal((index < this.fBarBorderColor.length ? 1 : 0) != 0);
        return this.fBarBorderColor[index];
    }

    public void setBarBorder(Color border, int index) {
        Assert.isLegal((index < this.fBarBorderColor.length ? 1 : 0) != 0);
        this.fBarBorderColor[index] = border;
    }

    public Font getFont(int index) {
        Assert.isLegal((index < this.fFonts.length ? 1 : 0) != 0);
        return this.fFonts[index];
    }

    public void setFont(Font font, int index) {
        Assert.isLegal((index < this.fFonts.length ? 1 : 0) != 0);
        this.fFonts[index] = font;
    }

    public int getTextAlign(int index) {
        Assert.isLegal((index < this.fTextAlign.length ? 1 : 0) != 0);
        return this.fTextAlign[index];
    }

    public void setTextAlign(int textAlign, int index) {
        Assert.isLegal((index < this.fTextAlign.length ? 1 : 0) != 0);
        this.fTextAlign[index] = textAlign;
    }
}

