/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.preview;

import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DomainAdapterRegistry {
    private HashMap<String, IConfigurationElement> fRegistry = new HashMap();
    private HashMap<String, IDomainAdapter> fDomainAdapterCache = new HashMap();
    private static final String EXTENSION_POINT_ID = "com.ibm.team.jface.domainAdapter";

    public DomainAdapterRegistry() {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement domainAdapter = elements[j];
                    IConfigurationElement[] types = domainAdapter.getChildren();
                    int k = 0;
                    while (k < types.length) {
                        IConfigurationElement element = types[k];
                        String type = element.getAttribute("class");
                        this.fRegistry.put(type, domainAdapter);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public IDomainAdapter getDomainAdapter(Object object) {
        if (object != null) {
            return this.getDomainAdapter1(object.getClass());
        }
        return null;
    }

    private IDomainAdapter getDomainAdapter1(Class clazz1) {
        IDomainAdapter domainAdapter = this.getDomainAdapter2(clazz1);
        if (domainAdapter != null) {
            return domainAdapter;
        }
        Class superclass = clazz1.getSuperclass();
        if (superclass != null && (domainAdapter = this.getDomainAdapter1(superclass)) != null) {
            return domainAdapter;
        }
        Class<?>[] interfaces = clazz1.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            domainAdapter = this.getDomainAdapter1(interfaces[i]);
            if (domainAdapter != null) {
                return domainAdapter;
            }
            ++i;
        }
        return null;
    }

    private IDomainAdapter getDomainAdapter2(Class clazz1) {
        String name = clazz1.getName();
        if (this.fDomainAdapterCache.containsKey(name)) {
            return this.fDomainAdapterCache.get(name);
        }
        IConfigurationElement domainAdapter = this.fRegistry.get(name);
        if (domainAdapter != null) {
            try {
                IDomainAdapter adapter = (IDomainAdapter)domainAdapter.createExecutableExtension("class");
                this.fDomainAdapterCache.put(name, adapter);
                return adapter;
            }
            catch (CoreException e) {
                JFacePlugin.getDefault().log("can't create IDomainAdapter", e);
            }
        }
        return null;
    }
}

