/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.labelProviders;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.ITypeLabelProviderFactory;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class StandardLabelProvider
extends TypeLabelProvider
implements IElementRemovedListener {
    private static final String DISABLED_MESSAGE = "A label provider produced an error and was disabled";
    private ILabelProvider fFallBackLabelProvider;
    private Map fCashedLabelers = new HashMap();
    private IElementRemovedNotifier fNotifier;
    private ILabelDecorator fDecorator;
    private WeakHashMap fMappedModelInstances;
    private boolean fDisposed = false;
    private IViewerLabelProvider fWorkbenchLabelProvider;
    private IViewerLabelProvider fErrorLabelProvider = new TypeLabelProvider(){

        public void updateLabel(ViewerLabel label, Object element) {
        }
    };
    private ILabelProviderListener fListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            if (StandardLabelProvider.this.fDisposed) {
                return;
            }
            Object[] elements = event.getElements();
            if (elements != null) {
                ArrayList<Object> allelems = new ArrayList<Object>();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] == null) {
                        JFacePlugin.getDefault().log("Elements of label update event contains null entry. Source: " + event.getSource(), new NullPointerException());
                    } else {
                        allelems.add(elements[i]);
                        List mapped = (List)StandardLabelProvider.this.fMappedModelInstances.get(elements[i]);
                        if (mapped != null) {
                            if (mapped.size() == 0) {
                                StandardLabelProvider.this.fMappedModelInstances.remove(elements[i]);
                            }
                            for (WeakReference ref : mapped) {
                                Object object = ref.get();
                                if (object == null) continue;
                                allelems.add(object);
                            }
                        }
                    }
                    ++i;
                }
                elements = allelems.toArray();
                if (elements.length > 0) {
                    LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)StandardLabelProvider.this, elements);
                    StandardLabelProvider.this.fireLabelProviderChanged(newEvent);
                }
            } else {
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)StandardLabelProvider.this);
                StandardLabelProvider.this.fireLabelProviderChanged(newEvent);
            }
        }
    };

    public StandardLabelProvider(IElementRemovedNotifier notifier) {
        this.init(null, notifier);
    }

    public StandardLabelProvider(ILabelProvider fallBackLabelProvider, IElementRemovedNotifier notifier) {
        this.init(fallBackLabelProvider, notifier);
    }

    private void init(ILabelProvider fallBackLabelProvider, IElementRemovedNotifier notifier) {
        this.fFallBackLabelProvider = fallBackLabelProvider;
        if (this.fFallBackLabelProvider != null) {
            this.fFallBackLabelProvider.addListener(this.fListener);
        }
        this.fNotifier = notifier;
        notifier.addElementRemovedListener(this);
        this.fDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.fDecorator.addListener(this.fListener);
        this.fMappedModelInstances = new WeakHashMap();
        this.fWorkbenchLabelProvider = (IViewerLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.fWorkbenchLabelProvider.addListener(this.fListener);
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (this.fDisposed) {
            throw new IllegalStateException("StandardLabelProvider is already disposed");
        }
        if (element == null) {
            throw new IllegalArgumentException("element to be rendered was <null>");
        }
        if (label == null) {
            throw new IllegalArgumentException("label must not be null");
        }
        IViewerLabelProvider labeler = this.getLabeler(element);
        if (!this.doUpdate(label, element, labeler)) {
            Object modelInstance = this.getModelInstance(element);
            if (modelInstance != null && this.doUpdate(label, modelInstance, labeler = this.getLabeler(modelInstance))) {
                this.cacheModelInstance(element, modelInstance);
                this.invokeDecorators(label, modelInstance);
                return;
            }
            if (this.handleWorkbenchAdapter(label, element)) {
                return;
            }
            this.fallBack(label, element);
        }
        this.invokeDecorators(label, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheModelInstance(Object element, Object modelInstance) {
        WeakHashMap weakHashMap = this.fMappedModelInstances;
        synchronized (weakHashMap) {
            ArrayList<WeakReference<Object>> wrappers = (ArrayList<WeakReference<Object>>)this.fMappedModelInstances.get(modelInstance);
            if (wrappers == null) {
                wrappers = new ArrayList<WeakReference<Object>>();
                this.fMappedModelInstances.put(modelInstance, wrappers);
            }
            boolean contains = false;
            for (WeakReference weakReference : wrappers) {
                if (!element.equals(weakReference.get())) continue;
                contains = true;
            }
            if (!contains) {
                wrappers.add(new WeakReference<Object>(element));
            }
        }
    }

    private boolean handleWorkbenchAdapter(ViewerLabel label, Object element) {
        Object realElem = element;
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Adapters.getAdapter((Object)realElem, IWorkbenchAdapter.class);
        if (adapter == null && (realElem = this.getModelInstance(element)) != null) {
            adapter = (IWorkbenchAdapter)Adapters.getAdapter((Object)realElem, IWorkbenchAdapter.class);
            this.cacheModelInstance(element, realElem);
        }
        if (adapter != null) {
            this.fWorkbenchLabelProvider.updateLabel(label, realElem);
            return true;
        }
        return false;
    }

    private Object getModelInstance(Object element) {
        final IModelAccessor accessor = (IModelAccessor)Adapters.getAdapter((Object)element, IModelAccessor.class);
        final Object[] ret = new Object[]{null};
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                if (accessor != null) {
                    ret[0] = accessor.getModelInstance();
                }
            }

            public void handleException(Throwable exception) {
                JFacePlugin.getDefault().log("Error while accessing model instance", null);
            }
        });
        return ret[0];
    }

    private boolean doUpdate(final ViewerLabel label, final Object element, final IViewerLabelProvider labeler) {
        final boolean[] ret = new boolean[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                if (labeler != null && labeler != StandardLabelProvider.this.fErrorLabelProvider) {
                    labeler.updateLabel(label, element);
                    ret[0] = true;
                    return;
                }
                if (labeler == StandardLabelProvider.this.fErrorLabelProvider) {
                    label.setText("Error: Label provider was disabled");
                    ret[0] = true;
                    return;
                }
                ret[0] = false;
            }

            public void handleException(Throwable exception) {
                if (StandardLabelProvider.this.fFallBackLabelProvider != null) {
                    ret[0] = false;
                    return;
                }
                ITypeLabelProviderFactory factory = (ITypeLabelProviderFactory)Adapters.getAdapter((Object)element, ITypeLabelProviderFactory.class);
                if (factory != null) {
                    StandardLabelProvider.this.fCashedLabelers.put(factory, StandardLabelProvider.this.fErrorLabelProvider);
                }
                labeler.dispose();
                label.setText("Error: Label provider was disabled");
                JFacePlugin.getDefault().log(StandardLabelProvider.DISABLED_MESSAGE, exception);
                ret[0] = false;
            }
        });
        return ret[0];
    }

    public void invokeDecorators(ViewerLabel label, Object element) {
        Object realElement = null;
        if (this.internalHasLabelForObject(element)) {
            realElement = element;
        } else {
            Object modelInstance;
            IModelAccessor modelAccessor = (IModelAccessor)Adapters.getAdapter((Object)element, IModelAccessor.class);
            if (modelAccessor != null && (modelInstance = modelAccessor.getModelInstance()) != null && this.internalHasLabelForObject(modelInstance)) {
                realElement = modelInstance;
            }
            if (realElement == null) {
                realElement = element;
            }
        }
        if (((IDelayedLabelDecorator)this.fDecorator).prepareDecoration(realElement, label.getText())) {
            IFontDecorator fontdecorator;
            Font font;
            Color foreground;
            IColorDecorator colordecorator;
            Color background;
            Image image;
            String text = this.fDecorator.decorateText(label.getText(), realElement);
            if (text != null) {
                label.setText(text);
            }
            if (label.getImage() != null && (image = this.fDecorator.decorateImage(label.getImage(), realElement)) != null) {
                label.setImage(image);
            }
            if ((background = (colordecorator = (IColorDecorator)this.fDecorator).decorateBackground(realElement)) != null) {
                label.setBackground(background);
            }
            if ((foreground = colordecorator.decorateForeground(realElement)) != null) {
                label.setForeground(foreground);
            }
            if ((font = (fontdecorator = (IFontDecorator)this.fDecorator).decorateFont(realElement)) != null) {
                label.setFont(font);
            }
        }
    }

    private IViewerLabelProvider getLabeler(Object element) {
        final ITypeLabelProviderFactory factory = (ITypeLabelProviderFactory)Adapters.getAdapter((Object)element, ITypeLabelProviderFactory.class);
        if (factory == null) {
            return null;
        }
        final IViewerLabelProvider[] labeler = new IViewerLabelProvider[]{(IViewerLabelProvider)this.fCashedLabelers.get(factory)};
        if (labeler[0] == null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    labeler[0] = factory.createTypeLabeler();
                    labeler[0].addListener(StandardLabelProvider.this.fListener);
                }

                public void handleException(Throwable exception) {
                    labeler[0] = StandardLabelProvider.this.fErrorLabelProvider;
                    JFacePlugin.getDefault().log(StandardLabelProvider.DISABLED_MESSAGE, null);
                }
            });
            this.fCashedLabelers.put(factory, labeler[0]);
        }
        return labeler[0];
    }

    public boolean hasLabelForObject(Object element) {
        if (this.fDisposed) {
            throw new RuntimeException("StandardLabelProvider is already disposed");
        }
        if (element == null) {
            return false;
        }
        if (this.internalHasLabelForObject(element)) {
            return true;
        }
        Object modelinstance = this.getModelInstance(element);
        if (modelinstance != null && this.internalHasLabelForObject(modelinstance)) {
            return true;
        }
        return Adapters.getAdapter((Object)element, IWorkbenchAdapter.class) != null;
    }

    private boolean internalHasLabelForObject(Object element) {
        ITypeLabelProviderFactory factory = (ITypeLabelProviderFactory)Adapters.getAdapter((Object)element, ITypeLabelProviderFactory.class);
        return factory != null && this.fCashedLabelers.get(factory) != this.fErrorLabelProvider;
    }

    public void dispose() {
        if (this.fDisposed) {
            return;
        }
        this.fDisposed = true;
        super.dispose();
        this.fDecorator.removeListener(this.fListener);
        for (IViewerLabelProvider labelProvider : this.fCashedLabelers.values()) {
            this.saveDispose((IBaseLabelProvider)labelProvider);
        }
        this.saveDispose((IBaseLabelProvider)this.fFallBackLabelProvider);
        this.fMappedModelInstances.clear();
        this.fNotifier.removeElementRemoveListener(this);
        this.fNotifier = null;
        this.fCashedLabelers = null;
        this.fWorkbenchLabelProvider.dispose();
    }

    private void saveDispose(final IBaseLabelProvider labelProvider) {
        if (labelProvider == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                labelProvider.removeListener(StandardLabelProvider.this.fListener);
            }

            public void handleException(Throwable exception) {
                JFacePlugin.getDefault().log("Error while deregistering listener to contributed label provider", null);
            }
        });
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                labelProvider.dispose();
            }

            public void handleException(Throwable exception) {
                JFacePlugin.getDefault().log("Error while disposing contributed label provider", null);
            }
        });
    }

    private boolean fallBack(final ViewerLabel label, final Object element) {
        final boolean[] ret = new boolean[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                if (StandardLabelProvider.this.fFallBackLabelProvider == null) {
                    ret[0] = false;
                    return;
                }
                if (StandardLabelProvider.this.fFallBackLabelProvider instanceof IViewerLabelProvider) {
                    ((IViewerLabelProvider)StandardLabelProvider.this.fFallBackLabelProvider).updateLabel(label, element);
                } else if (StandardLabelProvider.this.fFallBackLabelProvider != null) {
                    label.setText(StandardLabelProvider.this.fFallBackLabelProvider.getText(element));
                    label.setImage(StandardLabelProvider.this.fFallBackLabelProvider.getImage(element));
                }
                ret[0] = true;
            }

            public void handleException(Throwable exception) {
                JFacePlugin.getDefault().log("Error during fallback rendering", null);
                ret[0] = false;
            }
        });
        return ret[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleElementRemoved(final Object element) {
        if (this.fDisposed) {
            return;
        }
        final IViewerLabelProvider labeler = this.getLabeler(element);
        if (labeler != null && labeler instanceof IElementRemovedListener) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IElementRemovedListener)labeler).handleElementRemoved(element);
                }

                public void handleException(Throwable exception) {
                    ITypeLabelProviderFactory factory = (ITypeLabelProviderFactory)Adapters.getAdapter((Object)element, ITypeLabelProviderFactory.class);
                    if (factory != null) {
                        StandardLabelProvider.this.fCashedLabelers.put(factory, StandardLabelProvider.this.fErrorLabelProvider);
                    }
                    JFacePlugin.getDefault().log("Error while delegating ElementRemoved event, disabled label provider", null);
                }
            });
        }
        WeakHashMap weakHashMap = this.fMappedModelInstances;
        synchronized (weakHashMap) {
            Map.Entry[] entries = this.fMappedModelInstances.entrySet().toArray(new Map.Entry[this.fMappedModelInstances.entrySet().size()]);
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getValue() != null) {
                    WeakReference contains = null;
                    List wrappers = (List)entries[i].getValue();
                    for (WeakReference ref : wrappers) {
                        if (!element.equals(ref.get())) continue;
                        contains = ref;
                        break;
                    }
                    if (contains != null) {
                        wrappers.remove(contains);
                    }
                    if (wrappers.size() == 0) {
                        this.fMappedModelInstances.remove(entries[i].getKey());
                    }
                } else {
                    this.fMappedModelInstances.remove(entries[i].getKey());
                }
                ++i;
            }
        }
    }
}

