/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.labelProviders;

import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.labelProviders.ClassIdentifier;
import com.ibm.team.jface.labelProviders.ITypeLabelProviderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;

public final class LabelProviderFactory
implements IExecutableExtension,
IAdapterFactory {
    private IConfigurationElement element;
    private ClassIdentifier labelProviderClass;
    private boolean initialized;
    private TypeLabelProviderFactory factory;

    private static IStatus createStatus(String text, Throwable t) {
        return new Status(4, "com.ibm.team.jface", 0, text, t);
    }

    private static IStatus createStatus(String pluginId, String text, Throwable t) {
        return new Status(4, pluginId, 0, text, t);
    }

    private static void log(IStatus status) {
        JFacePlugin.getDefault().log(status);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String className;
        IConfigurationElement child;
        this.element = config;
        IConfigurationElement[] children = this.element.getChildren();
        if (children.length != 1) {
            this.throwException(config, NLS.bind((String)"{0} adapters found in the XML. LabelProviderFactory expects exactly 1 adapter of type {1}", (Object)("" + children.length), (Object)ITypeLabelProviderFactory.class.getName()));
        }
        if (!(child = children[0]).getName().equals("adapter")) {
            this.throwException(config, NLS.bind((String)"Unknown element type {0}. Expecting one element of type {1}", (Object)child.getName(), (Object)"adapter"));
        }
        if ((className = child.getAttribute("type")) == null || !className.equals(ITypeLabelProviderFactory.class.getName())) {
            this.throwException(config, NLS.bind((String)"LabelProviderFactory expects one adapter of type {0}. Found incorrect adapter of type {1}", (Object)ITypeLabelProviderFactory.class.getName(), (Object)className));
        }
        if (!(data instanceof String) || ((String)data).length() == 0) {
            this.throwException(config, NLS.bind((String)"LabelProviderFactory needs to specify the name of the label provider class. Correct usage: '{0}:com.ibm.NameOfALabelProviderClass", (Object)LabelProviderFactory.class.getName()));
        }
        this.labelProviderClass = new ClassIdentifier(config.getNamespace(), (String)data);
    }

    private void throwException(IConfigurationElement config, String string) throws CoreException {
        throw new CoreException(LabelProviderFactory.createStatus(config.getNamespace(), this.formatError(string), null));
    }

    private String formatError(String string) {
        return NLS.bind((String)"Error in the LabelProviderFactory adapter declared in plugin {0}: {1}", (Object)this.element.getNamespace(), (Object)string);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == ITypeLabelProviderFactory.class) {
            if (!this.initialized) {
                try {
                    Class clazz = this.labelProviderClass.loadClass();
                    this.factory = new TypeLabelProviderFactory(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LabelProviderFactory.log(LabelProviderFactory.createStatus(this.formatError(NLS.bind((String)"Unable to load class {0}", (Object)this.labelProviderClass.getTypeName())), null));
                }
                this.initialized = true;
            }
            return this.factory;
        }
        return null;
    }

    public final Class[] getAdapterList() {
        return new Class[]{TypeLabelProviderFactory.class};
    }

    private static final class ErrorLabelProvider
    extends LabelProvider
    implements IViewerLabelProvider {
        private String errorMessage;

        public ErrorLabelProvider(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void updateLabel(ViewerLabel label, Object element) {
            label.setText(this.errorMessage);
        }

        public String getText(Object element) {
            return this.errorMessage;
        }
    }

    private final class TypeLabelProviderFactory
    implements ITypeLabelProviderFactory {
        private Class toInstantiate;

        public TypeLabelProviderFactory(Class toInstantiate) {
            this.toInstantiate = toInstantiate;
        }

        public IViewerLabelProvider createTypeLabeler() {
            try {
                return (IViewerLabelProvider)this.toInstantiate.newInstance();
            }
            catch (InstantiationException e) {
                String errorMessage = LabelProviderFactory.this.formatError(NLS.bind((String)"Unable to instantiate class {0} with its default constructor", (Object)LabelProviderFactory.this.labelProviderClass.getTypeName()));
                IStatus status = LabelProviderFactory.createStatus(errorMessage, e);
                LabelProviderFactory.log(status);
                return new ErrorLabelProvider(errorMessage);
            }
            catch (IllegalAccessException e) {
                String errorMessage = LabelProviderFactory.this.formatError(NLS.bind((String)"Class {0} is missing a default constructor", (Object)LabelProviderFactory.this.labelProviderClass.getTypeName()));
                IStatus status = LabelProviderFactory.createStatus(errorMessage, e);
                LabelProviderFactory.log(status);
                return new ErrorLabelProvider(errorMessage);
            }
        }
    }
}

