/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.BrowserLocationListener;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.HistoryBin;
import com.ibm.team.jface.HistoryItem;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.IItemViewerLabelProvider;
import com.ibm.team.jface.itemview.ItemViewerLabel;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.itemview.Messages;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.util.CommunicatableBrowser;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ItemViewer
extends Viewer {
    public static final int MODE_SIMPLE = 0;
    public static final int MODE_TIMELINE = 1;
    static final int MODE_SHOWMARKALLREADACTION = 2;
    private static final int MAX_ITEMS_PER_HISTORY = 5;
    private static final String CALLBACK_PAGE_OFFSET = "pageYOffset";
    private static final String CALLBACK_ITEM_EXPANDED = "itemExpanded";
    private static final String CALLBACK_ITEM_COLLAPSED = "itemCollapsed";
    private static final String CALLBACK_GROUP_EXPANDED = "groupExpanded";
    private static final String CALLBACK_GROUP_COLLAPSED = "groupCollapsed";
    private static final String CALLBACK_MARK_READ = "markRead";
    private static final String CALLBACK_MARK_UNREAD = "markUnread";
    private static final String CALLBACK_MARK_ALL_READ = "markAllRead";
    private static final String CALLBACK_TOGGLE_EXPAND_ALL = "toggleExpandAll";
    private int fMode;
    private boolean fShowMarkAllReadAction;
    private Composite fParent;
    private Browser fBrowser;
    private String fCollapseImgUrl;
    private String fExpandImgUrl;
    private String fSpacerImgUrl;
    private String fMarkReadImgUrl;
    private String fMarkUnreadImgUrl;
    private RGB fTitleRGB;
    private RGB fOutlineRGB;
    private RGB fGradientRGB;
    private DateFormat fTimeFormat = DateFormat.getTimeInstance((int)3);
    private DateFormat fMediumDateFormat = DateFormat.getDateInstance((int)2);
    private boolean fShowFullContent = false;
    private Object fInput;
    private Map fIdToItemMap = new HashMap();
    private ViewerSorter fSorter;
    private IStructuredContentProvider fContentProvider;
    private ArrayList fViewerFilters;
    private IItemViewerLabelProvider fLabelProvider;
    private int fScrollposY = 0;
    private int fTotalItems;
    private List fExpandedItems = new ArrayList();
    private List fExpandedGroups = new ArrayList();

    public ItemViewer(Composite parent, int style, int mode) {
        this(parent, null, style, mode);
    }

    public ItemViewer(Composite parent, ContextProvider contextProvider, int style, int mode) {
        this.fParent = parent;
        this.fMode = mode & 1;
        this.fShowMarkAllReadAction = (mode & 2) != 0;
        CommunicatableBrowser comBrowser = new CommunicatableBrowser(this.fParent, style){

            public void callback(String id, String value) {
                ItemViewer.this.onCallback(id, value);
            }
        };
        this.fBrowser = comBrowser.getBrowser();
        this.hookControl((Control)comBrowser.getBrowser(), contextProvider);
        this.fCollapseImgUrl = JazzResources.createResourceURL("com.ibm.team.jface", "icons/html/collapse.gif");
        this.fExpandImgUrl = JazzResources.createResourceURL("com.ibm.team.jface", "icons/html/expand.gif");
        this.fSpacerImgUrl = JazzResources.createResourceURL("com.ibm.team.jface", "icons/html/spacer.gif");
        this.fMarkReadImgUrl = JazzResources.createResourceURL("com.ibm.team.jface", "icons/html/feeditem_unread.gif");
        this.fMarkUnreadImgUrl = JazzResources.createResourceURL("com.ibm.team.jface", "icons/html/feeditem_read.gif");
        this.fTitleRGB = JazzResources.getRGB("com.ibm.team.jface.itemview.TitleColor");
        this.fOutlineRGB = JazzResources.getRGB("com.ibm.team.jface.itemview.OutlineColor");
        this.fGradientRGB = JazzResources.getRGB("com.ibm.team.jface.itemview.GradientColor");
    }

    protected void hookControl(Control control, ContextProvider contextProvider) {
        ((Browser)control).addLocationListener((LocationListener)new BrowserLocationListener(contextProvider));
        ((Browser)control).addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent arg0) {
                if (!ItemViewer.this.fBrowser.isDisposed()) {
                    ItemViewer.this.fBrowser.execute("window.scrollTo(0," + ItemViewer.this.fScrollposY + ");");
                }
            }
        });
    }

    public void addFilter(ViewerFilter filter) {
        this.addFilter(filter, true);
    }

    public void addFilter(ViewerFilter filter, boolean refresh) {
        if (this.fViewerFilters == null) {
            this.fViewerFilters = new ArrayList();
        }
        if (!this.fViewerFilters.contains(filter)) {
            this.fViewerFilters.add(filter);
            if (refresh) {
                this.refresh();
            }
        }
    }

    public void removeFilter(ViewerFilter filter) {
        if (this.fViewerFilters != null && this.fViewerFilters.remove(filter)) {
            this.refresh();
        }
    }

    public void setSorter(ViewerSorter sorter) {
        this.fSorter = sorter;
        this.refresh();
    }

    public ViewerSorter getSorter() {
        return this.fSorter;
    }

    public void setLabelProvider(IItemViewerLabelProvider provider) {
        this.fLabelProvider = provider;
    }

    public void collapseAll() {
        if (this.fBrowser == null || this.fBrowser.isDisposed()) {
            return;
        }
        this.fShowFullContent = false;
        StringBuilder buf = new StringBuilder();
        Iterator iter = this.fIdToItemMap.keySet().iterator();
        while (iter.hasNext()) {
            buf.append("collapse(").append(iter.next()).append(");");
        }
        this.fBrowser.execute(buf.toString());
    }

    public void expandAll() {
        if (this.fBrowser == null || this.fBrowser.isDisposed()) {
            return;
        }
        this.fShowFullContent = true;
        StringBuilder buf = new StringBuilder();
        Iterator iter = this.fIdToItemMap.keySet().iterator();
        while (iter.hasNext()) {
            buf.append("expand(").append(iter.next()).append(");");
        }
        this.fBrowser.execute(buf.toString());
    }

    public void toggleExpandAll() {
        if (this.fBrowser == null || this.fBrowser.isDisposed()) {
            return;
        }
        this.fBrowser.execute("javascript:toggleExpandAll()");
    }

    private Object[] getSortedElements(Object[] elements) {
        if (this.fSorter == null) {
            return elements;
        }
        this.fSorter.sort((Viewer)this, elements);
        return elements;
    }

    private void onCallback(String id, String value) {
        if (CALLBACK_PAGE_OFFSET.equals(id)) {
            try {
                this.fScrollposY = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                this.fScrollposY = 0;
            }
        } else if (CALLBACK_ITEM_EXPANDED.equals(id) && !this.fExpandedItems.contains(value)) {
            this.fExpandedItems.add(value);
        } else if (CALLBACK_ITEM_COLLAPSED.equals(id)) {
            this.fExpandedItems.remove(value);
        } else if (CALLBACK_GROUP_EXPANDED.equals(id) && !this.fExpandedGroups.contains(value)) {
            this.fExpandedGroups.add(value);
        } else if (CALLBACK_GROUP_COLLAPSED.equals(id)) {
            this.fExpandedGroups.remove(value);
        } else if (CALLBACK_MARK_READ.equals(id)) {
            Object obj = this.fIdToItemMap.get(value);
            IReadStateTracker tracker = this.getReadStateTracker(obj);
            if (tracker != null && !tracker.isMarkedRead()) {
                tracker.markRead();
            }
        } else if (CALLBACK_MARK_UNREAD.equals(id)) {
            Object obj = this.fIdToItemMap.get(value);
            IReadStateTracker tracker = this.getReadStateTracker(obj);
            if (tracker != null && tracker.isMarkedRead()) {
                tracker.markUnread();
            }
        } else if (CALLBACK_TOGGLE_EXPAND_ALL.equals(id)) {
            if (this.fShowFullContent) {
                this.collapseAll();
            } else {
                this.expandAll();
            }
        } else if (CALLBACK_MARK_ALL_READ.equals(id)) {
            ArrayList actualNewsItems = new ArrayList();
            Collection visibleNews = this.fIdToItemMap.values();
            for (Object news : visibleNews) {
                if (news instanceof NewsItem) {
                    actualNewsItems.add(news);
                    continue;
                }
                IReadStateTracker tracker = this.getReadStateTracker(news);
                if (tracker == null || tracker.isMarkedRead()) continue;
                tracker.markRead();
            }
            FeedManager.getDefault().setRead(actualNewsItems.toArray(new NewsItem[actualNewsItems.size()]), true);
        }
    }

    private IReadStateTracker getReadStateTracker(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)obj;
            return (IReadStateTracker)adaptable.getAdapter(IReadStateTracker.class);
        }
        IAdapterManager manager = Platform.getAdapterManager();
        return (IReadStateTracker)manager.getAdapter(obj, IReadStateTracker.class);
    }

    private void generateBody(StringBuilder body, Object[] item, HashMap head) {
        this.renderMetaBox(body);
        int i = 0;
        while (i < item.length) {
            HistoryItem historyItem = (HistoryItem)item[i];
            if (historyItem.getItemCount() != 0) {
                if (this.fMode == 1) {
                    this.renderTimelineDateBox(body, historyItem);
                }
                Object[] elements = this.getSortedElements(historyItem.getItems());
                int j = 0;
                while (j < elements.length) {
                    Object element = elements[j];
                    ItemViewerLabel label = new ItemViewerLabel(head);
                    this.fLabelProvider.updateLabel(label, element);
                    int id = element instanceof GenericAggregationBin ? ((GenericAggregationBin)element).getMostRecent().hashCode() : element.hashCode();
                    boolean showGroup = this.fExpandedGroups.contains(String.valueOf(i) + "showMoreContainer");
                    if (i != 0 && j == 5 && this.fMode == 1) {
                        this.renderShowMore(body, j, i, !showGroup);
                        body.append("<div id=\"" + i + "showMoreContainer\" style=\"display:" + (showGroup ? "block" : "none") + ";\">");
                    }
                    body.append("<div id=\"" + id + "itemContainer\" style=\"margin-left: 5px; background-color: " + (j % 2 == 0 ? "white" : "rgb(245,245,245)") + ";\" class=\"item\">\n");
                    body.append("<table class=\"item\">\n");
                    body.append("<tr>\n");
                    body.append("<td class=\"item\">\n");
                    this.renderItem(body, i, id, label);
                    body.append("</td>\n");
                    body.append("</tr>\n");
                    body.append("</table>\n");
                    body.append("</div>\n");
                    if (i != 0 && j + 1 == elements.length && j >= 5 && this.fMode == 1) {
                        this.renderHideMore(body, j + 1, i, showGroup);
                        body.append("</div>");
                    }
                    ++j;
                }
                if (this.fMode == 1) {
                    body.append("<br/>\n");
                }
            }
            ++i;
        }
    }

    private void renderMetaBox(StringBuilder body) {
        String string;
        body.append("<div class=\"filteredVsTotalBox\">");
        body.append(NLS.bind((String)Messages.ItemViewer_SHOWING_N_OF_N_ITEMS, (Object)this.fIdToItemMap.size(), (Object)this.fTotalItems));
        if (this.fShowFullContent) {
            string = Messages.ItemViewer_COLLAPSE_ALL;
            body.append(" | <a id=\"toggleExpandAll\" style=\"text-decoration: underline; color: " + MarkupUtil.toCSS(this.fTitleRGB) + ";\" onclick=\"toggleExpandAll(); return false;\" href=\"\">" + string + "</a>");
        } else {
            string = Messages.ItemViewer_EXPAND_ALL;
            body.append(" | <a id=\"toggleExpandAll\" style=\"text-decoration: underline; color: " + MarkupUtil.toCSS(this.fTitleRGB) + ";\" onclick=\"toggleExpandAll(); return false;\" href=\"\">" + string + "</a>");
        }
        if (this.fShowMarkAllReadAction) {
            string = Messages.ItemViewer_MARK_NEWS_AS_READ;
            body.append(" | <a style=\"text-decoration: underline; color: " + MarkupUtil.toCSS(this.fTitleRGB) + ";\" onclick=\"markAllRead(); return false;\" href=\"\">" + string + "</a>");
        }
        body.append("</div>");
    }

    private void renderShowMore(StringBuilder body, int newsItemNumber, int historyItemNumber, boolean visible) {
        body.append("<div style=\"display: " + (visible ? "block" : "none") + "; margin-left: 5px; background-color: " + (newsItemNumber % 2 == 0 ? "white" : "rgb(245,245,245)") + ";\" class=\"item\" id=\"" + historyItemNumber + "showMoreLink\">\n");
        body.append("<table class=\"item\">\n");
        body.append("<tr>\n");
        body.append("<td class=\"item\">\n");
        body.append("<div class=\"showAll\">\n");
        String string = Messages.ItemViewer_SHOW_ALL_ITEMS;
        body.append("<a href=\"javascript:toggleVisibilityShowMore('" + historyItemNumber + "showMoreLink','" + historyItemNumber + "hideMoreLink','" + historyItemNumber + "showMoreContainer');\">" + string + "</a>\n");
        body.append("</div>\n");
        body.append("</td>\n");
        body.append("</tr>\n");
        body.append("</table>\n");
        body.append("</div>\n");
    }

    private void renderHideMore(StringBuilder body, int newsItemNumber, int historyItemNumber, boolean visible) {
        body.append("<div style=\"display: " + (visible ? "block" : "none") + "; margin-left: 5px; background-color: " + (newsItemNumber % 2 == 0 ? "white" : "rgb(245,245,245)") + ";\" class=\"item\" id=\"" + historyItemNumber + "hideMoreLink\">\n");
        body.append("<table class=\"item\">\n");
        body.append("<tr>\n");
        body.append("<td class=\"item\">\n");
        body.append("<div class=\"showAll\">\n");
        String str = NLS.bind((String)Messages.ItemViewer_REDUCE_TO_N_ITEMS, (Object)5);
        body.append("<a href=\"javascript:toggleVisibilityShowMore('" + historyItemNumber + "showMoreLink','" + historyItemNumber + "hideMoreLink','" + historyItemNumber + "showMoreContainer');\">" + str + "</a>\n");
        body.append("</div>\n");
        body.append("</td>\n");
        body.append("</tr>\n");
        body.append("</table>\n");
        body.append("</div>\n");
    }

    private void renderItem(StringBuilder body, int historyItemType, int id, ItemViewerLabel label) {
        URL image2;
        boolean expandItem = this.fShowFullContent || this.fExpandedItems.contains(String.valueOf(id));
        String title = label.getTitle() != null ? label.getTitle() : Messages.ItemViewer_NO_TITLE;
        String link = label.getLink();
        Date date = label.getDate();
        String description = label.getDescription() != null ? label.getDescription() : Messages.ItemViewer_NO_DESCRIPTION;
        body.append("<div class=\"header\">\n");
        body.append("<a href=\"javascript:toggleVisibility('" + id + "');\">\n");
        body.append("<img valign=\"center\" align=\"left\" id=\"" + id + "img\" src=\"" + (!expandItem ? this.fExpandImgUrl : this.fCollapseImgUrl) + "\" border=\"0\" />\n");
        body.append("</a>\n");
        URL image = label.getImage();
        if (image != null) {
            body.append("<img title=\"");
            body.append(label.getImageTooltip());
            body.append("\" style=\"padding: 0; margin: 0;\" align=\"left\" src=\"");
            body.append(JazzResources.getConformingURL(image));
            body.append("\" />\n");
        }
        if ((image2 = label.getSecondaryImage()) != null) {
            body.append("<img title=\"");
            body.append(label.getSecondaryImageTooltip());
            body.append("\" style=\"padding: 0; margin: 0;\" align=\"left\" src=\"");
            body.append(JazzResources.getConformingURL(image2));
            body.append("\" />\n");
        }
        body.append("<img style=\"padding: 0; margin: 0;\" align=\"left\" src=\"" + this.fSpacerImgUrl + "\" height=\"1\" width=\"1\" />");
        Object item = this.fIdToItemMap.get(String.valueOf(id));
        IReadStateTracker tracker = this.getReadStateTracker(item);
        if (tracker != null) {
            boolean markedRead = tracker.isMarkedRead();
            body.append("<a href=\"javascript:");
            body.append(markedRead ? CALLBACK_MARK_UNREAD : CALLBACK_MARK_READ);
            body.append("('");
            body.append(id);
            body.append("');\" id=\"toggleReadStateLink" + id + "\" >\n");
            String tooltip = Messages.ItemViewer_TOGGLE_READ_STATE;
            String imgurl = tracker.isMarkedRead() ? this.fMarkUnreadImgUrl : this.fMarkReadImgUrl;
            body.append("<img border=\"0\" style=\"padding: 0; margin: 0;\" align=\"left\" src=\"");
            body.append(imgurl);
            body.append("\" id=\"itemimg");
            body.append(id);
            body.append("\" title=\"");
            body.append(tooltip);
            body.append("\" />");
            body.append("</a>\n");
        }
        XMLString xml = XMLString.createFromPlainText((String)title);
        title = xml.getXMLText();
        String fontCSS = this.generateFontCSS(label);
        if (link != null) {
            body.append("<a onclick=\"markRead('" + id + "'); \"");
            body.append(fontCSS);
            body.append(" id=\"link");
            body.append(id);
            body.append("\" href=\"");
            body.append(link);
            body.append("\">");
            body.append(title);
            body.append("</a>\n");
        } else {
            body.append("<span ");
            body.append(fontCSS);
            body.append(" >");
            body.append(title);
            body.append("</span>");
        }
        StringBuilder dateStr = new StringBuilder("<span class=\"date\">&nbsp;&nbsp;");
        if (date != null && historyItemType == 0) {
            dateStr.append(HistoryBin.getReadableTimeDif(date)).append("</span>");
        } else if (date != null && historyItemType == 1) {
            dateStr.append(this.fTimeFormat.format(date)).append("</span>");
        } else if (date != null) {
            dateStr.append(this.fMediumDateFormat.format(date)).append("</span>");
        }
        body.append(dateStr.toString());
        body.append("</div>\n");
        String hideDescription = expandItem ? "" : "style=\"display:none;\"";
        body.append("<div id=\"" + id + "\" class=\"content\" " + hideDescription + " >\n");
        body.append(description);
        body.append("</div>\n");
    }

    private String generateFontCSS(ItemViewerLabel label) {
        StringBuilder css = new StringBuilder("style=\"");
        css.append(MarkupUtil.getFont(label.getFontName(), label.getFontHeight(), label.getFontStyle())).append(" ");
        if (label.getColor() != null) {
            css.append("color: ").append(MarkupUtil.toCSS(label.getColor())).append("; ");
        }
        css.append("\" ");
        return css.toString();
    }

    private void renderTimelineDateBox(StringBuilder strBuf, HistoryItem item) {
        strBuf.append("<table class=\"timelineBox\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
        strBuf.append("<tr class=\"timelineBox\" ><td class=\"timelineBox\" valign=\"baseline\">\n");
        strBuf.append("<div class=\"timelineBox\" id=\"" + item.getName() + "\">\n");
        strBuf.append(item.getName());
        strBuf.append("</div>\n");
        strBuf.append("</td>\n<td valign=\"baseline\">\n");
        strBuf.append("<div class=\"timelineBoxSubTitle\">(" + this.formatItemCount(item.getItemCount()) + ")</div>");
        strBuf.append("</td>\n</tr>\n</table>\n");
        strBuf.append("<div class=\"timelineBoxSeparator1\"><img src=\"" + this.fSpacerImgUrl + "\" height=\"1\" /></div>\n");
        strBuf.append("<div class=\"timelineBoxSeparator2\"><img src=\"" + this.fSpacerImgUrl + "\" height=\"1\" /></div>\n");
    }

    private String formatItemCount(int count) {
        String text;
        switch (count) {
            case 0: {
                text = Messages.ItemViewer_N_ITEM_FOUND;
                break;
            }
            case 1: {
                text = Messages.ItemViewer_N_ITEM_FOUND;
                break;
            }
            default: {
                text = Messages.ItemViewer_N_ITEMS_FOUND;
            }
        }
        return MessageFormat.format(text, new Integer(count));
    }

    private void generateCSS(StringBuffer buf) {
        FontData defaultData = JFaceResources.getDefaultFont().getFontData()[0];
        buf.append("<style type=\"text/css\">\n");
        buf.append("a { color: gray; text-decoration: none; }\n");
        buf.append("a:hover { text-decoration: underline; }\n");
        buf.append("a:link { color: gray; text-decoration: none; }\n");
        buf.append("a:visited { color: gray; text-decoration: none; }\n");
        buf.append("a:visited:hover { color: gray; text-decoration: underline; }\n");
        buf.append("div.showAll a { color: " + MarkupUtil.toCSS(this.fTitleRGB) + "; }");
        buf.append("div.showAll a:hover { text-decoration: underline; }\n");
        buf.append("div.showAll a:link { color: " + MarkupUtil.toCSS(this.fTitleRGB) + "; text-decoration: none; }\n");
        buf.append("div.showAll a:visited { color: " + MarkupUtil.toCSS(this.fTitleRGB) + "; text-decoration: none; }\n");
        buf.append("div.showAll a:visited:hover { color: " + MarkupUtil.toCSS(this.fTitleRGB) + "; text-decoration: underline; }\n");
        buf.append("table { border-color: rgb(200,200,200); }\n");
        buf.append("td { border-color: rgb(200,200,200); } \n");
        buf.append("th { border-color: rgb(200,200,200); } \n");
        buf.append("tr { border-color: rgb(200,200,200); } \n");
        buf.append("table.timelineBox { padding: 0; margin: 0; }\n");
        buf.append("td.timelineBox { padding: 0; margin: 0; } \n");
        buf.append("th.timelineBox { padding: 0; margin: 0; } \n");
        buf.append("tr.timelineBox { padding: 0; margin: 0; } \n");
        buf.append("div.timelineBox { color: " + MarkupUtil.toCSS(this.fTitleRGB) + "; padding-left: 5px; padding-top: 2px; padding-bottom: 3px; ");
        buf.append(MarkupUtil.getFont(defaultData.getName(), defaultData.getHeight() + 3, 1)).append(" } \n");
        buf.append("div.timelineBoxSubTitle { color: " + MarkupUtil.toCSS(this.fTitleRGB) + "; padding-top: 2px; padding-bottom: 3px; ");
        buf.append(MarkupUtil.getFont(defaultData.getName(), defaultData.getHeight(), 0)).append(" } \n");
        buf.append("div.timelineBoxSeparator1 { margin-left: 5px; width: 100%; height: 1px; background-color: " + MarkupUtil.toCSS(this.fOutlineRGB) + "; }\n");
        buf.append("div.timelineBoxSeparator2 { margin-left: 5px; width: 100%; height: 1px; background-color: " + MarkupUtil.toCSS(this.fGradientRGB) + "; }\n");
        buf.append("table.item { width: 98%; }\n");
        buf.append("div.header { padding-top: 2px; padding-bottom: 2px; } ");
        buf.append("div.showAll { padding-top: 2px; padding-bottom: 2px; ");
        buf.append(MarkupUtil.getFont(defaultData.getName(), defaultData.getHeight()));
        buf.append(" font-weight:bold;  }\n");
        buf.append("div.content { margin-left: 10px; padding: 10px; }\n");
        buf.append("span.date { color: gray; }\n");
        buf.append("div.filteredVsTotalBox { text-align: right; color: " + MarkupUtil.toCSS(this.fTitleRGB) + "; padding: 0; margin: 0; line-height: " + (this.fMode == 1 ? "10%" : "100%") + "; ");
        buf.append(MarkupUtil.getFont(defaultData.getName(), defaultData.getHeight()));
        buf.append(" }\n");
        buf.append("del {\n");
        buf.append("  background-color: rgb(255,229,229);\n");
        buf.append("}\n");
        buf.append("ins {\n");
        buf.append("  background-color: rgb(229,242,229);\n");
        buf.append("}\n");
        buf.append("</style>\n");
    }

    private void generateJS(StringBuffer buf) {
        buf.append("<script type=\"text/javascript\">\n");
        buf.append("function communicateToJava(id, value) {\n\t");
        buf.append("window.status = 'comBrowser://' + id + '/' + value;\n");
        buf.append("window.status = '';\n");
        buf.append(" }\n");
        buf.append("function toggleVisibility(nodeName) {\r\n");
        buf.append("  var node = document.getElementById(nodeName);\r\n");
        buf.append("  var img  = document.getElementById(nodeName + 'img');\r\n");
        buf.append("  if (node.style.display == 'none') {\r\n");
        buf.append("    node.style.display = 'block';\r\n");
        buf.append("    img.src ='" + this.fCollapseImgUrl + "';\r\n");
        buf.append("    communicateToJava('itemExpanded', nodeName);");
        buf.append("  } else {\r\n");
        buf.append("    node.style.display = 'none';\r\n");
        buf.append("    img.src ='" + this.fExpandImgUrl + "';\r\n");
        buf.append("    communicateToJava('itemCollapsed', nodeName);  ");
        buf.append("  }\r\n");
        buf.append("}\n");
        buf.append("function hideNode(nodeName) {\r\n");
        buf.append("  var node = document.getElementById(nodeName);\r\n");
        buf.append("  node.style.display = 'none';\r\n");
        buf.append("}\n");
        buf.append("function markRead(id) {\r\n");
        buf.append("  communicateToJava('markRead', id);");
        buf.append("}\n");
        buf.append("function markUnread(id) {\r\n");
        buf.append("  communicateToJava('markUnread', id);");
        buf.append("}\n");
        buf.append("function markAllRead() {\r\n");
        buf.append("  communicateToJava('markAllRead', ' ');");
        buf.append("}\n");
        buf.append("function toggleExpandAll() {\r\n");
        buf.append("  var node = document.getElementById('toggleExpandAll');\r\n");
        buf.append("  if (node.innerHTML == '" + Messages.ItemViewer_COLLAPSE_ALL + "') {\r\n");
        buf.append("    node.innerHTML = '" + Messages.ItemViewer_EXPAND_ALL + "';\r\n");
        buf.append("  } else {\r\n");
        buf.append("    node.innerHTML = '" + Messages.ItemViewer_COLLAPSE_ALL + "';\r\n");
        buf.append("  }\r\n");
        buf.append("  communicateToJava('toggleExpandAll', ' ');");
        buf.append("}\n");
        buf.append("function toggleVisibilityShowMore(nodeName1, nodeName2, nodeName3) {\r\n");
        buf.append("  var node1 = document.getElementById(nodeName1);\r\n");
        buf.append("  var node2 = document.getElementById(nodeName2);\r\n");
        buf.append("  var node3 = document.getElementById(nodeName3);\r\n");
        buf.append("  if (node1.style.display == 'none') {\r\n");
        buf.append("    node1.style.display = 'block';\r\n");
        buf.append("  } else {\r\n");
        buf.append("    node1.style.display = 'none';\r\n");
        buf.append("  }\r\n");
        buf.append("  if (node2.style.display == 'none') {\r\n");
        buf.append("    node2.style.display = 'block';\r\n");
        buf.append("  } else {\r\n");
        buf.append("    node2.style.display = 'none';\r\n");
        buf.append("  }\r\n");
        buf.append("  if (node3.style.display == 'none') {\r\n");
        buf.append("    node3.style.display = 'block';\r\n");
        buf.append("    communicateToJava('groupExpanded', nodeName3);");
        buf.append("  } else {\r\n");
        buf.append("    node3.style.display = 'none';\r\n");
        buf.append("    communicateToJava('groupCollapsed', nodeName3);");
        buf.append("  }\r\n");
        buf.append("}");
        buf.append("function collapse(nodeName) {\r\n");
        buf.append("  var node = document.getElementById(nodeName);\r\n");
        buf.append("  var img = document.getElementById(nodeName + 'img');\r\n");
        buf.append("  node.style.display = 'none';\r\n");
        buf.append("  img.src ='" + this.fExpandImgUrl + "';\r\n");
        buf.append(" communicateToJava('itemCollapsed', nodeName);");
        buf.append("}\n");
        buf.append("function expand(nodeName) {\r\n");
        buf.append("  var node = document.getElementById(nodeName);\r\n");
        buf.append("  var img = document.getElementById(nodeName + 'img');\r\n");
        buf.append("  node.style.display = 'block';\r\n");
        buf.append("  img.src ='" + this.fCollapseImgUrl + "';\r\n");
        buf.append(" communicateToJava('itemExpanded', nodeName);");
        buf.append("}\n");
        buf.append("function updateLinkReadState(nodeName, font) {\r\n");
        buf.append("  var node = document.getElementById(nodeName);\r\n");
        buf.append("  node.style.fontWeight= font;\r\n");
        buf.append("}\n");
        buf.append("function updateImageReadState(nodeName, url) {\r\n");
        buf.append("  var img = document.getElementById(nodeName);\r\n");
        buf.append("  img.src= url;\r\n");
        buf.append("}\n");
        buf.append("function updateLinkHref(nodeName, href) {\r\n");
        buf.append("  var node = document.getElementById(nodeName);\r\n");
        buf.append("  node.href= href;\r\n");
        buf.append("}\n");
        if ("win32".equals(SWT.getPlatform())) {
            buf.append("function savePageYOffset() { communicateToJava('pageYOffset', document.body.scrollTop); }\n");
        } else {
            buf.append("function savePageYOffset() { communicateToJava('pageYOffset', window.pageYOffset); }\n");
        }
        buf.append("\n</script>\n");
    }

    public Control getControl() {
        return this.fBrowser;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    private Object[] getFilteredElements(Object[] obj) {
        if (this.fViewerFilters == null) {
            return obj;
        }
        if (this.fViewerFilters != null) {
            for (ViewerFilter filter : this.fViewerFilters) {
                obj = filter.filter((Viewer)this, TreePath.EMPTY, obj);
            }
        }
        return obj;
    }

    public void refresh() {
        if (this.fContentProvider != null && this.fLabelProvider != null && !this.fBrowser.isDisposed()) {
            StringBuilder body = new StringBuilder();
            Object[] entities = this.fContentProvider.getElements(this.fInput);
            this.fTotalItems = entities.length;
            entities = this.getFilteredElements(entities);
            this.fIdToItemMap.clear();
            int i = 0;
            while (i < entities.length) {
                Object object = entities[i];
                if (object instanceof GenericAggregationBin) {
                    object = ((GenericAggregationBin)object).getMostRecent();
                }
                this.fIdToItemMap.put(String.valueOf(object.hashCode()), object);
                ++i;
            }
            HistoryBin bin = new HistoryBin(entities);
            HashMap head = new HashMap();
            this.generateBody(body, bin.getHistoryItems(), head);
            StringBuffer html = new StringBuffer();
            html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
            if ("win32".equals(SWT.getPlatform())) {
                html.append("<!-- saved from url=(0014)about:internet -->\n");
            }
            html.append("<html>\n<head>\n");
            html.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n");
            HTMLGenerator.getHeadDefinitions(html, head);
            this.generateCSS(html);
            this.generateJS(html);
            String hideScrollbars = this.fIdToItemMap.size() == 0 ? "style=\"overflow: hidden; \"" : "";
            html.append("</head>\n<body ").append(hideScrollbars).append(">\n");
            html.append(body.toString());
            html.append("</body>\n</html>\n");
            this.fBrowser.execute("savePageYOffset();");
            this.fBrowser.setText(html.toString());
        }
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setInput(Object input) {
        Object oldInput = this.fInput;
        this.fInput = input;
        this.fContentProvider.inputChanged((Viewer)this, oldInput, input);
        this.fExpandedItems.clear();
        this.fExpandedGroups.clear();
        this.fScrollposY = 0;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    void setShowFullContent(boolean showFullContent) {
        this.fShowFullContent = showFullContent;
    }

    public void update(final Object[] items) {
        FoundationUIJob job = new FoundationUIJob(Messages.ItemViewer_ADAPT_READ_STATE_PRESENTATION){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (ItemViewer.this.fBrowser.isDisposed()) {
                    return Status.OK_STATUS;
                }
                int i = 0;
                while (i < items.length) {
                    boolean isFiltered;
                    ItemViewerLabel label = new ItemViewerLabel(new HashMap());
                    Object item = ItemViewer.this.fIdToItemMap.get(items[i]);
                    boolean bl = isFiltered = ItemViewer.this.getFilteredElements(new Object[]{item}).length == 0;
                    if (item != null) {
                        ItemViewer.this.fLabelProvider.updateLabel(label, item);
                        String fontCSS = ItemViewer.this.generateFontCSS(label);
                        int fontWeightIdx = fontCSS.indexOf("font-weight");
                        StringBuilder script = new StringBuilder();
                        if (fontWeightIdx != -1) {
                            int endIdx = fontCSS.indexOf(";", fontWeightIdx);
                            script.append("updateLinkReadState(");
                            script.append("'link");
                            script.append(items[i]);
                            script.append("'");
                            script.append(",'");
                            script.append(fontCSS.substring(fontWeightIdx + 13, endIdx));
                            script.append("');");
                        }
                        IReadStateTracker tracker = ItemViewer.this.getReadStateTracker(item);
                        script.append("updateImageReadState('itemimg");
                        script.append(items[i]);
                        script.append("','");
                        if (tracker.isMarkedRead()) {
                            script.append(ItemViewer.this.fMarkUnreadImgUrl);
                        } else {
                            script.append(ItemViewer.this.fMarkReadImgUrl);
                        }
                        script.append("');");
                        StringBuilder newHref = new StringBuilder("javascript:");
                        newHref.append(tracker.isMarkedRead() ? ItemViewer.CALLBACK_MARK_UNREAD : ItemViewer.CALLBACK_MARK_READ);
                        newHref.append("(");
                        newHref.append(items[i]);
                        newHref.append(")");
                        script.append("updateLinkHref('toggleReadStateLink" + items[i] + "','" + newHref.toString() + "');");
                        if (isFiltered) {
                            script.append("hideNode('" + items[i] + "itemContainer')");
                        }
                        ItemViewer.this.fBrowser.execute(script.toString());
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

