/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.WildcardMatcher;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FullTextSearchFilter
extends ViewerFilter {
    private String fSearchFilterStr = "";
    private WildcardMatcher fWildcardMatcher = new WildcardMatcher(this.fSearchFilterStr);

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fSearchFilterStr.length() == 0) {
            return true;
        }
        return this.matches(element);
    }

    public void setSearchFilter(String value) {
        this.fSearchFilterStr = XMLString.createFromPlainText((String)value.toLowerCase()).getXMLText();
        this.fSearchFilterStr = this.fSearchFilterStr.trim();
        if (!this.fSearchFilterStr.startsWith("*")) {
            this.fSearchFilterStr = "*" + this.fSearchFilterStr;
        }
        if (!this.fSearchFilterStr.endsWith("*")) {
            this.fSearchFilterStr = String.valueOf(this.fSearchFilterStr) + "*";
        }
        this.fWildcardMatcher = new WildcardMatcher(this.fSearchFilterStr);
    }

    private boolean matches(Object element) {
        StringBuilder text = new StringBuilder();
        ArrayList<Object> items = new ArrayList<Object>();
        if (element instanceof GenericAggregationBin) {
            items.addAll(((GenericAggregationBin)element).getItems());
        } else {
            items.add(element);
        }
        for (Object e : items) {
            IDomainAdapter domainAdapter = DomainAdapterUtils.getDomainAdapter(e);
            IDomainAdapter.Info info = new IDomainAdapter.Info();
            info.isEmbeddeble = true;
            if (domainAdapter == null) continue;
            String itemText = domainAdapter.generateTitle(e);
            StringBuffer itemContent = new StringBuffer();
            domainAdapter.generateContentAsHTML(new HashMap(), itemContent, e, info);
            itemText = String.valueOf(itemText) + "\n" + itemContent;
            itemText = itemText.toLowerCase();
            text.append(itemText);
        }
        return this.fWildcardMatcher.match(text.toString());
    }
}

