/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.tooltip;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.jface.BrowserLocationListener;
import com.ibm.team.jface.internal.tooltip.IHoverSite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tooltip {
    protected static final boolean fIsMac = "carbon".equals(SWT.getPlatform());
    public static final int PREFERRED_HEIGHT = 55;
    public static final int PREFERRED_WIDTH = 190;
    public static final Point PREFERRED_SIZE = new Point(190, 55);
    private static boolean fgBlockTooltips;
    private Control fFooter;
    private Control fHeader;
    private IHoverSite fHoverSite;
    private Shell fParentShell;
    private Shell fToolTipShell;
    private Point fPreferredSize;
    private long fTextTimestamp;
    private String fText;
    private StandardContextProvider fContextProvider = new StandardContextProvider(null);
    private boolean fVisible;
    private DisposeListener fParentShellDisposeListener;
    private static final IHoverSite NULL_SITE;

    static {
        NULL_SITE = new IHoverSite(){

            public void closeRequested() {
            }

            public void focusRequested() {
            }

            public void navigatedToNext(Tooltip tooltip) {
            }

            public void navigatedToPrevious(Tooltip tooltip) {
            }

            public void openRequested() {
            }
        };
    }

    protected Tooltip(Shell parent, IHoverSite hoverSite, Point preferredSize) {
        this(parent, hoverSite, preferredSize, true);
    }

    protected Tooltip(Shell parent, IHoverSite hoverSite, Point preferredSize, boolean isSizeInDLUs) {
        this.fParentShell = parent;
        this.fHoverSite = hoverSite;
        this.store(this.fParentShell);
        if (isSizeInDLUs) {
            this.setPreferredSize(preferredSize);
        } else {
            this.setPreferredSizeInPixels(preferredSize);
        }
        this.fContextProvider.setUIContext((Object)this.fParentShell);
    }

    public void close() {
        if (!this.fVisible) {
            return;
        }
        this.fVisible = false;
        fgBlockTooltips = false;
        this.fText = null;
        if (!this.isDisposed()) {
            this.fToolTipShell.setVisible(false);
        }
        this.fHoverSite.closeRequested();
        this.fHoverSite = NULL_SITE;
    }

    public void create() {
        this.fToolTipShell = this.createShell();
        this.fHeader = this.createHeader((Composite)this.fToolTipShell);
        this.createContents((Composite)this.fToolTipShell);
        this.fFooter = this.createFooter((Composite)this.fToolTipShell);
        this.pack();
    }

    public abstract Control createContents(Composite var1);

    public abstract Control createFooter(Composite var1);

    public abstract Control createHeader(Composite var1);

    public static boolean isBlocked() {
        return fgBlockTooltips;
    }

    protected Shell createShell() {
        Shell shell = new Shell(this.fParentShell, this.getShellStyle());
        shell.setForeground(this.getForeground());
        shell.setBackground(this.getBackground());
        shell.setLayout(this.getShellLayout());
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                Tooltip.this.close();
            }

            public void shellDeactivated(ShellEvent e) {
                Tooltip.this.close();
            }
        });
        return shell;
    }

    public void dispose() {
        this.close();
        if (!this.isDisposed() && this.fToolTipShell.getShells().length == 0) {
            this.fToolTipShell.dispose();
        }
        this.remove(this.fParentShell);
    }

    protected Color getBackground() {
        return this.fParentShell.getDisplay().getSystemColor(29);
    }

    protected final Control getFooter() {
        return this.fFooter;
    }

    protected final void setFooter(Control footer) {
        this.fFooter = footer;
    }

    protected Color getForeground() {
        return this.fParentShell.getDisplay().getSystemColor(28);
    }

    protected final Control getHeader() {
        return this.fHeader;
    }

    protected IHoverSite getHoverSite() {
        return this.fHoverSite;
    }

    protected void setHoverSite(IHoverSite hoverSite) {
        this.fHoverSite = hoverSite;
    }

    public int getPreferredHeight() {
        return this.fPreferredSize.y;
    }

    public int getPreferredWidth() {
        return this.fPreferredSize.x;
    }

    public void setPreferredSize(Point size) {
        GC gc = new GC((Drawable)this.fParentShell);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int width = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)size.x);
        int height = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)size.y);
        this.fPreferredSize = new Point(width, height);
    }

    public void setPreferredSizeInPixels(Point size) {
        this.fPreferredSize = new Point(size.x, size.y);
    }

    protected abstract void updateSize();

    public final Shell getShell() {
        return this.fToolTipShell;
    }

    protected Layout getShellLayout() {
        GridLayout shellLayout = new GridLayout(1, false);
        shellLayout.marginHeight = 0;
        shellLayout.marginWidth = 0;
        shellLayout.verticalSpacing = 2;
        return shellLayout;
    }

    protected int getShellStyle() {
        return 540676;
    }

    public boolean isDisposed() {
        return this.fToolTipShell == null || this.fToolTipShell.isDisposed();
    }

    public boolean isVisible() {
        return !this.isDisposed() && this.fToolTipShell.isVisible();
    }

    public void open(Point location) {
        this.open(location, 8);
    }

    public void open(Point itemLocation, int itemHeight) {
        this.internalOpen(itemLocation, itemHeight);
    }

    private void internalOpen(Point itemLocation, int itemHeight) {
        fgBlockTooltips = true;
        if (this.fToolTipShell == null || this.fToolTipShell.isDisposed()) {
            this.create();
        }
        this.pack();
        Rectangle clientArea = this.fToolTipShell.getMonitor().getClientArea();
        Rectangle toolSize = this.fToolTipShell.getBounds();
        if (itemLocation != null) {
            Point pt = itemLocation;
            Point prefLocation = new Point(pt.x + 0, pt.y + itemHeight + 8);
            if (prefLocation.x - clientArea.x + this.fToolTipShell.getSize().x > clientArea.width) {
                prefLocation.x = pt.x - toolSize.width - 0;
            }
            if (prefLocation.y - clientArea.y + this.fToolTipShell.getSize().y > clientArea.height) {
                prefLocation.y = pt.y - toolSize.height - 8;
            }
            this.fToolTipShell.setLocation(prefLocation);
        }
        this.fToolTipShell.setVisible(true);
        this.fVisible = true;
    }

    public void pack() {
        if (!this.isDisposed()) {
            this.fToolTipShell.pack();
        }
    }

    protected void remove(Shell parent) {
        if (!parent.isDisposed()) {
            parent.setData(this.getClass().getName(), null);
            parent.removeDisposeListener(this.fParentShellDisposeListener);
        }
    }

    public void setText(String text) {
        this.fTextTimestamp = System.currentTimeMillis();
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    public long getTextTimestamp() {
        return this.fTextTimestamp;
    }

    public void setContext(URIReference context) {
        this.fContextProvider.setContext(context);
    }

    protected ContextProvider getContextProvider() {
        return this.fContextProvider;
    }

    protected void store(Shell parent) {
        parent.setData(this.getClass().getName(), (Object)this);
        this.fParentShellDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Tooltip.this.dispose();
            }
        };
        parent.addDisposeListener(this.fParentShellDisposeListener);
    }

    protected static Tooltip getCachedTooltip(Shell parent, Class<? extends Tooltip> tooltip) {
        return (Tooltip)parent.getData(tooltip.getName());
    }

    protected Browser createBrowser(Composite parent) {
        Browser browser = new Browser(parent, 0);
        browser.addLocationListener((LocationListener)new BrowserLocationListener((ContextProvider)this.fContextProvider){

            public void changing(LocationEvent event) {
                if ("about:blank".equals(event.location)) {
                    return;
                }
                super.changing(event);
                if (!event.doit) {
                    Tooltip.this.close();
                }
            }
        });
        browser.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    Tooltip.this.close();
                }
            }
        });
        return browser;
    }
}

