/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.tooltip;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.tooltip.FocusTooltip;
import com.ibm.team.jface.internal.tooltip.IHoverSite;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class NavigatorFocusTooltip
extends FocusTooltip {
    private static final String TOOLTIP_ID = NavigatorFocusTooltip.class.getName();
    private Label fHeadLabel;
    private ToolBar fLeftBar;
    private ToolItem fNavLeft;
    private ToolBar fRightBar;
    private ToolItem fNavRight;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private Composite fHeadContainer;

    protected NavigatorFocusTooltip(Shell parent, IHoverSite hoverSite, boolean isOpenable, Point preferredSize) {
        super(parent, hoverSite, isOpenable, preferredSize);
    }

    public Control createFooter(Composite parent) {
        return null;
    }

    public void dispose() {
        this.fResources.dispose();
    }

    public Control createHeader(Composite parent) {
        this.fHeadContainer = new Composite(parent, 0);
        this.fHeadContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        Listener shellMovement = new Listener(){
            Point origin;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 3: {
                        this.origin = new Point(e.x, e.y);
                        break;
                    }
                    case 4: {
                        this.origin = null;
                        break;
                    }
                    case 5: {
                        if (this.origin == null) break;
                        Point p = NavigatorFocusTooltip.this.getShell().getDisplay().map((Control)NavigatorFocusTooltip.this.getShell(), null, e.x, e.y);
                        NavigatorFocusTooltip.this.getShell().setLocation(p.x - this.origin.x, p.y - this.origin.y);
                    }
                }
            }
        };
        this.fHeadContainer.addListener(3, shellMovement);
        this.fHeadContainer.addListener(4, shellMovement);
        this.fHeadContainer.addListener(5, shellMovement);
        GridLayout titleBarLayout = new GridLayout(2, false);
        titleBarLayout.marginHeight = 0;
        titleBarLayout.marginWidth = 0;
        titleBarLayout.horizontalSpacing = 0;
        titleBarLayout.verticalSpacing = 0;
        this.fHeadContainer.setLayout((Layout)titleBarLayout);
        Composite navContainer = this.createNavigation(this.fHeadContainer);
        navContainer.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Composite barContainer = this.createHeaderBar(this.fHeadContainer);
        barContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        new Label(this.fHeadContainer, 258).setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        return this.fHeadContainer;
    }

    protected Composite createNavigation(Composite parent) {
        Composite navContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 3;
        navContainer.setLayout((Layout)layout);
        this.fLeftBar = new ToolBar(navContainer, 0x800000);
        this.fNavLeft = new ToolItem(this.fLeftBar, 8);
        this.fNavLeft.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.NAV_LEFT));
        this.fNavLeft.setHotImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.NAV_LEFT_HOVER));
        this.fNavLeft.setDisabledImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.NAV_LEFT_DISABLED));
        this.fNavLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NavigatorFocusTooltip.this.getHoverSite().navigatedToPrevious(NavigatorFocusTooltip.this);
            }
        });
        this.fHeadLabel = new Label(navContainer, 0);
        this.fRightBar = new ToolBar(navContainer, 0x800000);
        this.fNavRight = new ToolItem(this.fRightBar, 8);
        this.fNavRight.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.NAV_RIGHT));
        this.fNavRight.setHotImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.NAV_RIGHT_HOVER));
        this.fNavRight.setDisabledImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.NAV_RIGHT_DISABLED));
        this.fNavRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NavigatorFocusTooltip.this.getHoverSite().navigatedToNext(NavigatorFocusTooltip.this);
            }
        });
        return navContainer;
    }

    protected Composite createHeaderBar(Composite parent) {
        Composite barContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        barContainer.setLayout((Layout)layout);
        ToolBar bar = new ToolBar(barContainer, 0x800000);
        ToolItem open = new ToolItem(bar, 8);
        open.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.LNCH_VIEW));
        open.setDisabledImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.LNCH_VIEW_DISABLED));
        open.setEnabled(this.isOpenable());
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NavigatorFocusTooltip.this.getHoverSite().openRequested();
                NavigatorFocusTooltip.this.close();
            }
        });
        bar = new ToolBar(barContainer, 0x800000);
        ToolItem close = new ToolItem(bar, 8);
        close.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.CLOSE));
        close.setHotImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.CLOSE_ACTIVE));
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NavigatorFocusTooltip.this.close();
            }
        });
        return barContainer;
    }

    public void setNextEnabled(boolean enabled) {
        this.fNavRight.setEnabled(enabled);
    }

    public void setPrevEnabled(boolean enabled) {
        this.fNavLeft.setEnabled(enabled);
    }

    public void setTitle(String title) {
        this.fHeadLabel.setText(title);
        this.fHeadContainer.layout();
    }

    public static FocusTooltip createTooltip(Shell parent, IHoverSite hoverSite, boolean isOpenable, Point preferredSize) {
        Object data;
        if (parent.getData(TOOLTIP_ID) != null && (data = parent.getData(TOOLTIP_ID)).getClass().getName().equals(NavigatorFocusTooltip.class.getName()) && !((Tooltip)data).isDisposed()) {
            NavigatorFocusTooltip toolTip = (NavigatorFocusTooltip)data;
            toolTip.setHoverSite(hoverSite);
            boolean oldOpenableState = toolTip.isOpenable();
            toolTip.setOpenable(isOpenable);
            if (oldOpenableState && !isOpenable) {
                toolTip.getFooter().dispose();
                toolTip.getShell().layout();
            } else if (!oldOpenableState && isOpenable) {
                toolTip.createFooter((Composite)toolTip.getShell());
                toolTip.getShell().layout();
            }
            toolTip.setPreferredSize(preferredSize);
            return toolTip;
        }
        return new NavigatorFocusTooltip(parent, hoverSite, isOpenable, preferredSize);
    }

    protected void onContentLoaded(int preferredWidth, int preferredHeight) {
    }
}

