/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.notifications;

import com.ibm.team.foundation.rcp.core.internal.notification.EventCategory;
import com.ibm.team.foundation.rcp.core.internal.notification.EventType;
import com.ibm.team.foundation.rcp.core.internal.notification.NotificationManager;
import com.ibm.team.foundation.rcp.core.notification.NotificationTrigger;
import com.ibm.team.foundation.rcp.core.notification.Notifier;
import com.ibm.team.jface.internal.notifications.EventsContentProvider;
import com.ibm.team.jface.internal.notifications.EventsLabelProvider;
import com.ibm.team.jface.internal.notifications.Messages;
import com.ibm.team.jface.internal.notifications.TriggerContentProvider;
import com.ibm.team.jface.internal.notifications.TriggerLabelProvider;
import java.text.Collator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class NotificationsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "NotificationsPreferencePage";
    private static final int PREFERRED_WIDTH = 640;
    private TreeViewer fEventsViewer;
    private CheckboxTableViewer fTriggerViewer;
    private LocalResourceManager fResources;
    private Group fNotificationOptionsGroup;
    private Group fEventOptionsGroup;
    private final Collator fCollator = Collator.getInstance();

    public NotificationsPreferencesPage() {
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public void applyData(Object data) {
        if (data != null && data instanceof String) {
            String triggerId = (String)data;
            NotificationManager manager = NotificationManager.getInstance();
            NotificationTrigger trigger = manager.getTrigger(triggerId);
            if (trigger != null) {
                EventType eventType;
                String category = trigger.getCategory();
                String type = trigger.getType();
                if (type != null && (eventType = manager.getEventType(type)) != null) {
                    this.fEventsViewer.setSelection((ISelection)new StructuredSelection((Object)eventType), true);
                } else {
                    EventCategory eventCategory = manager.getCategory(category);
                    if (eventCategory != null) {
                        this.fEventsViewer.setSelection((ISelection)new StructuredSelection((Object)eventCategory), true);
                    }
                }
                this.fTriggerViewer.setSelection((ISelection)new StructuredSelection((Object)trigger));
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        MessageBox box = new MessageBox(this.getShell(), 452);
        box.setText(Messages.NotificationsPreferencesPage_PLEASE_CONFIRM);
        box.setMessage(Messages.NotificationsPreferencesPage_CONFIRM_RESTORE_DEFAULTS);
        if (box.open() == 64) {
            NotificationManager.getInstance().restoreDefaults();
            this.setInputToEventsViewer();
            IStructuredSelection selection = (IStructuredSelection)this.fEventsViewer.getSelection();
            if (!selection.isEmpty()) {
                this.fTriggerViewer.setInput(selection.getFirstElement());
            } else {
                this.fTriggerViewer.setInput(null);
            }
            this.setOptionsEnabled(false);
            this.updateTriggerCheckedState(selection);
        }
    }

    public boolean performOk() {
        NotificationManager.getInstance().saveSettings();
        return true;
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 0;
        ((GridLayout)parent.getLayout()).marginHeight = 0;
        SashForm form = new SashForm(parent, 65536);
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        form.setOrientation(256);
        this.createEventsViewer((Composite)form);
        Composite secondCol = new Composite((Composite)form, 0);
        secondCol.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)secondCol.getLayout()).marginWidth = 3;
        ((GridLayout)secondCol.getLayout()).marginHeight = 0;
        this.createTriggerViewer(secondCol);
        this.createOptions(secondCol);
        form.setWeights(new int[]{40, 60});
        this.applyDialogFont((Composite)form);
        return form;
    }

    private void createOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        this.createEventOptions(composite);
        this.createNotificationOptions(composite);
        this.setOptionsEnabled(false);
    }

    private void createNotificationOptions(Composite parent) {
        this.fNotificationOptionsGroup = new Group(parent, 0);
        this.fNotificationOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        this.fNotificationOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fNotificationOptionsGroup.setText(Messages.NotificationsPreferencesPage_OPTIONS);
        Label typeLabel = new Label((Composite)this.fNotificationOptionsGroup, 0);
        typeLabel.setText(Messages.NotificationsPreferencesPage_NOTIFIER);
        final Combo notifierList = new Combo((Composite)this.fNotificationOptionsGroup, 8);
        notifierList.setVisibleItemCount(15);
        notifierList.setLayoutData((Object)new GridData(4, 1, true, false));
        Notifier[] notifiers = NotificationManager.getInstance().getNotifier(true);
        int i = 0;
        while (i < notifiers.length) {
            Notifier notifier = notifiers[i];
            notifierList.add(notifier.getName());
            ++i;
        }
        notifierList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NotificationsPreferencesPage.this.fTriggerViewer.getSelection();
                NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                Notifier[] notifiers = NotificationManager.getInstance().getNotifier(true);
                trigger.setNotifierId(notifiers[notifierList.getSelectionIndex()].getId());
                NotificationsPreferencesPage.this.fTriggerViewer.update((Object)trigger, null);
            }
        });
        this.fTriggerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NotificationsPreferencesPage.this.setOptionsEnabled(!selection.isEmpty());
                if (!selection.isEmpty()) {
                    NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                    Notifier[] notifiers = NotificationManager.getInstance().getNotifier(true);
                    int i = 0;
                    while (i < notifiers.length) {
                        Notifier notifier = notifiers[i];
                        if (notifier.getId().equals(trigger.getNotifierId())) {
                            notifierList.select(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private void createEventOptions(Composite parent) {
        this.fEventOptionsGroup = new Group(parent, 0);
        this.fEventOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        this.fEventOptionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fEventOptionsGroup.setText(Messages.NotificationsPreferencesPage_CONDITIONS);
        Label textFilterLabel = new Label((Composite)this.fEventOptionsGroup, 0);
        textFilterLabel.setText(Messages.NotificationsPreferencesPage_MATCH_STRING);
        textFilterLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        final Text filterInput = new Text((Composite)this.fEventOptionsGroup, 2048);
        filterInput.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Label priorityFilterLabel = new Label((Composite)this.fEventOptionsGroup, 0);
        priorityFilterLabel.setText(Messages.NotificationsPreferencesPage_PRIORITY);
        final Combo priorityCombo = new Combo((Composite)this.fEventOptionsGroup, 8);
        priorityCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        priorityCombo.add(Messages.NotificationsPreferencesPage_HIGHEST);
        priorityCombo.add(Messages.NotificationsPreferencesPage_HIGH);
        priorityCombo.add(Messages.NotificationsPreferencesPage_NORMAL);
        priorityCombo.add(Messages.NotificationsPreferencesPage_LOW);
        priorityCombo.add(Messages.NotificationsPreferencesPage_LOWEST);
        Label severityFilterLabel = new Label((Composite)this.fEventOptionsGroup, 0);
        severityFilterLabel.setText(Messages.NotificationsPreferencesPage_SEVERITY);
        Composite c = new Composite((Composite)this.fEventOptionsGroup, 0);
        RowLayout layout = new RowLayout();
        layout.spacing = 10;
        c.setLayout((Layout)layout);
        final Button infoFilterCheck = new Button(c, 32);
        infoFilterCheck.setText(Messages.NotificationsPreferencesPage_INFORMATION);
        infoFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NotificationsPreferencesPage.this.fTriggerViewer.getSelection();
                NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                trigger.setShowInfo(infoFilterCheck.getSelection());
                NotificationsPreferencesPage.this.fTriggerViewer.update((Object)trigger, null);
            }
        });
        final Button warningFilterCheck = new Button(c, 32);
        warningFilterCheck.setText(Messages.NotificationsPreferencesPage_WARNING);
        warningFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NotificationsPreferencesPage.this.fTriggerViewer.getSelection();
                NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                trigger.setShowWarning(warningFilterCheck.getSelection());
                NotificationsPreferencesPage.this.fTriggerViewer.update((Object)trigger, null);
            }
        });
        final Button errorFilterCheck = new Button(c, 32);
        errorFilterCheck.setText(Messages.NotificationsPreferencesPage_ERROR);
        errorFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NotificationsPreferencesPage.this.fTriggerViewer.getSelection();
                NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                trigger.setShowError(errorFilterCheck.getSelection());
                NotificationsPreferencesPage.this.fTriggerViewer.update((Object)trigger, null);
            }
        });
        filterInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NotificationsPreferencesPage.this.fTriggerViewer.getSelection();
                NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                trigger.setTextFilter(filterInput.getText());
                NotificationsPreferencesPage.this.fTriggerViewer.update((Object)trigger, null);
            }
        });
        priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NotificationsPreferencesPage.this.fTriggerViewer.getSelection();
                NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                trigger.setMinPriority(5 - priorityCombo.getSelectionIndex());
                NotificationsPreferencesPage.this.fTriggerViewer.update((Object)trigger, null);
            }
        });
        filterInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NotificationsPreferencesPage.this.fTriggerViewer.getSelection();
                NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                trigger.setTextFilter(filterInput.getText());
                NotificationsPreferencesPage.this.fTriggerViewer.update((Object)trigger, null);
            }
        });
        this.fTriggerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NotificationsPreferencesPage.this.setOptionsEnabled(!selection.isEmpty());
                if (!selection.isEmpty()) {
                    NotificationTrigger trigger = (NotificationTrigger)selection.getFirstElement();
                    if (trigger.getTextFilter() != null) {
                        filterInput.setText(trigger.getTextFilter());
                    } else {
                        filterInput.setText("");
                    }
                    priorityCombo.select(5 - trigger.getMinPriority());
                    infoFilterCheck.setSelection(trigger.isShowInfo());
                    warningFilterCheck.setSelection(trigger.isShowWarning());
                    errorFilterCheck.setSelection(trigger.isShowError());
                }
            }
        });
    }

    private void setOptionsEnabled(boolean enabled) {
        this.setOptionsEnabled((Control)this.fNotificationOptionsGroup, enabled);
        this.setOptionsEnabled((Control)this.fEventOptionsGroup, enabled);
    }

    private void setOptionsEnabled(Control c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Composite) {
            Control[] childs;
            Composite composite = (Composite)c;
            Control[] controlArray = childs = composite.getChildren();
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setOptionsEnabled(child, enabled);
                ++n2;
            }
        }
    }

    private void createTriggerViewer(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.NotificationsPreferencesPage_NOTIFICATIONS);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, true));
        ((GridLayout)group.getLayout()).marginHeight = 5;
        ((GridLayout)group.getLayout()).marginWidth = 5;
        int style = 68386;
        this.fTriggerViewer = new CheckboxTableViewer(new Table((Composite)group, style));
        this.fTriggerViewer.setLabelProvider((IBaseLabelProvider)new TriggerLabelProvider());
        this.fTriggerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTriggerViewer.setContentProvider((IContentProvider)new TriggerContentProvider());
        this.fTriggerViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                return 0;
            }

            public int category(Object element) {
                if (element instanceof NotificationTrigger) {
                    NotificationTrigger t = (NotificationTrigger)element;
                    return t.isContributed() ? -1 : 1;
                }
                return super.category(element);
            }
        });
        this.fEventsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElem = selection.getFirstElement();
                NotificationsPreferencesPage.this.fTriggerViewer.setInput(firstElem);
                NotificationsPreferencesPage.this.setOptionsEnabled(false);
                NotificationsPreferencesPage.this.updateTriggerCheckedState(selection);
            }
        });
        this.fTriggerViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((NotificationTrigger)event.getElement()).setEnabled(event.getChecked());
                NotificationsPreferencesPage.this.fTriggerViewer.update(event.getElement(), null);
            }
        });
        Composite buttonContainer = new Composite((Composite)group, 0);
        buttonContainer.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)buttonContainer.getLayout()).marginWidth = 0;
        ((GridLayout)buttonContainer.getLayout()).marginHeight = 0;
        buttonContainer.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        Button add = new Button(buttonContainer, 8);
        add.setToolTipText(Messages.NotificationsPreferencesPage_ADD_NOTIFICATION);
        add.setText(Messages.NotificationsPreferencesPage_ADD);
        this.setButtonLayoutData(add);
        ((GridData)add.getLayoutData()).horizontalAlignment = 0x1000008;
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationsPreferencesPage.this.handleTriggerAdded();
            }
        });
        final Button remove = new Button(buttonContainer, 8);
        remove.setToolTipText(Messages.NotificationsPreferencesPage_REMOVE_NOTIFICATION);
        remove.setEnabled(false);
        remove.setText(Messages.NotificationsPreferencesPage_REMOVE);
        this.setButtonLayoutData(remove);
        ((GridData)remove.getLayoutData()).horizontalAlignment = 0x1000008;
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationsPreferencesPage.this.handleTriggerRemoved();
            }
        });
        this.fTriggerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    remove.setEnabled(!((NotificationTrigger)selection.getFirstElement()).isContributed());
                } else {
                    remove.setEnabled(false);
                }
            }
        });
    }

    private void updateTriggerCheckedState(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        Object firstElem = selection.getFirstElement();
        NotificationTrigger[] triggers = firstElem instanceof EventCategory ? NotificationManager.getInstance().getTriggerForCategory((EventCategory)firstElem) : NotificationManager.getInstance().getTriggerForType((EventType)firstElem);
        int i = 0;
        while (i < triggers.length) {
            this.fTriggerViewer.setChecked((Object)triggers[i], triggers[i].isEnabled());
            ++i;
        }
    }

    private void handleTriggerAdded() {
        NotificationTrigger newTrigger;
        IStructuredSelection selection = (IStructuredSelection)this.fEventsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        String notifierId = NotificationManager.getInstance().getDefaultNotifier().getId();
        if (selection.getFirstElement() instanceof EventCategory) {
            EventCategory category = (EventCategory)selection.getFirstElement();
            newTrigger = new NotificationTrigger(String.valueOf(System.currentTimeMillis()), category.getId(), notifierId);
        } else {
            EventType type = (EventType)selection.getFirstElement();
            newTrigger = new NotificationTrigger(String.valueOf(System.currentTimeMillis()), type.getCategory().getId(), type.getId(), notifierId);
        }
        newTrigger.setShowInfo(true);
        newTrigger.setShowWarning(true);
        newTrigger.setShowError(true);
        newTrigger.setEnabled(true);
        NotificationManager.getInstance().addTrigger(newTrigger);
        this.fTriggerViewer.add((Object)newTrigger);
        this.fTriggerViewer.setSelection((ISelection)new StructuredSelection((Object)newTrigger));
        this.fTriggerViewer.setChecked((Object)newTrigger, true);
    }

    private void handleTriggerRemoved() {
        IStructuredSelection triggerSelection = (IStructuredSelection)this.fTriggerViewer.getSelection();
        if (!triggerSelection.isEmpty()) {
            Object[] triggers = triggerSelection.toArray();
            int i = 0;
            while (i < triggers.length) {
                NotificationTrigger trigger = (NotificationTrigger)triggers[i];
                NotificationManager.getInstance().removeTrigger(trigger);
                this.fTriggerViewer.remove((Object)trigger);
                ++i;
            }
        }
    }

    private void createEventsViewer(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.NotificationsPreferencesPage_EVENTS);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new FillLayout());
        ((FillLayout)group.getLayout()).marginHeight = 5;
        ((FillLayout)group.getLayout()).marginWidth = 5;
        this.fEventsViewer = new TreeViewer((Composite)group, 68352);
        this.fEventsViewer.setContentProvider((IContentProvider)new EventsContentProvider());
        this.fEventsViewer.setLabelProvider((IBaseLabelProvider)new EventsLabelProvider());
        this.fEventsViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof EventCategory && e2 instanceof EventCategory) {
                    return NotificationsPreferencesPage.this.fCollator.compare(((EventCategory)e1).getName(), ((EventCategory)e2).getName());
                }
                if (e1 instanceof EventType && e2 instanceof EventType) {
                    return NotificationsPreferencesPage.this.fCollator.compare(((EventType)e1).getName(), ((EventType)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.setInputToEventsViewer();
    }

    private void setInputToEventsViewer() {
        EventCategory[] categories = NotificationManager.getInstance().getCategories();
        this.fEventsViewer.setInput((Object)categories);
        this.fEventsViewer.expandAll();
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    protected Point doComputeSize() {
        Point point = super.doComputeSize();
        return new Point(Math.max(640, point.x), point.y);
    }
}

