/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.Perspective;
import com.ibm.team.jface.internal.dashboard.views.SectionDescriptor;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class PerspectiveSectionSlot {
    private static final String MEMENTO_SECTION_SLOT = "sectionSlot";
    private static final String SECTION_HEIGHT = "height";
    private static final String SECTION_ID = "id";
    private static final String SECTION_IS_EXPANDED = "isExpanded";
    private static final String SECTION_PRIORITY = "priority";
    private static final String SECTION_GRAB = "grabExcessVerticalSpace";
    private int fHeight = -1;
    private boolean fIsExpanded = true;
    private boolean fGrabExcessVerticalSpace = false;
    private int fPriority = -1;
    private String fSectionId;

    public PerspectiveSectionSlot(String sectionId) {
        this.fSectionId = sectionId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Perspective)) {
            return false;
        }
        return this.fSectionId.equals(((Perspective)obj).getId());
    }

    int getHeight() {
        return this.fHeight;
    }

    int getPriority() {
        return this.fPriority;
    }

    public String getSectionId() {
        return this.fSectionId;
    }

    public int hashCode() {
        return this.fSectionId.hashCode();
    }

    boolean isExpanded() {
        return this.fIsExpanded;
    }

    boolean isGrabExcessVerticalSpace() {
        return this.fGrabExcessVerticalSpace;
    }

    void setGrabExcessVerticalSpace(boolean grabExcessVerticalSpace) {
        this.fGrabExcessVerticalSpace = grabExcessVerticalSpace;
    }

    void save(IMemento memento) {
        memento.putString(SECTION_ID, this.fSectionId);
        memento.putString(SECTION_IS_EXPANDED, String.valueOf(this.fIsExpanded));
        memento.putInteger(SECTION_HEIGHT, this.fHeight);
        memento.putInteger(SECTION_PRIORITY, this.fPriority);
        memento.putString(SECTION_GRAB, String.valueOf(this.fGrabExcessVerticalSpace));
    }

    void setExpanded(boolean isExpanded) {
        this.fIsExpanded = isExpanded;
    }

    void setHeight(int height) {
        this.fHeight = height;
    }

    void setPriority(int priority) {
        this.fPriority = priority;
    }

    void setSectionId(String sectionId) {
        this.fSectionId = sectionId;
    }

    static PerspectiveSectionSlot cloneFrom(PerspectiveSectionSlot sectionContainer, SectionDescriptor desc, Perspective perspective, String cloneSectionId) {
        PerspectiveSectionSlot clonedSectionContainer;
        if (sectionContainer != null) {
            XMLMemento sectionContainerMemento = XMLMemento.createWriteRoot((String)MEMENTO_SECTION_SLOT);
            sectionContainer.save((IMemento)sectionContainerMemento);
            clonedSectionContainer = PerspectiveSectionSlot.createFrom((IMemento)sectionContainerMemento);
        } else {
            clonedSectionContainer = PerspectiveSectionSlot.createFrom(desc.getConfigurationElement());
            clonedSectionContainer.setExpanded(true);
        }
        HashSet<Integer> priorities = new HashSet<Integer>();
        Iterator iterator = perspective.getAllContainedSectionSlots().iterator();
        while (iterator.hasNext()) {
            priorities.add(new Integer(((PerspectiveSectionSlot)iterator.next()).getPriority()));
        }
        int priority = clonedSectionContainer.getPriority();
        while (priorities.contains(new Integer(priority))) {
            --priority;
        }
        clonedSectionContainer.setPriority(priority);
        clonedSectionContainer.setSectionId(cloneSectionId);
        return clonedSectionContainer;
    }

    static PerspectiveSectionSlot createFrom(IConfigurationElement configElement) {
        String sectionId = configElement.getAttribute(SECTION_ID);
        boolean isExpanded = Boolean.valueOf(configElement.getAttribute(SECTION_IS_EXPANDED));
        boolean grabExcessVerticalSpace = Boolean.valueOf(configElement.getAttribute(SECTION_GRAB));
        int priority = configElement.getAttribute(SECTION_PRIORITY) != null ? Integer.valueOf(configElement.getAttribute(SECTION_PRIORITY)) : -1;
        PerspectiveSectionSlot secContainer = new PerspectiveSectionSlot(sectionId);
        secContainer.setExpanded(isExpanded);
        secContainer.setPriority(priority);
        secContainer.setGrabExcessVerticalSpace(grabExcessVerticalSpace);
        return secContainer;
    }

    static PerspectiveSectionSlot createFrom(IMemento memento) {
        String sectionId = memento.getString(SECTION_ID);
        boolean isExpanded = Boolean.valueOf(memento.getString(SECTION_IS_EXPANDED));
        boolean grabExcessVerticalSpace = Boolean.valueOf(memento.getString(SECTION_GRAB));
        int height = memento.getInteger(SECTION_HEIGHT);
        int priority = memento.getInteger(SECTION_PRIORITY);
        PerspectiveSectionSlot secContainer = new PerspectiveSectionSlot(sectionId);
        secContainer.setExpanded(isExpanded);
        secContainer.setHeight(height);
        secContainer.setPriority(priority);
        secContainer.setGrabExcessVerticalSpace(grabExcessVerticalSpace);
        return secContainer;
    }
}

