/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralLayout;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralView;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccordionTeamCentralLayout
extends TeamCentralLayout {
    private static final int HEADER_HEIGHT = 0;
    private static final int COMPUTED_HEIGHT = 1;
    private boolean[] fPreviousExpandedIndexes;

    AccordionTeamCentralLayout(TeamCentralView teamCentralView) {
        super(teamCentralView);
    }

    @Override
    Map<SectionPart, Rectangle> getLayout(Composite composite, int maximumWidth, int maximumHeight) {
        int[][] sectionSizes;
        int requiredHeight;
        SectionPart[] sections = AccordionTeamCentralLayout.getVisibleSections(composite);
        if (sections.length == 0) {
            return Collections.emptyMap();
        }
        int expandedCount = AccordionTeamCentralLayout.getExpandedSectionsCount(composite);
        if (expandedCount == 0) {
            int sectionToExpand = sections.length - 1;
            int singleExpandedSectionIndex = -1;
            if (this.fPreviousExpandedIndexes != null && this.fPreviousExpandedIndexes.length == sections.length) {
                int i = 0;
                while (i < this.fPreviousExpandedIndexes.length) {
                    if (this.fPreviousExpandedIndexes[i] && singleExpandedSectionIndex >= 0) {
                        singleExpandedSectionIndex = -1;
                        break;
                    }
                    if (this.fPreviousExpandedIndexes[i]) {
                        singleExpandedSectionIndex = i;
                    }
                    ++i;
                }
            }
            if (singleExpandedSectionIndex != -1) {
                if (singleExpandedSectionIndex + 1 < sections.length) {
                    sectionToExpand = singleExpandedSectionIndex + 1;
                } else if (singleExpandedSectionIndex - 1 >= 0) {
                    sectionToExpand = singleExpandedSectionIndex - 1;
                }
            }
            sections[sectionToExpand].setSectionExpanded(true, false, false);
            ++expandedCount;
        }
        if ((requiredHeight = this.computeRequiredHeight(sections, sectionSizes = this.computeSectionSizes(sections, maximumWidth))) > maximumHeight) {
            this.enforceMaxHeight(sections, sectionSizes, requiredHeight, maximumHeight, expandedCount);
        } else if (requiredHeight < maximumHeight) {
            this.letLastExpandedSectionFillRemainingHeight(sections, sectionSizes, maximumHeight - requiredHeight);
        }
        Map<SectionPart, Rectangle> newSectionBounds = this.fillSectionBounds(sections, sectionSizes, maximumWidth);
        this.fPreviousExpandedIndexes = this.getExpandedIndices(sections);
        return newSectionBounds;
    }

    private void letLastExpandedSectionFillRemainingHeight(SectionPart[] sections, int[][] sectionSizes, int remaningHeight) {
        int i = sections.length - 1;
        while (i >= 0) {
            if (sections[i].isExpanded()) {
                int[] nArray = sectionSizes[i];
                nArray[1] = nArray[1] + remaningHeight;
                break;
            }
            --i;
        }
    }

    private void enforceMaxHeight(SectionPart[] sections, int[][] sectionSizes, int requiredHeight, int maximumHeight, int expandedCount) {
        int totalHeightToAbsorb = requiredHeight - maximumHeight;
        int singleExpandedSectionIndex = -1;
        if (this.fPreviousExpandedIndexes != null && sections.length == this.fPreviousExpandedIndexes.length) {
            int singleExpansionToggleIndex = -1;
            int expansionToggles = 0;
            int i = 0;
            while (i < this.fPreviousExpandedIndexes.length) {
                if (this.fPreviousExpandedIndexes[i] != sections[i].isExpanded() && sections[i].isExpanded()) {
                    singleExpansionToggleIndex = i;
                    ++expansionToggles;
                }
                ++i;
            }
            singleExpandedSectionIndex = expansionToggles == 1 && singleExpansionToggleIndex >= 0 ? singleExpansionToggleIndex : -1;
        }
        int i = sections.length - 1;
        while (i >= 0) {
            SectionPart section = sections[i];
            if (section.isExpanded() && sectionSizes[i][1] > totalHeightToAbsorb + sectionSizes[i][0] && singleExpandedSectionIndex != i) {
                int absorbedHeight = this.absorbHeight(totalHeightToAbsorb, section, sectionSizes, i);
                totalHeightToAbsorb -= absorbedHeight;
                break;
            }
            --i;
        }
        if (totalHeightToAbsorb > 0) {
            int absorbPerSection = totalHeightToAbsorb / expandedCount;
            int i2 = 0;
            while (i2 < sections.length) {
                SectionPart section = sections[i2];
                int absorbedHeight = this.absorbHeight(absorbPerSection, section, sectionSizes, i2);
                totalHeightToAbsorb -= absorbedHeight;
                ++i2;
            }
        }
        if (totalHeightToAbsorb > 0) {
            i = sections.length - 1;
            while (i >= 0) {
                SectionPart section = sections[i];
                int absorbedHeight = this.absorbHeight(totalHeightToAbsorb, section, sectionSizes, i);
                totalHeightToAbsorb -= absorbedHeight;
                --i;
            }
        }
    }

    private int absorbHeight(int heightToAbsorb, SectionPart section, int[][] sectionSizes, int sectionIndex) {
        int collapsedHeight;
        int computedHeight;
        int maxHeightAbsorbtion;
        int heightAbsorbtion;
        int absorbedHeight = 0;
        if (section.isExpanded() && (heightAbsorbtion = Math.min(maxHeightAbsorbtion = (computedHeight = sectionSizes[sectionIndex][1]) - (collapsedHeight = sectionSizes[sectionIndex][0]), heightToAbsorb)) > 0) {
            int[] nArray = sectionSizes[sectionIndex];
            nArray[1] = nArray[1] - heightAbsorbtion;
            absorbedHeight = heightAbsorbtion;
        }
        return absorbedHeight;
    }

    private Map<SectionPart, Rectangle> fillSectionBounds(SectionPart[] sections, int[][] sectionSizes, int maxWidth) {
        HashMap<SectionPart, Rectangle> newSectionBounds = new HashMap<SectionPart, Rectangle>(sections.length);
        int y = 0;
        int i = 0;
        while (i < sections.length) {
            SectionPart section = sections[i];
            int height = section.isExpanded() ? sectionSizes[i][1] : sectionSizes[i][0];
            newSectionBounds.put(section, new Rectangle(0, y, maxWidth, height));
            y += height + 0;
            ++i;
        }
        return newSectionBounds;
    }

    private int computeRequiredHeight(SectionPart[] sections, int[][] sizes) {
        int requiredHeight = 0;
        int i = 0;
        while (i < sections.length) {
            SectionPart section = sections[i];
            requiredHeight = section.isExpanded() ? (requiredHeight += sizes[i][1]) : (requiredHeight += sizes[i][0]);
            requiredHeight += 0;
            ++i;
        }
        return requiredHeight += 0;
    }

    private int[][] computeSectionSizes(SectionPart[] sections, int maximumWidth) {
        int[][] sizes = new int[sections.length][4];
        int i = 0;
        while (i < sections.length) {
            SectionPart section = sections[i];
            sizes[i][0] = section.computeHeaderHeight();
            sizes[i][1] = section.computeHeight(maximumWidth, -1);
            ++i;
        }
        return sizes;
    }
}

