/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointManager;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ItemViewAdvisorManager;
import com.ibm.team.jface.internal.alerts.InfoPopManager;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JFacePlugin
extends AbstractUIPlugin {
    private static final List<String> TEST_APPLICATIONS = Arrays.asList("org.eclipse.test.uitestapplication", "org.eclipse.test.coretestapplication", "org.eclipse.pde.junit.runtime.uitestapplication", "org.eclipse.pde.junit.runtime.coretestapplication", "org.eclipse.pde.junit.runtime.legacyUItestapplication", "org.eclipse.pde.junit.runtime.legacyCoretestapplication");
    public static final String PLUGIN_ID = "com.ibm.team.jface";
    private static JFacePlugin fgPlugin;
    private ExtensionPointManager fExtensionPointMgr;
    private ImageRegistry fCategoryToImage;

    public JFacePlugin() {
        fgPlugin = this;
    }

    public ImageDescriptor getItemImage(String category) {
        ImageDescriptor ret;
        if (this.fCategoryToImage == null) {
            this.fCategoryToImage = new ImageRegistry();
        }
        if ((ret = this.fCategoryToImage.getDescriptor(category)) == null && (ret = (ImageDescriptor)ItemViewAdvisorManager.getConfigurer().getItemImages().get(category)) != null) {
            this.fCategoryToImage.put(category, ret);
        }
        return ret;
    }

    public static JFacePlugin getDefault() {
        return fgPlugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        FeedManager.getDefault();
        this.fExtensionPointMgr = new ExtensionPointManager(this.getBundle());
        if (!this.isPluginTest()) {
            InfoPopManager.getDefault();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.fExtensionPointMgr.dispose();
        fgPlugin = null;
        if (!this.isPluginTest()) {
            InfoPopManager.stopManager();
        }
    }

    private boolean isPluginTest() {
        String property = System.getProperty("eclipse.commands");
        if (property == null) {
            return false;
        }
        List<String> commands = Arrays.asList(property.split("\n"));
        int index = commands.indexOf("-application");
        if (index < 0 || index + 1 >= commands.size()) {
            return false;
        }
        return TEST_APPLICATIONS.contains(commands.get(index + 1));
    }

    static ImageDescriptor getImageDescriptor(String imageFilePath) {
        ImageDescriptor id = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imageFilePath);
        JazzResources.registerPath(id, PLUGIN_ID, imageFilePath);
        return id;
    }

    public void log(String message, Throwable exception) {
        FoundationLog.log((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public void logWarning(String message, Throwable exception) {
        FoundationLog.log((IStatus)new Status(2, PLUGIN_ID, 0, message, exception));
    }

    public void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public static void log(Throwable t) {
        FoundationLog.log((IStatus)new Status(4, PLUGIN_ID, 0, t.getMessage(), t));
    }

    public ExtensionPointManager getExtensionPointManager() {
        return this.fExtensionPointMgr;
    }
}

