/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class NoScrollbarsTable
extends Composite {
    private static final boolean fgIsLinux = "gtk".equals(SWT.getPlatform());
    private static final int LINUX_SCROLLBAR_SIZE_CORRECTION = 3;
    private Table fTable;

    public NoScrollbarsTable(Composite parent, int tableStyle) {
        this(parent, tableStyle, true);
    }

    public Table getTable() {
        return this.fTable;
    }

    public NoScrollbarsTable(Composite parent, int tableStyle, boolean addTableColumn) {
        super(parent, 0);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.fTable = new Table((Composite)this, tableStyle);
        if (addTableColumn) {
            new TableColumn(this.fTable, 0);
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                NoScrollbarsTable.this.showVerticalScrollBarsOnce();
            }
        });
    }

    public Point computeSize(int wHint, int hHint) {
        Point size = super.computeSize(wHint, hHint);
        if (fgIsLinux) {
            size.x += 3;
            size.y += 3;
        }
        return size;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (fgIsLinux) {
            size.x += 3;
            size.y += 3;
        }
        return size;
    }

    public void showVerticalScrollBarsOnce() {
        this.showVerticalScrollBarsOnce(this.fTable.getVerticalBar().getSize().x);
    }

    private void showVerticalScrollBarsOnce(int barWidth) {
        Rectangle rect = this.getClientArea();
        int scrollbarHeight = this.fTable.getHorizontalBar().getSize().y;
        if (fgIsLinux) {
            barWidth += 3;
            scrollbarHeight += 3;
        }
        Rectangle trimmedTableBounds = this.fTable.computeTrim(0, 0, rect.width - barWidth, rect.height - scrollbarHeight);
        this.fTable.setBounds(trimmedTableBounds);
        if (this.fTable.getColumnCount() > 0) {
            this.fTable.getColumn(0).setWidth(rect.width - barWidth);
        }
    }
}

