/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GradientUtilities {
    public static void setVerticalGradient(Composite control, Color start, Color end) {
        GradientUtilities.doSetVerticalGradient(control, start, end, null);
    }

    public static void setVerticalGradientWithBottomLine(Composite control, Color start, Color end, Color bottomColor) {
        GradientUtilities.doSetVerticalGradient(control, start, end, bottomColor);
    }

    private static void doSetVerticalGradient(final Composite control, final Color start, final Color end, final Color bottomLineColor) {
        control.setBackgroundMode(1);
        control.setBackground(start);
        GradientUtilities.setBackgroundImage(control, start, end, bottomLineColor);
        control.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GradientUtilities.setBackgroundImage(control, start, end, bottomLineColor);
            }
        });
        control.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                Image backgroundImage = control.getBackgroundImage();
                if (backgroundImage != null && !backgroundImage.isDisposed()) {
                    backgroundImage.dispose();
                }
            }
        });
    }

    private static void setBackgroundImage(Composite control, Color start, Color end, Color bottomLineColor) {
        Rectangle rect = control.getClientArea();
        if (!rect.isEmpty()) {
            int height = Math.max(1, rect.height);
            Image newImage = new Image((Device)control.getDisplay(), 1, height);
            GC gc = new GC((Drawable)newImage);
            gc.setForeground(start);
            gc.setBackground(end);
            gc.fillGradientRectangle(rect.x, rect.y, 1, height, true);
            if (bottomLineColor != null) {
                gc.setForeground(bottomLineColor);
                gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
            }
            gc.dispose();
            Image oldImage = control.getBackgroundImage();
            control.setBackgroundImage(newImage);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
    }
}

