/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorUtils {
    private static final RGB[] LIST_SELECTION = new RGB[8];
    public static final int THEME_IX_GTK = 6;
    public static final int THEME_IX_MOTIF = 7;
    public static final int THEME_OSX_AQUA = 4;
    public static final int THEME_OSX_GRA = 5;
    public static final int THEME_WN_CLSC = 3;
    public static final int THEME_XP_BLUE = 0;
    public static final int THEME_XP_OLIV = 2;
    public static final int THEME_XP_SILV = 1;
    private static final RGB[] WIDGET_BACKGROUND = new RGB[8];

    static {
        ColorUtils.LIST_SELECTION[0] = new RGB(49, 106, 197);
        ColorUtils.WIDGET_BACKGROUND[0] = new RGB(236, 233, 216);
        ColorUtils.LIST_SELECTION[1] = new RGB(178, 180, 191);
        ColorUtils.WIDGET_BACKGROUND[1] = new RGB(224, 223, 227);
        ColorUtils.LIST_SELECTION[2] = new RGB(147, 160, 112);
        ColorUtils.WIDGET_BACKGROUND[2] = new RGB(236, 233, 216);
        ColorUtils.LIST_SELECTION[3] = new RGB(10, 36, 106);
        ColorUtils.WIDGET_BACKGROUND[3] = new RGB(212, 208, 200);
        ColorUtils.LIST_SELECTION[4] = new RGB(181, 213, 255);
        ColorUtils.WIDGET_BACKGROUND[4] = new RGB(240, 240, 240);
        ColorUtils.LIST_SELECTION[5] = new RGB(198, 198, 198);
        ColorUtils.WIDGET_BACKGROUND[5] = new RGB(255, 255, 255);
        ColorUtils.LIST_SELECTION[6] = new RGB(138, 138, 160);
        ColorUtils.WIDGET_BACKGROUND[6] = new RGB(220, 218, 213);
        ColorUtils.LIST_SELECTION[7] = new RGB(0, 0, 0);
        ColorUtils.WIDGET_BACKGROUND[7] = new RGB(196, 196, 196);
    }

    public static RGB addColor(RGB color, float percentage) {
        return ColorUtils.addColor(color, new RGB(255, 255, 255), percentage);
    }

    public static RGB addColor(RGB color, RGB base, float percentage) {
        float abs = 100.0f;
        float redDif = (float)(base.red - color.red) * (percentage / abs);
        float greenDif = (float)(base.green - color.green) * (percentage / abs);
        float blueDif = (float)(base.blue - color.blue) * (percentage / abs);
        return new RGB((int)((float)color.red + redDif), (int)((float)color.green + greenDif), (int)((float)color.blue + blueDif));
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = ColorUtils.blend(c1.red, c2.red, ratio);
        int g = ColorUtils.blend(c1.green, c2.green, ratio);
        int b = ColorUtils.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    public static int getCurrentTheme() {
        RGB list_selection = Display.getDefault().getSystemColor(26).getRGB();
        RGB widget_background = Display.getDefault().getSystemColor(22).getRGB();
        int a = 0;
        while (a < LIST_SELECTION.length) {
            if (list_selection.equals((Object)LIST_SELECTION[a]) && widget_background.equals((Object)WIDGET_BACKGROUND[a])) {
                return a;
            }
            ++a;
        }
        return 0;
    }
}

