/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class SourceViewerPane {
    private IWorkbenchPart fPart;
    private List fSourceViewers = new ArrayList();
    private StyledText fLastActiveTextWidget = null;
    private FocusListener fFocusListener = new FocusListener();

    public SourceViewerPane(IWorkbenchPart part) {
        this.fPart = part;
    }

    public ISourceViewer getLastActiveSourceViewer() {
        if (this.fLastActiveTextWidget == null) {
            return null;
        }
        return this.getSourceViewer((Control)this.fLastActiveTextWidget);
    }

    public void setLastActiveSourceViewer(ISourceViewer viewer) {
        this.fLastActiveTextWidget = viewer.getTextWidget();
    }

    public ISourceViewer getActiveSourceViewer() {
        Control focus = this.getFocusControl();
        while (focus != null && !focus.isDisposed()) {
            if (focus instanceof StyledText) break;
            focus = focus.getParent();
        }
        if (!(focus instanceof StyledText)) {
            return null;
        }
        return this.getSourceViewer(focus);
    }

    public ISourceViewer getSourceViewer(Control control) {
        for (ISourceViewer viewer : this.fSourceViewers) {
            if (viewer.getTextWidget() != control && (!(viewer instanceof Viewer) || ((Viewer)viewer).getControl() != control)) continue;
            return viewer;
        }
        return null;
    }

    private Control getFocusControl() {
        Shell shell = this.fPart.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            Display display = shell.getDisplay();
            return display.getFocusControl();
        }
        return null;
    }

    public ISourceViewer getFirstVisibleSourceViewer() {
        List viewers = this.fSourceViewers;
        for (ISourceViewer viewer : viewers) {
            if (!viewer.getTextWidget().isVisible()) continue;
            return viewer;
        }
        return null;
    }

    public ISourceViewer getNextVisibleSourceViewer(ISourceViewer viewer) {
        List viewers = this.fSourceViewers;
        int start = viewers.size();
        while (start > 0) {
            if (viewers.get(start - 1) == viewer) break;
            --start;
        }
        int i = 0;
        while (i < viewers.size()) {
            ISourceViewer next = (ISourceViewer)viewers.get((i + start) % viewers.size());
            if (next.getTextWidget().isVisible()) {
                return next;
            }
            ++i;
        }
        return null;
    }

    public void addSourceViewer(ISourceViewer viewer) {
        this.fSourceViewers.add(viewer);
        viewer.getTextWidget().addFocusListener((org.eclipse.swt.events.FocusListener)this.fFocusListener);
    }

    public void removeSourceViewer(ISourceViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.removeFocusListener((org.eclipse.swt.events.FocusListener)this.fFocusListener);
        }
        this.fSourceViewers.remove(viewer);
    }

    public ISourceViewer[] getSourceViewers() {
        return this.fSourceViewers.toArray(new ISourceViewer[this.fSourceViewers.size()]);
    }

    public void dispose() {
        Iterator iter = new ArrayList(this.fSourceViewers).iterator();
        while (iter.hasNext()) {
            this.removeSourceViewer((ISourceViewer)iter.next());
        }
    }

    private class FocusListener
    extends FocusAdapter {
        private FocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (e.widget instanceof StyledText) {
                SourceViewerPane.this.fLastActiveTextWidget = (StyledText)e.widget;
            }
        }
    }
}

