/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.HandlerUpdater;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.Messages;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.TextOperationAction;
import com.ibm.team.foundation.rcp.core.internal.text.SyntheticDelimiterPosition;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

public class ClipboardOperationAction
extends TextOperationAction {
    public ClipboardOperationAction(String text, String cmdId, ImageDescriptor image, int operationCode) {
        super(text, cmdId, image, operationCode);
        this.initialize(operationCode);
    }

    public ClipboardOperationAction(String text, String cmdId, ImageDescriptor image, IWorkbenchPart part, int operationCode) {
        super(text, cmdId, image, part, operationCode);
        this.initialize(operationCode);
    }

    public ClipboardOperationAction(String text, String cmdId, ImageDescriptor image, ISourceViewer sourceViewer, int operationCode) {
        super(text, cmdId, image, sourceViewer, operationCode);
        this.initialize(operationCode);
    }

    private void initialize(int operationCode) {
        if (operationCode == 3) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        } else if (operationCode == 4) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        } else if (operationCode == 5) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid operation code");
        }
        this.update();
    }

    private boolean isReadOnlyOperation() {
        return this.getOperationCode() == 4;
    }

    public void run() {
        ISourceViewer viewer = this.getSourceViewer();
        if (this.getOperationCode() == -1 || viewer == null) {
            return;
        }
        if (!viewer.getTextOperationTarget().canDoOperation(this.getOperationCode())) {
            return;
        }
        if (!this.isReadOnlyOperation() && !this.validatePartInputState()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ClipboardOperationAction.this.internalDoOperation();
            }
        });
    }

    private Shell getShell() {
        IWorkbenchPartSite site;
        Shell shell;
        IWorkbenchPart part = this.getPart();
        if (part != null && (shell = (site = part.getSite()).getShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return null;
    }

    protected final void internalDoOperation() {
        if (this.getOperationCode() == 5) {
            this.doPaste();
        } else {
            this.doCutCopy();
        }
    }

    public void update() {
        if (!this.isReadOnlyOperation() && !this.canModifyViewer()) {
            this.setEnabled(false);
            return;
        }
        super.update();
    }

    private void doCutCopy() {
        ISourceViewer viewer = this.getSourceViewer();
        ISelection selection = viewer.getSelectionProvider().getSelection();
        XMLString html = null;
        if (viewer.getDocument() instanceof IStyledDocument && selection instanceof ITextSelection && !selection.isEmpty()) {
            try {
                ITextSelection textSelection = (ITextSelection)selection;
                html = ((IStyledDocument)viewer.getDocument()).getHTML(textSelection.getOffset(), textSelection.getLength());
            }
            catch (BadLocationException x) {
                throw new RuntimeException(x);
            }
        }
        viewer.getTextOperationTarget().doOperation(this.getOperationCode());
        if (html != null && html.getXMLText().length() > 0) {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            try {
                Object textData = clipboard.getContents((Transfer)TextTransfer.getInstance());
                Object rtfData = clipboard.getContents((Transfer)RTFTransfer.getInstance());
                ArrayList<Object> datas = new ArrayList<Object>(3);
                ArrayList<Object> transfers = new ArrayList<Object>(3);
                if (textData != null) {
                    if (viewer.getDocument().containsPositionCategory(SyntheticDelimiterPosition.SYNTHETIC_DELIMITER_CATEGORY)) {
                        datas.add(html.getPlainText());
                    } else {
                        datas.add(textData);
                    }
                    transfers.add(TextTransfer.getInstance());
                }
                if (rtfData != null) {
                    datas.add(rtfData);
                    transfers.add(RTFTransfer.getInstance());
                }
                if (datas.isEmpty()) {
                    return;
                }
                datas.add(Utils.escapeForHTMLTransfer((String)html.getXMLText()));
                transfers.add(HTMLTransfer.getInstance());
                Transfer[] dataTypes = transfers.toArray(new Transfer[transfers.size()]);
                Object[] data = datas.toArray();
                this.setClipboardContents(clipboard, data, dataTypes);
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private void setClipboardContents(Clipboard clipboard, Object[] datas, Transfer[] transfers) {
        try {
            clipboard.setContents(datas, transfers);
            return;
        }
        catch (SWTError e) {
            if (e.code != 2002) {
                throw e;
            }
            return;
        }
    }

    private void doPaste() {
        ISourceViewer viewer = this.getSourceViewer();
        IDocument document = viewer.getDocument();
        if (!(document instanceof IStyledDocument)) {
            viewer.getTextOperationTarget().doOperation(this.getOperationCode());
            return;
        }
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        Clipboard clipboard = new Clipboard(this.getDisplay());
        try {
            try {
                String html = (String)clipboard.getContents((Transfer)HTMLTransfer.getInstance());
                if (html != null && !html.contains("<table")) {
                    int length;
                    XMLString content = XMLString.createFromXMLText((String)html);
                    if ((viewer.getTextWidget().getStyle() & 4) != 0) {
                        StyledDocument tmp = new StyledDocument();
                        tmp.setHTML(content);
                        while (tmp.getNumberOfLines() > 1) {
                            length = tmp.getLineDelimiter(0).length();
                            int offset = tmp.getLineLength(0) - length;
                            tmp.replace(offset, length, "");
                        }
                        content = tmp.getHTML();
                    }
                    int offset = selection.getOffset();
                    length = ((IStyledDocument)document).replaceHTML(offset, selection.getLength(), content);
                    viewer.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + length, 0));
                } else {
                    viewer.getTextOperationTarget().doOperation(this.getOperationCode());
                }
            }
            catch (BadLocationException x) {
                throw new RuntimeException(x);
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    public static void installCut(SourceViewer sourceViewer, HandlerUpdater handlerUpdater) {
        ClipboardOperationAction action = new ClipboardOperationAction(Messages.ClipboardOperationAction_CUT, "org.eclipse.ui.edit.cut", null, (ISourceViewer)sourceViewer, 3);
        handlerUpdater.addAction((IAction)action);
        handlerUpdater.updateInputChanged(action);
        handlerUpdater.updateSelectionChanged(action);
    }

    public static void installCopy(SourceViewer sourceViewer, HandlerUpdater handlerUpdater) {
        ClipboardOperationAction action = new ClipboardOperationAction(Messages.ClipboardOperationAction_COPY, "org.eclipse.ui.edit.copy", null, (ISourceViewer)sourceViewer, 4);
        handlerUpdater.addAction((IAction)action);
        handlerUpdater.updateInputChanged(action);
        handlerUpdater.updateSelectionChanged(action);
    }

    public static void installPaste(SourceViewer sourceViewer, HandlerUpdater handlerUpdater) {
        ClipboardOperationAction action = new ClipboardOperationAction(Messages.ClipboardOperationAction_PASTE, "org.eclipse.ui.edit.paste", null, (ISourceViewer)sourceViewer, 5);
        handlerUpdater.addAction((IAction)action);
        handlerUpdater.updateInputChanged(action);
    }
}

