/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;

public class TeamJFaceURIUtils {
    public static URIReference[] createURIReferences(Object[] elements, ITeamRepository repository) {
        ArrayList<URIReference> result = new ArrayList<URIReference>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IReference && ((IReference)element).isURIReference()) {
                URIReference uriRef = TeamJFaceURIUtils.toURIReference((IURIReference)element);
                if (uriRef != null) {
                    result.add(uriRef);
                }
            } else {
                URIReference link = Hyperlinks.createHyperlink((Object)element);
                if (link != null) {
                    result.add(link);
                } else {
                    IAuditableHandle handle;
                    if (element instanceof IAuditableHandle) {
                        handle = (IAuditableHandle)element;
                    } else {
                        IItemHandle itemHandle;
                        handle = (IAuditableHandle)Platform.getAdapterManager().getAdapter(element, IAuditableHandle.class);
                        if (handle == null && element instanceof IReference && ((IReference)element).isItemReference() && (itemHandle = ((IItemReference)element).getReferencedItem()) instanceof IAuditableHandle) {
                            handle = (IAuditableHandle)itemHandle;
                        }
                    }
                    String label = null;
                    URI uri = null;
                    if (handle != null) {
                        IDomainAdapter domainAdapter = DomainAdapterUtils.getDomainAdapter((Object)handle);
                        if (domainAdapter == null && element instanceof IReference) {
                            label = ((IReference)element).getComment();
                        }
                        uri = element instanceof IReference ? TeamJFaceURIUtils.createURI((IReference)element) : TeamJFaceURIUtils.createURI((IItemHandle)handle);
                        if (domainAdapter != null) {
                            label = domainAdapter.generateTitle((Object)handle);
                        }
                    } else if (element instanceof IReference && ((IReference)element).isURIReference()) {
                        IURIReference uriReference = (IURIReference)element;
                        label = uriReference.getComment();
                        uri = uriReference.getURI();
                        if (uri != null && !uri.isAbsolute() && repository != null) {
                            URI base = Location.itemLocation((IItemHandle)uriReference.getLink(), (String)repository.getRepositoryURI()).toAbsoluteUri();
                            uri = Hyperlinks.resolveURI((URI)uri, (URI)base);
                        }
                    }
                    if (label != null && !"".equals(label) && uri != null) {
                        result.add(new URIReference(label, label, uri));
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new URIReference[result.size()]);
    }

    private static URIReference toURIReference(IURIReference reference) {
        String label = reference.getComment();
        URI uri = reference.getURI();
        if (label != null && label.length() > 0 && uri != null && uri.isAbsolute()) {
            return new URIReference(label, label, uri);
        }
        return null;
    }

    public static URI createURI(IReference reference) {
        if (reference.isItemReference()) {
            return TeamJFaceURIUtils.createURI(((IItemReference)reference).getReferencedItem());
        }
        if (reference.isURIReference()) {
            return ((IURIReference)reference).getURI();
        }
        return null;
    }

    private static URI createURI(IItemHandle handle) {
        ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
        Location location = Location.itemLocation((IItemHandle)handle, (String)teamRepository.getRepositoryURI(), null, null);
        return location.toAbsoluteUri();
    }
}

