/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.AnnotationHover;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ConfigurableRepairer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.EditorSupport2;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.HyperlinkPositionDetector;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.PartitionDamager;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerSupport;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import java.util.ArrayList;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;

public class StyledViewerConfiguration
extends SourceViewerConfiguration {
    private static final RGB DEFAULT_COLOR = new RGB(0, 0, 0);
    private static final RGB HYPERLINK_COLOR = new RGB(0, 0, 255);
    private ResourceManager fResourceManager;
    private ContextProvider fContextProvider;
    private boolean fEnableSpellChecking;
    private String[] fReferencePositionCategories = new String[]{"__referencePosition", "__temporaryReferencePosition"};

    public StyledViewerConfiguration(ResourceManager resourceManager, ContextProvider contextProvider, boolean enableSpellChecking) {
        this.fResourceManager = resourceManager;
        this.fContextProvider = contextProvider;
        this.fEnableSpellChecking = enableSpellChecking;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        reconciler.setDamager((IPresentationDamager)new PartitionDamager(), "__dftl_partition_content_type");
        TextAttribute defaultTextAttribute = new TextAttribute(this.fResourceManager.createColor(DEFAULT_COLOR), null, 0);
        TextAttribute referenceTextAttribute = new TextAttribute(this.fResourceManager.createColor(HYPERLINK_COLOR), null, 0x40000000);
        reconciler.setRepairer((IPresentationRepairer)new ConfigurableRepairer(this.fResourceManager, defaultTextAttribute, "__stylePosition", this.fReferencePositionCategories, referenceTextAttribute), "__dftl_partition_content_type");
        return reconciler;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new NullHyperlinkPresenter();
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{new HyperlinkPositionDetector(this.fReferencePositionCategories, this.fContextProvider)};
    }

    public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
        return 0;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover(this.fContextProvider, AnnotationHover.VERTICAL_RULER_HOVER);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover(this.fContextProvider, AnnotationHover.OVERVIEW_RULER_HOVER);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (!this.fEnableSpellChecking) {
            return null;
        }
        SpellingReconcileStrategy strategy = new SpellingReconcileStrategy(sourceViewer, EditorsUI.getSpellingService());
        StyledViewerReconciler reconciler = new StyledViewerReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setIsIncrementalReconciler(false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)new InternalSpellingCorrectionProcessor());
        assistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        });
        assistant.setProposalSelectorBackground(sourceViewer.getTextWidget().getDisplay().getSystemColor(1));
        assistant.setProposalSelectorForeground(sourceViewer.getTextWidget().getDisplay().getSystemColor(2));
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new InternalTextHover();
    }

    private class InternalInformationControlCreator
    implements IInformationControlCreator {
        private InternalInformationControlCreator() {
        }

        public IInformationControl createInformationControl(Shell parent) {
            StandardContextProvider provider = new StandardContextProvider(null, StyledViewerConfiguration.this.fContextProvider.getContext());
            provider.setUIContext((Object)parent);
            return new EditorSupport2(parent, (ContextProvider)provider, true, true);
        }
    }

    private static class InternalSpellingCorrectionProcessor
    implements IQuickAssistProcessor {
        private IQuickAssistProcessor fSpellingCorrectionProcessor = new SpellingCorrectionProcessor();

        private InternalSpellingCorrectionProcessor() {
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            ICompletionProposal[] orignialProposals;
            if (!EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
                return new ICompletionProposal[0];
            }
            ArrayList<InternalSpellingCorrectionProposal> proposals = new ArrayList<InternalSpellingCorrectionProposal>();
            ICompletionProposal[] iCompletionProposalArray = orignialProposals = this.fSpellingCorrectionProcessor.computeQuickAssistProposals(invocationContext);
            int n = orignialProposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal originalProposal = iCompletionProposalArray[n2];
                proposals.add(new InternalSpellingCorrectionProposal(originalProposal, invocationContext));
                ++n2;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            return this.fSpellingCorrectionProcessor.canAssist(invocationContext);
        }

        public boolean canFix(Annotation annotation) {
            return this.fSpellingCorrectionProcessor.canFix(annotation);
        }

        public String getErrorMessage() {
            return this.fSpellingCorrectionProcessor.getErrorMessage();
        }

        private static class InternalSpellingCorrectionProposal
        implements ICompletionProposal,
        IDocumentListener {
            private ICompletionProposal fSpellingCompletionProposal;
            private IQuickAssistInvocationContext fInvocationContext;
            private boolean fChanged;

            public InternalSpellingCorrectionProposal(ICompletionProposal spellingCompletionProposal, IQuickAssistInvocationContext invocationContext) {
                this.fSpellingCompletionProposal = spellingCompletionProposal;
                this.fInvocationContext = invocationContext;
            }

            public void apply(IDocument document) {
                IReconciler reconciler;
                ISourceViewer sourceViewer;
                try {
                    this.fChanged = false;
                    document.addDocumentListener((IDocumentListener)this);
                    this.fSpellingCompletionProposal.apply(document);
                }
                finally {
                    document.removeDocumentListener((IDocumentListener)this);
                }
                if (!this.fChanged && (sourceViewer = this.fInvocationContext.getSourceViewer()) instanceof StyledTextViewerSupport.IEmbeddedViewer && (reconciler = ((StyledTextViewerSupport.IEmbeddedViewer)sourceViewer).getReconciler()) instanceof StyledViewerReconciler) {
                    ((StyledViewerReconciler)reconciler).forceReconciling();
                }
            }

            public String getAdditionalProposalInfo() {
                return this.fSpellingCompletionProposal.getAdditionalProposalInfo();
            }

            public IContextInformation getContextInformation() {
                return this.fSpellingCompletionProposal.getContextInformation();
            }

            public String getDisplayString() {
                return this.fSpellingCompletionProposal.getDisplayString();
            }

            public Image getImage() {
                return this.fSpellingCompletionProposal.getImage();
            }

            public Point getSelection(IDocument document) {
                return this.fSpellingCompletionProposal.getSelection(document);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                this.fChanged = true;
            }
        }
    }

    private class InternalTextHover
    implements ITextHover,
    ITextHoverExtension {
        private InternalTextHover() {
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            Region hoverRegion = new Region(offset, 1);
            IHyperlinkDetector[] hds = StyledViewerConfiguration.this.getHyperlinkDetectors((ISourceViewer)textViewer);
            int i = 0;
            while (i < hds.length) {
                HyperlinkPositionDetector.Hyperlink link = this.getLink(textViewer, hds[i], (IRegion)hoverRegion);
                if (link != null) {
                    return link.getHyperlinkRegion();
                }
                ++i;
            }
            return new Region(offset, 1);
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
            IHyperlinkDetector[] hds = StyledViewerConfiguration.this.getHyperlinkDetectors((ISourceViewer)textViewer);
            int i = 0;
            while (i < hds.length) {
                HyperlinkPositionDetector.Hyperlink hl = this.getLink(textViewer, hds[i], hoverRegion);
                if (hl != null) {
                    return hl.getReference().toString();
                }
                ++i;
            }
            return null;
        }

        public IInformationControlCreator getHoverControlCreator() {
            return new InternalInformationControlCreator();
        }

        private HyperlinkPositionDetector.Hyperlink getLink(ITextViewer textViewer, IHyperlinkDetector detector, IRegion region) {
            IHyperlink[] hyperlinks = detector.detectHyperlinks(textViewer, region, false);
            if (hyperlinks != null) {
                int i = 0;
                while (i < hyperlinks.length) {
                    IHyperlink hyperlink = hyperlinks[i];
                    if (hyperlink instanceof HyperlinkPositionDetector.Hyperlink) {
                        return (HyperlinkPositionDetector.Hyperlink)hyperlink;
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    private static class NullHyperlinkPresenter
    implements IHyperlinkPresenter {
        private ITextViewer fTextViewer;
        private Cursor fCursor;

        private NullHyperlinkPresenter() {
        }

        public boolean canShowMultipleHyperlinks() {
            return false;
        }

        public void showHyperlinks(IHyperlink[] hyperlinks) throws IllegalArgumentException {
            this.activateCursor();
        }

        public void hideHyperlinks() {
            this.resetCursor();
        }

        public void install(ITextViewer textViewer) {
            this.fTextViewer = textViewer;
        }

        public void uninstall() {
            this.fTextViewer = null;
        }

        private void activateCursor() {
            StyledText text = this.fTextViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            Display display = text.getDisplay();
            if (this.fCursor == null) {
                this.fCursor = new Cursor((Device)display, 21);
            }
            text.setCursor(this.fCursor);
        }

        private void resetCursor() {
            StyledText text = this.fTextViewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                text.setCursor(null);
            }
            if (this.fCursor != null) {
                this.fCursor.dispose();
                this.fCursor = null;
            }
        }
    }

    private static class StyledViewerReconciler
    extends MonoReconciler {
        public StyledViewerReconciler(IReconcilingStrategy strategy, boolean isIncremental) {
            super(strategy, isIncremental);
        }

        public void forceReconciling() {
            super.forceReconciling();
        }
    }
}

