/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemQueryPageIterator<T> {
    private final IQueryService fQueryService;
    private IItemQueryPage fCurrentPage;
    private List<T> fHandles;

    public ItemQueryPageIterator(IQueryService queryService, IItemQuery itemQuery, Object[] parameters) throws TeamRepositoryException {
        this(queryService, itemQuery, parameters, 512);
    }

    public ItemQueryPageIterator(IQueryService queryService, IItemQuery itemQuery, Object[] parameters, int pageSize) throws TeamRepositoryException {
        Assert.isTrue((pageSize > 0 ? 1 : 0) != 0);
        this.fQueryService = queryService;
        this.fCurrentPage = this.fQueryService.queryItems(itemQuery, parameters, pageSize);
        this.fHandles = this.fCurrentPage.getItemHandles();
    }

    public boolean hasNext() throws TeamRepositoryException {
        return this.fHandles != null && !this.fHandles.isEmpty() || this.fetchNextPage();
    }

    public List<T> next() throws TeamRepositoryException, NoSuchElementException {
        if (this.fCurrentPage == null) {
            throw new NoSuchElementException();
        }
        List<T> result = this.fHandles;
        this.fHandles = null;
        return result;
    }

    private boolean fetchNextPage() throws TeamRepositoryException {
        if (this.fCurrentPage == null) {
            return false;
        }
        if (this.fCurrentPage.hasNext()) {
            this.fCurrentPage = (IItemQueryPage)this.fQueryService.fetchPage(this.fCurrentPage.getToken(), this.fCurrentPage.getNextStartPosition(), this.fCurrentPage.getSize());
            this.fHandles = this.fCurrentPage.getItemHandles();
            if (!this.fHandles.isEmpty()) {
                return true;
            }
        }
        this.fCurrentPage = null;
        this.fHandles = null;
        return false;
    }
}

