/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemCollections {
    private static final ItemList EMPTY_LIST = ItemCollections.unmodifiableItemList(new ItemArrayList());
    private static final ItemMap EMPTY_MAP = ItemCollections.unmodifiableItemMap(new ItemHashMap());

    private ItemCollections() {
    }

    public static <T> ItemCollection<T> unmodifiableItemCollection(ItemCollection<? extends T> c) {
        return new UnmodifiableItemCollection<T>(c);
    }

    public static <T> ItemSet<T> unmodifiableItemSet(ItemSet<? extends T> c) {
        return new UnmodifiableItemSet<T>(c);
    }

    public static <T> ItemList<T> unmodifiableItemList(ItemList<? extends T> c) {
        return new UnmodifiableItemList<T>(c);
    }

    public static <K extends IItemHandle, V> ItemMap<K, V> unmodifiableItemMap(ItemMap<? extends K, ? extends V> c) {
        return new UnmodifiableItemMap<K, V>(c);
    }

    public static final <T> ItemList<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <T> ItemCollection<T> singleton(T element) {
        return new SingletonItemCollection<T>(element);
    }

    public static final <K extends IItemHandle, V> ItemMap<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> void sort(ItemList<T> list, Comparator<? super T> c) {
        Object[] items = list.toArray();
        Arrays.sort(items, c);
        ListIterator<T> iter = list.listIterator();
        int i = 0;
        while (i < items.length) {
            iter.next();
            iter.set(items[i]);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonItemCollection<E>
    implements ItemCollection<E> {
        private final E fElement;

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        SingletonItemCollection(E element) {
            this.fElement = element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return SingletonItemCollection.eq(this.fElement, o);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.fElement};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return Collections.singleton(this.fElement).toArray(a);
        }

        public String toString() {
            return "[" + this.fElement + "]";
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonItemCollection.this.fElement;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(ItemCollection<?> coll) {
            return coll.size() == 1 && coll.contains(this.fElement);
        }

        @Override
        public boolean addAll(ItemCollection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ItemCollection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ItemCollection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CMode getMode() {
            return CMode.CURRENT;
        }

        @Override
        public Collection<E> toCollection() {
            return Collections.singleton(this.fElement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableItemCollection<E>
    implements ItemCollection<E> {
        ItemCollection<? extends E> fDelegate;

        UnmodifiableItemCollection(ItemCollection<? extends E> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.fDelegate = c;
        }

        @Override
        public int size() {
            return this.fDelegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.fDelegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.fDelegate.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.fDelegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.fDelegate.toArray(a);
        }

        public String toString() {
            return this.fDelegate.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                Iterator<? extends E> i;
                {
                    this.i = UnmodifiableItemCollection.this.fDelegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(ItemCollection<?> coll) {
            return this.fDelegate.containsAll(coll);
        }

        @Override
        public boolean addAll(ItemCollection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ItemCollection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ItemCollection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CMode getMode() {
            return this.fDelegate.getMode();
        }

        @Override
        public Collection<E> toCollection() {
            return Collections.unmodifiableCollection(this.fDelegate.toCollection());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableItemList<E>
    extends UnmodifiableItemCollection<E>
    implements ItemList<E> {
        UnmodifiableItemList(ItemList<? extends E> s) {
            super(s);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ItemCollection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int index) {
            return ((ItemList)this.fDelegate).get(index);
        }

        @Override
        public int indexOf(Object element) {
            return ((ItemList)this.fDelegate).indexOf(element);
        }

        @Override
        public int lastIndexOf(Object element) {
            return ((ItemList)this.fDelegate).lastIndexOf(element);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new UnmodifiableListIterator(((ItemList)this.fDelegate).listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new UnmodifiableListIterator(((ItemList)this.fDelegate).listIterator(index));
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<E> toList() {
            return Collections.unmodifiableList(((ItemList)this.fDelegate).toList());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class UnmodifiableListIterator<E>
        implements ListIterator<E> {
            private final ListIterator<? extends E> fDelegateIterator;

            UnmodifiableListIterator(ListIterator<? extends E> delegate) {
                this.fDelegateIterator = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.fDelegateIterator.hasNext();
            }

            @Override
            public E next() {
                return this.fDelegateIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasPrevious() {
                return this.fDelegateIterator.hasPrevious();
            }

            @Override
            public int nextIndex() {
                return this.fDelegateIterator.nextIndex();
            }

            @Override
            public E previous() {
                return this.fDelegateIterator.previous();
            }

            @Override
            public int previousIndex() {
                return this.fDelegateIterator.previousIndex();
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableItemMap<K extends IItemHandle, V>
    implements ItemMap<K, V> {
        ItemMap<? extends K, ? extends V> fDelegate;

        UnmodifiableItemMap(ItemMap<? extends K, ? extends V> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.fDelegate = map;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(IItemHandle key) {
            return this.fDelegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.fDelegate.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(((Map)((Object)this.fDelegate)).entrySet());
        }

        @Override
        public V get(IItemHandle key) {
            return this.fDelegate.get(key);
        }

        @Override
        public CMode getMode() {
            return this.fDelegate.getMode();
        }

        @Override
        public boolean isEmpty() {
            return this.fDelegate.isEmpty();
        }

        @Override
        public ItemSet<K> keySet() {
            return ItemCollections.unmodifiableItemSet(this.fDelegate.keySet());
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(ItemMap<K, V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.fDelegate.size();
        }

        @Override
        public ItemCollection<V> values() {
            return ItemCollections.unmodifiableItemCollection(this.fDelegate.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableItemSet<E>
    extends UnmodifiableItemCollection<E>
    implements ItemSet<E> {
        UnmodifiableItemSet(ItemSet<? extends E> s) {
            super(s);
        }

        @Override
        public Set<E> toSet() {
            return Collections.unmodifiableSet(((ItemSet)this.fDelegate).toSet());
        }
    }
}

