/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.AbstractItemCollection;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemAwareMap<K extends IItemHandle, V>
implements ItemMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int HASH_FACTOR = 89;
    CMode fMode;
    Map<UUID, ValueElement<K, V>> fUUID2ValueElement;

    public static <K1 extends IItemHandle, V1> ItemMap<K1, V1> map(CMode mode, Map internalMap) {
        Assert.isLegal((internalMap != null && internalMap.isEmpty() ? 1 : 0) != 0);
        return new ItemAwareMap(mode, internalMap);
    }

    public static <K1 extends IItemHandle, V1> ItemMap<K1, V1> map(Map internalMap) {
        return ItemAwareMap.map(CMode.CURRENT, internalMap);
    }

    protected ItemAwareMap(CMode mode, Map<UUID, ValueElement<K, V>> uuid2ValueMap) {
        this.fMode = mode;
        this.fUUID2ValueElement = uuid2ValueMap;
    }

    @Override
    public CMode getMode() {
        return this.fMode;
    }

    @Override
    public void clear() {
        this.fUUID2ValueElement.clear();
    }

    protected ItemAwareMap<K, V> clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public boolean containsKey(IItemHandle key) {
        return this.fUUID2ValueElement.containsKey(this.fMode.getUUID(key));
    }

    @Override
    public boolean containsValue(Object value) {
        for (ValueElement<K, V> element : this.fUUID2ValueElement.values()) {
            if (!this.fMode.matches(value, element.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ItemAwareMap other = (ItemAwareMap)o;
        if (this.fMode != other.fMode || this.size() != other.size()) {
            return false;
        }
        for (Map.Entry<UUID, ValueElement<K, V>> entry : this.fUUID2ValueElement.entrySet()) {
            ValueElement<K, V> otherValueElement = other.fUUID2ValueElement.get(entry.getKey());
            if (otherValueElement == null) {
                return false;
            }
            ValueElement<K, V> thisValueElement = entry.getValue();
            if (this.fMode.equals(thisValueElement.getOriginalKey(), otherValueElement.getOriginalKey()) && this.fMode.equals(thisValueElement.getValue(), otherValueElement.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(IItemHandle key) {
        ValueElement<K, V> valueElement = this.fUUID2ValueElement.get(this.fMode.getUUID(key));
        if (valueElement == null) {
            return null;
        }
        return valueElement.getValue();
    }

    public int hashCode() {
        return this.fMode.hashCode() * 89 + this.fUUID2ValueElement.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.fUUID2ValueElement.isEmpty();
    }

    @Override
    public ItemSet<K> keySet() {
        return new KeySet();
    }

    @Override
    public V put(K key, V value) {
        UUID uuidKey = this.fMode.getUUID(key);
        ValueElement<K, V> oldValueElement = this.fUUID2ValueElement.put(uuidKey, new ValueElement<K, V>(key, value));
        return oldValueElement != null ? (V)oldValueElement.getValue() : null;
    }

    @Override
    public void putAll(ItemMap<K, V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put((IItemHandle)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        UUID uuidKey = this.fMode.getUUID(key);
        ValueElement<K, V> valueElement = this.fUUID2ValueElement.remove(uuidKey);
        if (valueElement == null) {
            return null;
        }
        return valueElement.getValue();
    }

    @Override
    public int size() {
        return this.fUUID2ValueElement.size();
    }

    @Override
    public ItemCollection<V> values() {
        return new ValueCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private static final long serialVersionUID = 1L;

        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator = ItemAwareMap.this.fUUID2ValueElement.entrySet().iterator();
            return new EntrySetIterator(iterator);
        }

        @Override
        public int size() {
            return ItemAwareMap.this.fUUID2ValueElement.size();
        }

        @Override
        public boolean remove(Object entry) {
            if (!(entry instanceof ItemEntry)) {
                return false;
            }
            Map.Entry uuidEntry = ((ItemEntry)entry).getUUIDEntry();
            return ItemAwareMap.this.fUUID2ValueElement.remove(uuidEntry.getKey()) != null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySetIterator
        implements Iterator<Map.Entry<K, V>> {
            private Iterator<Map.Entry<UUID, ValueElement<K, V>>> fUUIDIterator;
            private ItemEntry<K, V> fCurrent;

            public EntrySetIterator(Iterator<Map.Entry<UUID, ValueElement<K, V>>> iterator) {
                this.fUUIDIterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.fUUIDIterator.hasNext();
            }

            @Override
            public ItemEntry<K, V> next() {
                Map.Entry entry = this.fUUIDIterator.next();
                ValueElement value = entry.getValue();
                IItemHandle originalKey = (IItemHandle)value.getOriginalKey();
                this.fCurrent = new ItemEntry(originalKey, entry);
                return this.fCurrent;
            }

            @Override
            public void remove() {
                if (this.fCurrent == null) {
                    throw new IllegalStateException();
                }
                EntrySet.this.remove(this.fCurrent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ItemEntry<K extends IItemHandle, V>
    implements Map.Entry<K, V> {
        private K fKey;
        private Map.Entry<UUID, ValueElement<K, V>> fUUIDEntry;

        public ItemEntry(K key, Map.Entry<UUID, ValueElement<K, V>> uuidEntry) {
            this.fKey = key;
            this.fUUIDEntry = uuidEntry;
        }

        @Override
        public K getKey() {
            return this.fKey;
        }

        @Override
        public V getValue() {
            return this.fUUIDEntry.getValue().getValue();
        }

        @Override
        public V setValue(V value) {
            return this.fUUIDEntry.getValue().setValue(value);
        }

        public Map.Entry<UUID, ValueElement<K, V>> getUUIDEntry() {
            return this.fUUIDEntry;
        }

        @Override
        public int hashCode() {
            return this.fUUIDEntry.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.fUUIDEntry.equals(((ItemEntry)obj).fUUIDEntry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ItemHashMapAbstractCollection<E>
    extends AbstractItemCollection<E> {
        private ItemHashMapAbstractCollection() {
        }

        @Override
        public CMode getMode() {
            return ItemAwareMap.this.fMode;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ItemCollection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ItemAwareMap.this.fUUID2ValueElement.clear();
        }

        @Override
        public boolean isEmpty() {
            return ItemAwareMap.this.fUUID2ValueElement.isEmpty();
        }

        @Override
        public int size() {
            return ItemAwareMap.this.fUUID2ValueElement.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends ItemHashMapAbstractCollection<K>
    implements ItemSet<K> {
        private KeySet() {
        }

        @Override
        public boolean contains(Object element) {
            if (!(element instanceof IItemHandle)) {
                return false;
            }
            UUID uuid = ItemAwareMap.this.fMode.getUUID(element);
            ValueElement valueElement = ItemAwareMap.this.fUUID2ValueElement.get(uuid);
            if (valueElement == null) {
                return false;
            }
            IItemHandle originalKey = (IItemHandle)valueElement.getOriginalKey();
            return ItemAwareMap.this.fMode.matches(element, originalKey);
        }

        @Override
        public Iterator<K> iterator() {
            Iterator<UUID> iterator = ItemAwareMap.this.fUUID2ValueElement.keySet().iterator();
            return new KeySetIterator(iterator);
        }

        @Override
        public boolean remove(Object element) {
            UUID uuid = ItemAwareMap.this.fMode.getUUID(element);
            return ItemAwareMap.this.fUUID2ValueElement.remove(uuid) != null;
        }

        @Override
        public <T> T[] toArray(T[] toFill) {
            if (toFill.length < this.size()) {
                toFill = (Object[])Array.newInstance(toFill.getClass().getComponentType(), this.size());
            }
            int index = 0;
            for (ValueElement value : ItemAwareMap.this.fUUID2ValueElement.values()) {
                toFill[index] = value.getOriginalKey();
                ++index;
            }
            return toFill;
        }

        @Override
        public Set<K> toSet() {
            HashSet<IItemHandle> result = new HashSet<IItemHandle>(ItemAwareMap.this.fUUID2ValueElement.size());
            for (ValueElement value : ItemAwareMap.this.fUUID2ValueElement.values()) {
                result.add((IItemHandle)value.getOriginalKey());
            }
            return result;
        }

        @Override
        public Collection<K> toCollection() {
            return this.toSet();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeySetIterator
        implements Iterator<K> {
            private Iterator<UUID> fUUIDKeyIterator;
            private UUID fCurrent;

            public KeySetIterator(Iterator<UUID> iterator) {
                this.fUUIDKeyIterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.fUUIDKeyIterator.hasNext();
            }

            @Override
            public K next() {
                this.fCurrent = this.fUUIDKeyIterator.next();
                ValueElement value = ((KeySet)KeySet.this).ItemAwareMap.this.fUUID2ValueElement.get(this.fCurrent);
                return (IItemHandle)value.getOriginalKey();
            }

            @Override
            public void remove() {
                ((KeySet)KeySet.this).ItemAwareMap.this.fUUID2ValueElement.remove(this.fCurrent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueCollection
    extends ItemHashMapAbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public boolean contains(Object element) {
            for (ValueElement value : ItemAwareMap.this.fUUID2ValueElement.values()) {
                if (!ItemAwareMap.this.fMode.matches(element, value.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueCollectionIterator(ItemAwareMap.this.fUUID2ValueElement.values().iterator());
        }

        @Override
        public boolean remove(Object element) {
            for (Map.Entry entry : ItemAwareMap.this.fUUID2ValueElement.entrySet()) {
                if (!ItemAwareMap.this.fMode.matches(element, entry.getValue().getValue())) continue;
                return ItemAwareMap.this.fUUID2ValueElement.remove(entry.getKey()) != null;
            }
            return false;
        }

        @Override
        public <T> T[] toArray(T[] toFill) {
            if (toFill.length < this.size()) {
                toFill = (Object[])Array.newInstance(toFill.getClass().getComponentType(), this.size());
            }
            int index = 0;
            for (ValueElement value : ItemAwareMap.this.fUUID2ValueElement.values()) {
                toFill[index] = value.getValue();
                ++index;
            }
            return toFill;
        }

        @Override
        public Collection<V> toCollection() {
            ArrayList result = new ArrayList(ItemAwareMap.this.fUUID2ValueElement.size());
            for (ValueElement value : ItemAwareMap.this.fUUID2ValueElement.values()) {
                result.add(value.getValue());
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ValueCollectionIterator
        implements Iterator<V> {
            private Iterator<ValueElement<K, V>> fValueElementIterator;
            private ValueElement<K, V> fCurrent;

            public ValueCollectionIterator(Iterator<ValueElement<K, V>> iterator) {
                this.fValueElementIterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.fValueElementIterator.hasNext();
            }

            @Override
            public V next() {
                this.fCurrent = this.fValueElementIterator.next();
                return this.fCurrent.getValue();
            }

            @Override
            public void remove() {
                Object key = this.fCurrent.getOriginalKey();
                ItemAwareMap.this.remove(key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueElement<K, V> {
        private K fOriginalKey;
        private V fValue;

        public ValueElement(K originalKey, V value) {
            this.fOriginalKey = originalKey;
            this.fValue = value;
        }

        public K getOriginalKey() {
            return this.fOriginalKey;
        }

        public V getValue() {
            return this.fValue;
        }

        public V setValue(V value) {
            V oldValue = this.fValue;
            this.fValue = value;
            return oldValue;
        }
    }
}

