/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataQueryRowIterator {
    private final IQueryService fQueryService;
    private IDataQueryPage fCurrentPage;
    private int fRow;

    public DataQueryRowIterator(IQueryService queryService, IDataQuery dataQuery, List<?> parameters) throws TeamRepositoryException {
        this(queryService, dataQuery, parameters.toArray(), 512);
    }

    public DataQueryRowIterator(IQueryService queryService, IDataQuery dataQuery, Object[] parameters) throws TeamRepositoryException {
        this(queryService, dataQuery, parameters, 512);
    }

    public DataQueryRowIterator(IQueryService queryService, IDataQuery dataQuery, Object[] parameters, int pageSize) throws TeamRepositoryException {
        this.fQueryService = queryService;
        this.fCurrentPage = this.fQueryService.queryData(dataQuery, parameters, pageSize);
        this.fRow = 0;
    }

    public boolean hasNext() throws TeamRepositoryException {
        return this.fCurrentPage != null && this.fRow < this.fCurrentPage.getSize() || this.fetchNextPage();
    }

    public IDataRow next() throws TeamRepositoryException {
        return this.hasNext() ? this.fCurrentPage.getRow(this.fRow++) : null;
    }

    private boolean fetchNextPage() throws TeamRepositoryException {
        if (this.fCurrentPage == null) {
            return false;
        }
        if (this.fCurrentPage.hasNext()) {
            this.fCurrentPage = (IDataQueryPage)this.fQueryService.fetchPage(this.fCurrentPage.getToken(), this.fCurrentPage.getNextStartPosition(), this.fCurrentPage.getSize());
            this.fRow = 0;
        } else {
            this.fCurrentPage = null;
            this.fRow = 0;
        }
        return this.hasNext();
    }
}

