/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.common.resource.ResourcePlanningUtils;
import com.ibm.team.apt.internal.common.BookedTimeType;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.Timespan;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorktimeScheduler
implements IWorkHoursDefinition {
    private final IWorkLocationDefinition fWorkLocation;
    private final TimeZone fWorkTimeZone;
    private final Locale fWorkLocale;
    private final IWorkDayDefinition[] fWorkDays;
    private final Set<BookedTimeType> fBookedTimeTypes = new HashSet<BookedTimeType>();
    private final Set<IBookedTime> fBookedTime = new HashSet<IBookedTime>();
    private final List<BookedTimespan> fBookedTimespans = new ArrayList<BookedTimespan>();
    private final Comparator<BookedTimespan> fTimespanInsertComparator = new Comparator<BookedTimespan>(){

        @Override
        public int compare(BookedTimespan e1, BookedTimespan e2) {
            if (e1.getEnd().compareTo(e2.getStart()) < 0) {
                return -1;
            }
            if (e1.getStart().compareTo(e2.getEnd()) > 0) {
                return 1;
            }
            int result = e1.getStart().compareTo(e2.getStart());
            if (result == 0) {
                result = e1.getEnd().compareTo(e2.getEnd());
            }
            return result;
        }
    };

    public WorktimeScheduler(IWorkLocationDefinition workLocationDefinition) {
        this.fWorkLocation = workLocationDefinition;
        this.fWorkLocale = ResourcePlanningUtils.getLocale(workLocationDefinition);
        this.fWorkTimeZone = ResourcePlanningUtils.getTimeZone(workLocationDefinition);
        this.fWorkDays = new IWorkDayDefinition[7];
        Iterator<IWorkDayDefinition> iterator = this.fWorkLocation.getWorkDays().iterator();
        while (iterator.hasNext()) {
            IWorkDayDefinition workDay;
            this.fWorkDays[workDay.getDay().getValue() - 1] = workDay = iterator.next();
        }
    }

    public long calcutateWorkingTime(Timespan span) {
        Assert.isNotNull((Object)span);
        Assert.isNotNull((Object)span.getStart());
        Assert.isNotNull((Object)span.getEnd());
        Assert.isTrue((span.getStart().before(span.getEnd()) || span.getStart().equals(span.getEnd()) ? 1 : 0) != 0);
        Date start = span.getStart();
        Date end = span.getEnd();
        if (span.getStart().equals(span.getEnd())) {
            return 0L;
        }
        long duration = 0L;
        Date current = new Date(this.setToDayStart(this.getCalendarInstance(start.getTime())).getTimeInMillis());
        while (!current.after(end)) {
            Timespan dayHrs = this.getWorkingHours(current);
            if (dayHrs != null) {
                duration += dayHrs.getEnd().getTime() - dayHrs.getStart().getTime();
            }
            current.setTime(current.getTime() + 86400000L);
        }
        return duration;
    }

    public Date calculateWorkStart(Date referenceTime) {
        return this.calculateWorkStart(referenceTime, this.fBookedTimeTypes);
    }

    public Date calculateWorkStart(Date referenceTime, Collection<BookedTimeType> bookedTimeToConsider) {
        return this.doCalculateTimeSpan(referenceTime, 0L, true, bookedTimeToConsider).getStart();
    }

    public Timespan calculateTimeSpan(Date planned, long duration, boolean forward) {
        return this.calculateTimeSpan(planned, duration, forward, this.fBookedTimeTypes);
    }

    public Timespan calculateTimeSpan(Date planned, long duration, boolean forward, Collection<BookedTimeType> bookedTimeToConsider) {
        return this.doCalculateTimeSpan(planned, duration, forward, bookedTimeToConsider);
    }

    public Collection<IBookedTime> getBookedTime() {
        return this.getBookedTime(this.fBookedTimeTypes);
    }

    public Collection<IBookedTime> getBookedTime(Collection<BookedTimeType> typesToConsider) {
        if (this.fBookedTimeTypes.equals(typesToConsider)) {
            return Collections.unmodifiableCollection(this.fBookedTime);
        }
        ArrayList<IBookedTime> result = new ArrayList<IBookedTime>(this.fBookedTime.size());
        for (IBookedTime bookedTime : this.fBookedTime) {
            if (!typesToConsider.contains(bookedTime.getType())) continue;
            result.add(bookedTime);
        }
        return result;
    }

    public void addBookedTime(IBookedTime bookedTime) {
        if (this.fBookedTime.add(bookedTime)) {
            BookedTimespan normalized;
            int insertionIndex;
            this.fBookedTimeTypes.add(bookedTime.getType());
            Calendar startCalendar = this.getCalendarInstance(bookedTime.getStart().getTime());
            Calendar endCalendar = this.getCalendarInstance(bookedTime.getEnd().getTime());
            if (bookedTime.getType() == BookedTimeType.OUT_OF_OFFICE) {
                this.setToDayStart(startCalendar);
                endCalendar.add(6, 1);
                this.setToDayStart(endCalendar);
                endCalendar.add(14, -1);
            }
            if ((insertionIndex = Collections.binarySearch(this.fBookedTimespans, normalized = new BookedTimespan(startCalendar.getTime(), endCalendar.getTime(), bookedTime), this.fTimespanInsertComparator)) < 0) {
                insertionIndex = -insertionIndex - 1;
            }
            this.fBookedTimespans.add(insertionIndex, normalized);
        }
    }

    public void removeBookedTime(IBookedTime absence) {
        if (this.fBookedTime.remove(absence)) {
            Iterator<BookedTimespan> iterator = this.fBookedTimespans.iterator();
            while (iterator.hasNext()) {
                BookedTimespan bookedTimespan = iterator.next();
                if (!absence.equals(bookedTimespan.getOriginalEntry())) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.fWorkLocale;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.fWorkTimeZone;
    }

    @Override
    public Calendar getCalendarInstance() {
        return Calendar.getInstance(this.fWorkTimeZone, this.fWorkLocale);
    }

    @Override
    public Calendar getCalendarInstance(long time) {
        Calendar result = this.getCalendarInstance();
        result.setTimeInMillis(time);
        return result;
    }

    private Timespan doCalculateTimeSpan(Date planned, long duration, boolean forward, Collection<BookedTimeType> typesToConsider) {
        int bookedTimeStart = forward ? 0 : this.fBookedTimespans.size() - 1;
        int bookedTimeLength = this.fBookedTimespans.size();
        int bookedTimeIndex = 0;
        Calendar cal = this.getCalendarInstance(planned.getTime());
        long toGo = Math.max(duration, 1L);
        Date start = null;
        Date end = null;
        do {
            long workDuration;
            boolean retryToday = false;
            long workDayStart = 0L;
            long workDayEnd = 0L;
            while (true) {
                IWorkDayDefinition workDay;
                if ((workDay = this.fWorkDays[cal.get(7) - 1]) != null && workDay.getWorkingTime() > 0L) {
                    long now = cal.getTimeInMillis();
                    workDayEnd = workDay.getEndTime() + (now - this.getDayRelativeTime(cal));
                    workDayStart = workDayEnd - workDay.getWorkingTime();
                    if (forward) {
                        if (now > workDayEnd) {
                            workDayStart = workDayEnd;
                        } else if (now > workDayStart) {
                            workDayStart = now;
                        }
                    } else if (now < workDayStart) {
                        workDayEnd = workDayStart;
                    } else if (now < workDayEnd) {
                        workDayEnd = now;
                    }
                    if (workDayStart < workDayEnd && !typesToConsider.isEmpty()) {
                        while (bookedTimeIndex < bookedTimeLength) {
                            BookedTimespan bookedTimespan = this.fBookedTimespans.get(Math.abs(bookedTimeStart - bookedTimeIndex));
                            if (typesToConsider.contains(bookedTimespan.getOriginalEntry().getType())) {
                                long absenceStart = bookedTimespan.getStart().getTime();
                                long absenceEnd = bookedTimespan.getEnd().getTime();
                                if (!(forward && absenceEnd <= Math.max(workDayStart, now) || !forward && absenceStart >= Math.min(workDayEnd, now))) {
                                    boolean absenceEndsToday;
                                    if (forward && absenceStart > workDayEnd || !forward && absenceEnd <= workDayStart) break;
                                    boolean absenceStartsToday = absenceStart > workDayStart;
                                    boolean bl = absenceEndsToday = absenceEnd <= workDayEnd;
                                    if (forward) {
                                        if (!absenceStartsToday && absenceEndsToday) {
                                            workDayStart = absenceEnd;
                                        } else if (absenceStartsToday) {
                                            workDayEnd = absenceStart;
                                        } else if (!absenceStartsToday && !absenceEndsToday) {
                                            workDayStart = workDayEnd;
                                        }
                                    } else if (!absenceEndsToday && absenceStartsToday) {
                                        workDayEnd = absenceStart;
                                    } else if (absenceEndsToday) {
                                        workDayStart = absenceEnd;
                                    } else if (!absenceStartsToday && !absenceEndsToday) {
                                        workDayEnd = workDayStart;
                                    }
                                    if (absenceStartsToday && absenceEndsToday) {
                                        retryToday = true;
                                    }
                                    now = forward ? absenceEnd : absenceStart;
                                }
                            }
                            ++bookedTimeIndex;
                        }
                    }
                    cal.setTimeInMillis(now);
                }
                if (workDayStart != workDayEnd) break;
                this.advanceDay(cal, forward);
            }
            if (start == null) {
                start = new Date(forward ? workDayStart : workDayEnd);
            }
            if (toGo <= (workDuration = workDayEnd - workDayStart)) {
                end = new Date(forward ? workDayStart + toGo : workDayEnd - toGo);
            }
            toGo -= workDuration;
            if (retryToday) continue;
            this.advanceDay(cal, forward);
        } while (end == null);
        return forward ? new Timespan(start, end) : new Timespan(end, start);
    }

    @Override
    public Timespan getWorkingHours(Date day) {
        Calendar cal = this.getCalendarInstance(day.getTime());
        IWorkDayDefinition workDay = this.fWorkDays[cal.get(7) - 1];
        if (workDay != null && workDay.getWorkingTime() > 0L) {
            long now = cal.getTimeInMillis();
            for (BookedTimespan absence : this.fBookedTimespans) {
                long absenceStart = absence.getStart().getTime();
                long absenceEnd = absence.getEnd().getTime();
                if (absenceStart > now || absenceEnd < now) continue;
                return null;
            }
            this.setToDayStart(cal);
            cal.add(14, (int)workDay.getEndTime());
            Date endTime = new Date(cal.getTimeInMillis());
            cal.add(14, -((int)workDay.getWorkingTime()));
            Date startTime = new Date(cal.getTimeInMillis());
            return new Timespan(startTime, endTime);
        }
        return null;
    }

    private long getDayRelativeTime(Calendar cal) {
        return ((cal.get(11) * 60 + cal.get(12)) * 60 + cal.get(13)) * 1000 + cal.get(14);
    }

    private void advanceDay(Calendar cal, boolean forward) {
        this.setToDayStart(cal);
        if (forward) {
            cal.add(6, 1);
        } else {
            cal.add(14, -1);
        }
    }

    private Calendar setToDayStart(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private class BookedTimespan
    extends Timespan {
        private final IBookedTime fOriginalEntry;

        public BookedTimespan(Date start, Date end, IBookedTime originalEntry) {
            super(start, end);
            this.fOriginalEntry = originalEntry;
        }

        public IBookedTime getOriginalEntry() {
            return this.fOriginalEntry;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.fOriginalEntry.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj) || this.fOriginalEntry.equals(((BookedTimespan)obj).fOriginalEntry);
        }
    }
}

