/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.Messages;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.duration.TimeUnit;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;

public class ProgressItem {
    private static final Message MSG_NO_ESTIMATES = new Message(Messages.getString("ProgressItem_NO_WORK_ESTIMATED"), Message.Severity.Warning);
    private static final Message MSG_NO_DATA = new Message(Messages.getString("ProgressItem_NO_DATA"), Message.Severity.Warning);
    private static final Message MSG_NO_TIME_LEFT = new Message(Messages.getString("ProgressItem_NO_WORK_TIME_LEFT"), Message.Severity.Warning);
    private static final Message MSG_LOADING_PROGRESS = new Message(Messages.getString("ProgressItem_COMPUTING_PROGRESS"), Message.Severity.Information);
    private Kind fKind;
    private ProgressInformation fInput;
    private static boolean AND = true;
    private static boolean OR = false;

    public static ProgressItem create(ProgressInformation information) {
        return new ProgressItem(information, false);
    }

    public static ProgressItem create(ProgressInformation information, boolean loading) {
        return new ProgressItem(information, loading);
    }

    private ProgressItem(ProgressInformation input, boolean computing) {
        Assert.isNotNull((Object)input);
        this.fInput = input;
        this.fKind = computing ? Kind.LOADING : (this.getOpenCount() == 0 && this.getCloseCount() > 0 ? Kind.DONE : (this.getMessage() != null ? Kind.MESSAGE : (ProgressItem.isDefault(AND, input.getRealTimeDone(), input.getRealTimeLeft()) ? Kind.BAR : Kind.BAR_WITH_PROJECTION)));
    }

    private static boolean isDefault(boolean and, double first, double ... rest) {
        if (first <= 0.0 == !and) {
            return !and;
        }
        double[] dArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            if (i <= 0.0 == !and) {
                return !and;
            }
            ++n2;
        }
        return and;
    }

    public Kind getKind() {
        return this.fKind;
    }

    public ProgressInformation getProgressInformation() {
        return this.fInput;
    }

    public Message getMessage() {
        if (this.fKind == Kind.LOADING) {
            return MSG_LOADING_PROGRESS;
        }
        if (ProgressItem.isDefault(AND, this.fInput.getWorkHoursLeft(), this.fInput.getWorkHoursDone(), this.fInput.getRealTimeDone(), this.fInput.getRealTimeLeft(), this.fInput.getOpenCount(), this.fInput.getCloseCount())) {
            return MSG_NO_DATA;
        }
        if (ProgressItem.isDefault(AND, this.fInput.getQualityOfPlanning(), new double[0])) {
            return MSG_NO_ESTIMATES;
        }
        return null;
    }

    public float getWorkHoursRatio() {
        long workHoursDone = this.fInput.getWorkHoursDone();
        long workHoursTimeTotal = workHoursDone + this.fInput.getWorkHoursLeft();
        if (workHoursTimeTotal == 0L) {
            return 0.0f;
        }
        return (float)workHoursDone / (float)workHoursTimeTotal;
    }

    public float getRealTimeRatio() {
        long realTimeDone = this.fInput.getRealTimeDone();
        long realTimeTotal = realTimeDone + this.fInput.getRealTimeLeft();
        if (realTimeTotal == 0L) {
            return 0.0f;
        }
        return (float)realTimeDone / (float)realTimeTotal;
    }

    public float getProjection() {
        return this.getWorkHoursRatio() - this.getRealTimeRatio();
    }

    public long getAheadTime(TimeUnit unit) {
        return Math.round((double)((float)this.getWorkHoursTotal(TimeUnit.MILLI_SECONDS) * this.getProjection()) / unit.getDivisor());
    }

    public long getExpectedWorkHours(TimeUnit unit) {
        return Math.round((double)((float)this.fInput.getWorkHoursDone() - (float)(this.fInput.getWorkHoursDone() + this.fInput.getWorkHoursLeft()) * this.getProjection()) / unit.getDivisor());
    }

    public boolean isAhead() {
        return this.getProjection() > 0.0f;
    }

    public long getRealTimeDone(TimeUnit unit) {
        return Math.round((double)this.fInput.getRealTimeDone() / unit.getDivisor());
    }

    public long getRealTimeLeft(TimeUnit unit) {
        return Math.round((double)this.fInput.getRealTimeLeft() / unit.getDivisor());
    }

    public long getWorkHoursDone(TimeUnit unit) {
        return Math.round((double)this.fInput.getWorkHoursDone() / unit.getDivisor());
    }

    public long getWorkHoursLeft(TimeUnit unit) {
        return Math.round((double)this.fInput.getWorkHoursLeft() / unit.getDivisor());
    }

    public long getWorkHoursTotal(TimeUnit unit) {
        return Math.round((double)(this.fInput.getWorkHoursDone() + this.fInput.getWorkHoursLeft()) / unit.getDivisor());
    }

    public int getOpenCount() {
        return this.fInput.getOpenCount();
    }

    public int getCloseCount() {
        return this.fInput.getCloseCount();
    }

    public int getTotalCount() {
        return this.fInput.getOpenCount() + this.fInput.getCloseCount();
    }

    public float getQualityOfPlanning() {
        return Math.round(this.fInput.getQualityOfPlanning());
    }

    public String getTextQualityOfPlanning() {
        if (this.getKind() == Kind.DONE) {
            return Messages.getString("ProgressItem_ESTIMATED_DONE");
        }
        return MessageFormat.format(Messages.getString("ProgressItem_PROGRESS_QUALITY_OF_PLANNING"), Float.valueOf(this.getQualityOfPlanning()));
    }

    public String getTextHours() {
        if (this.getKind() == Kind.BAR_WITH_PROJECTION) {
            Long hoursDone = this.getWorkHoursDone(TimeUnit.HOURS);
            Long hoursTotal = this.getWorkHoursTotal(TimeUnit.HOURS);
            StringBuilder text = new StringBuilder();
            if (this.isAhead()) {
                text.append('+');
            }
            text.append(this.getAheadTime(TimeUnit.HOURS));
            return MessageFormat.format(Messages.getString("ProgressItem_PROGRESS_HOURS"), hoursDone, hoursTotal, text);
        }
        Long hoursDone = this.getWorkHoursDone(TimeUnit.HOURS);
        Long hoursTotal = this.getWorkHoursTotal(TimeUnit.HOURS);
        return MessageFormat.format(Messages.getString("ProgressItem_PROGRESS_HOURS_SHORT"), hoursDone, hoursTotal);
    }

    public String getMaxTextHours(boolean forceProjection) {
        if (this.getKind() == Kind.BAR_WITH_PROJECTION || forceProjection) {
            return MessageFormat.format(Messages.getString("ProgressItem_PROGRESS_HOURS"), 9999, 9999, "9999");
        }
        return MessageFormat.format(Messages.getString("ProgressItem_PROGRESS_HOURS_SHORT"), 9999, 9999);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        BAR_WITH_PROJECTION,
        BAR,
        MESSAGE,
        LOADING,
        DONE;

    }
}

