/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.CategoryKey;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Hierarchy$$Cold;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.ProvisionNode;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;

public class Hierarchy
implements LoggerRepository,
RendererSupport {
    private LoggerFactory defaultFactory;
    private Vector listeners;
    Hashtable ht = new Hashtable();
    Logger root;
    RendererMap rendererMap;
    int thresholdInt;
    Level threshold;
    boolean emittedNoAppenderWarning = false;
    boolean emittedNoResourceBundleWarning = false;

    public Hierarchy(Logger logger) {
        this.listeners = new Vector(1);
        this.root = logger;
        this.setThreshold(Level.ALL);
        ((Category)this.root).setHierarchy(this);
        this.rendererMap = new RendererMap();
        this.defaultFactory = new DefaultCategoryFactory();
    }

    public void addRenderer(Class clazz, ObjectRenderer objectRenderer) {
        this.rendererMap.put(clazz, objectRenderer);
    }

    public void clear() {
        this.ht.clear();
    }

    public Enumeration getCurrentCategories() {
        return this.getCurrentLoggers();
    }

    public Logger getLogger(String string) {
        return this.getLogger(string, this.defaultFactory);
    }

    public Logger getLogger(String string, LoggerFactory loggerFactory) {
        CategoryKey categoryKey = new CategoryKey(string);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Object v = this.ht.get(categoryKey);
            if (v == null) {
                Logger logger = loggerFactory.makeNewLoggerInstance(string);
                ((Category)logger).setHierarchy(this);
                this.ht.put(categoryKey, logger);
                this.updateParents(logger);
                Logger logger2 = logger;
                return logger2;
            }
            if (v instanceof Logger) {
                Logger logger = (Logger)v;
                return logger;
            }
            if (v instanceof ProvisionNode) {
                Logger logger = loggerFactory.makeNewLoggerInstance(string);
                ((Category)logger).setHierarchy(this);
                this.ht.put(categoryKey, logger);
                this.updateChildren((ProvisionNode)v, logger);
                this.updateParents(logger);
                Logger logger3 = logger;
                return logger3;
            }
            Logger logger = null;
            return logger;
        }
    }

    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    public Logger getRootLogger() {
        return this.root;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public boolean isDisabled(int n) {
        return this.thresholdInt > n;
    }

    public void overrideAsNeeded(String string) {
        LogLog.warn("The Hiearchy.overrideAsNeeded method has been deprecated.");
    }

    public void setDisableOverride(String string) {
        LogLog.warn("The Hiearchy.setDisableOverride method has been deprecated.");
    }

    public void setRenderer(Class clazz, ObjectRenderer objectRenderer) {
        this.rendererMap.put(clazz, objectRenderer);
    }

    public void setThreshold(Level level) {
        if (level != null) {
            this.thresholdInt = ((Priority)level).level;
            this.threshold = level;
        }
    }

    private final void updateParents(Logger logger) {
        String string = ((Category)logger).name;
        int n = string.length();
        boolean bl = false;
        int n2 = string.lastIndexOf(46, n - 1);
        while (n2 >= 0) {
            Serializable serializable;
            String string2 = string.substring(0, n2);
            CategoryKey categoryKey = new CategoryKey(string2);
            Object v = this.ht.get(categoryKey);
            if (v == null) {
                serializable = new ProvisionNode(logger);
                this.ht.put(categoryKey, serializable);
            } else {
                if (v instanceof Category) {
                    bl = true;
                    ((Category)logger).parent = (Category)v;
                    break;
                }
                if (v instanceof ProvisionNode) {
                    ((Vector)v).addElement(logger);
                } else {
                    serializable = new IllegalStateException("unexpected object type " + v.getClass() + " in ht.");
                    ((Throwable)serializable).printStackTrace();
                }
            }
            n2 = string.lastIndexOf(46, n2 - 1);
        }
        if (!bl) {
            ((Category)logger).parent = this.root;
        }
    }

    public void addHierarchyEventListener(HierarchyEventListener hierarchyEventListener) {
        if (this.listeners.contains(hierarchyEventListener)) {
            LogLog.warn("Ignoring attempt to add an existent listener.");
        } else {
            this.listeners.addElement(hierarchyEventListener);
        }
    }

    public void emitNoAppenderWarning(Category category) throws  {
        Hierarchy$$Cold.emitNoAppenderWarning(this, category);
    }

    public Logger exists(String string) throws  {
        return Hierarchy$$Cold.exists(this, string);
    }

    public void fireAddAppenderEvent(Category category, Appender appender) {
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                HierarchyEventListener hierarchyEventListener = (HierarchyEventListener)this.listeners.elementAt(n2);
                hierarchyEventListener.addAppenderEvent(category, appender);
                ++n2;
            }
        }
    }

    void fireRemoveAppenderEvent(Category category, Appender appender) {
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                HierarchyEventListener hierarchyEventListener = (HierarchyEventListener)this.listeners.elementAt(n2);
                hierarchyEventListener.removeAppenderEvent(category, appender);
                ++n2;
            }
        }
    }

    public Enumeration getCurrentLoggers() throws  {
        return Hierarchy$$Cold.getCurrentLoggers(this);
    }

    public void resetConfiguration() throws  {
        Hierarchy$$Cold.resetConfiguration(this);
    }

    public void setThreshold(String string) throws  {
        Hierarchy$$Cold.setThreshold(this, string);
    }

    public void shutdown() throws  {
        Hierarchy$$Cold.shutdown(this);
    }

    private final void updateChildren(ProvisionNode provisionNode, Logger logger) throws  {
        Hierarchy$$Cold.updateChildren(this, provisionNode, logger);
    }
}

